/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.Transition;
import com.facebook.litho.TransitionSet;
import com.facebook.litho.animation.AnimationBinding;
import com.facebook.litho.animation.DelayBinding;
import java.util.List;

public class DelayTransitionSet
extends TransitionSet {
    private final int mDelayMs;

    public <T extends Transition> DelayTransitionSet(int delayMs, T transition) {
        super(new Transition[]{transition});
        this.mDelayMs = delayMs;
    }

    @Override
    AnimationBinding createAnimation(List<AnimationBinding> children) {
        if (children.size() != 1) {
            throw new IllegalArgumentException("DelayTransitionSet is expected to have exactly one child, provided=" + children);
        }
        return new DelayBinding(this.mDelayMs, children.get(0));
    }
}

