/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.incrementalmount;

import android.graphics.Rect;
import androidx.annotation.Nullable;
import com.facebook.rendercore.Node;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.rendercore.RenderUnit;
import com.facebook.rendercore.extensions.LayoutResultVisitor;
import com.facebook.rendercore.extensions.MountExtension;
import com.facebook.rendercore.extensions.RenderCoreExtension;
import com.facebook.rendercore.incrementalmount.IncrementalMountExtension;
import com.facebook.rendercore.incrementalmount.IncrementalMountExtensionInput;
import com.facebook.rendercore.incrementalmount.IncrementalMountOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class IncrementalMountRenderCoreExtension
extends RenderCoreExtension<IncrementalMountExtensionInput, IncrementalMountExtension.IncrementalMountExtensionState> {
    public static final Comparator<IncrementalMountOutput> sTopsComparator = new Comparator<IncrementalMountOutput>(){

        @Override
        public int compare(IncrementalMountOutput l, IncrementalMountOutput r) {
            int lhsTop = l.getBounds().top;
            int rhsTop = r.getBounds().top;
            if (lhsTop == rhsTop) {
                if (l.getIndex() == r.getIndex()) {
                    return 0;
                }
                return l.getIndex() > r.getIndex() ? 1 : -1;
            }
            return lhsTop > rhsTop ? 1 : -1;
        }
    };
    public static final Comparator<IncrementalMountOutput> sBottomsComparator = new Comparator<IncrementalMountOutput>(){

        @Override
        public int compare(IncrementalMountOutput l, IncrementalMountOutput r) {
            int lhsBottom = l.getBounds().bottom;
            int rhsBottom = r.getBounds().bottom;
            if (lhsBottom == rhsBottom) {
                if (r.getIndex() == l.getIndex()) {
                    return 0;
                }
                return r.getIndex() > l.getIndex() ? 1 : -1;
            }
            return lhsBottom > rhsBottom ? 1 : -1;
        }
    };
    private final Visitor mLayoutResultVisitor;
    private static final IncrementalMountExtension mMountExtension = IncrementalMountExtension.getInstance(false);

    public IncrementalMountRenderCoreExtension(InputProvider<?> provider) {
        this.mLayoutResultVisitor = new Visitor(provider);
    }

    public LayoutResultVisitor<Results> getLayoutVisitor() {
        return this.mLayoutResultVisitor;
    }

    public MountExtension<IncrementalMountExtensionInput, IncrementalMountExtension.IncrementalMountExtensionState> getMountExtension() {
        return mMountExtension;
    }

    public Results createInput() {
        return new Results();
    }

    public static interface InputProvider<R extends Node.LayoutResult<?>> {
        public boolean hasRenderTreeHosts(R var1);
    }

    public static class Visitor
    implements LayoutResultVisitor<Results> {
        private final InputProvider provider;

        public Visitor(InputProvider provider) {
            this.provider = provider;
        }

        public void visit(@Nullable RenderTreeNode parent, Node.LayoutResult<?> result, Rect bounds, int x, int y, int position, Results results) {
            if (position == 0) {
                return;
            }
            RenderUnit unit = result.getRenderUnit();
            if (unit == null) {
                return;
            }
            long id = unit.getId();
            if (parent == null) {
                throw new IllegalArgumentException("Parent was null for position=" + position);
            }
            IncrementalMountOutput host = results.getIncrementalMountOutputForId(parent.getRenderUnit().getId());
            Rect rect = new Rect(x, y, x + bounds.width(), y + bounds.height());
            results.addOutput(new IncrementalMountOutput(id, position, rect, host));
            if (this.provider.hasRenderTreeHosts(result)) {
                results.addRenderTreeHostId(id);
            }
        }
    }

    public static class Results
    implements IncrementalMountExtensionInput {
        private final LinkedHashMap<Long, IncrementalMountOutput> outputs = new LinkedHashMap(8);
        private final SortedSet<IncrementalMountOutput> outputsOrderedByTopBounds = new TreeSet<IncrementalMountOutput>(sTopsComparator);
        private final SortedSet<IncrementalMountOutput> outputsOrderedByBottomBounds = new TreeSet<IncrementalMountOutput>(sBottomsComparator);
        private final Set<Long> renderUnitIdsWhichHostRenderTrees = new HashSet<Long>(4);
        @Nullable
        private List<IncrementalMountOutput> outputsOrderedByTopBoundsList;
        @Nullable
        private List<IncrementalMountOutput> outputsOrderedByBottomBoundsList;

        @Override
        public List<IncrementalMountOutput> getOutputsOrderedByTopBounds() {
            this.maybeInitializeList();
            return this.outputsOrderedByTopBoundsList;
        }

        @Override
        public List<IncrementalMountOutput> getOutputsOrderedByBottomBounds() {
            this.maybeInitializeList();
            return this.outputsOrderedByBottomBoundsList;
        }

        @Override
        @Nullable
        public IncrementalMountOutput getIncrementalMountOutputForId(long id) {
            return this.outputs.get(id);
        }

        @Override
        public Collection<IncrementalMountOutput> getIncrementalMountOutputs() {
            return this.outputs.values();
        }

        @Override
        public int getIncrementalMountOutputCount() {
            return this.outputs.size();
        }

        @Override
        public boolean renderUnitWithIdHostsRenderTrees(long id) {
            return this.renderUnitIdsWhichHostRenderTrees.contains(id);
        }

        void addOutput(IncrementalMountOutput output) {
            IncrementalMountOutput existing = this.outputs.put(output.getId(), output);
            if (existing != null) {
                throw new IllegalArgumentException("output with id=" + output.getId() + " already exists.\nindex=" + existing.getIndex() + (existing.getHostOutput() != null ? "\nhostId=" + existing.getHostOutput().getId() : "") + "\nbounds=" + existing.getBounds());
            }
            this.outputsOrderedByTopBounds.add(output);
            this.outputsOrderedByBottomBounds.add(output);
        }

        void addRenderTreeHostId(long id) {
            this.renderUnitIdsWhichHostRenderTrees.add(id);
        }

        private void maybeInitializeList() {
            if (this.outputsOrderedByTopBoundsList == null || this.outputsOrderedByBottomBoundsList == null) {
                this.outputsOrderedByTopBoundsList = new ArrayList<IncrementalMountOutput>(this.outputsOrderedByTopBounds.size());
                this.outputsOrderedByBottomBoundsList = new ArrayList<IncrementalMountOutput>(this.outputsOrderedByBottomBounds.size());
                Iterator topIterator = this.outputsOrderedByTopBounds.iterator();
                Iterator bottomIterator = this.outputsOrderedByBottomBounds.iterator();
                while (topIterator.hasNext() && bottomIterator.hasNext()) {
                    this.outputsOrderedByTopBoundsList.add((IncrementalMountOutput)topIterator.next());
                    this.outputsOrderedByBottomBoundsList.add((IncrementalMountOutput)bottomIterator.next());
                }
            }
        }
    }
}

