/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.incrementalmount;

import android.graphics.Rect;
import androidx.annotation.Nullable;

public class IncrementalMountOutput {
    private final int index;
    @Nullable
    private Rect originalBounds;
    private final Rect bounds;
    private final long id;
    @Nullable
    private final IncrementalMountOutput host;

    public IncrementalMountOutput(long id, int index, Rect bounds, @Nullable IncrementalMountOutput host) {
        this.id = id;
        this.index = index;
        this.bounds = new Rect(bounds);
        this.host = host;
        if (host != null) {
            IncrementalMountOutput.ensureHostBounds(this, host);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public Rect getBounds() {
        return this.bounds;
    }

    @Nullable
    public Rect getOriginalBounds() {
        return this.originalBounds;
    }

    public long getId() {
        return this.id;
    }

    @Nullable
    public IncrementalMountOutput getHostOutput() {
        return this.host;
    }

    private static void ensureHostBounds(IncrementalMountOutput child, @Nullable IncrementalMountOutput host) {
        if (host == null) {
            return;
        }
        Rect childBounds = child.getBounds();
        Rect hostBounds = host.getBounds();
        boolean needsUpdate = false;
        if (childBounds.top < hostBounds.top) {
            IncrementalMountOutput.maybeCacheOriginalBounds(host);
            hostBounds.top = childBounds.top;
            needsUpdate = true;
        }
        if (childBounds.bottom > hostBounds.bottom) {
            IncrementalMountOutput.maybeCacheOriginalBounds(host);
            hostBounds.bottom = childBounds.bottom;
            needsUpdate = true;
        }
        if (childBounds.left < hostBounds.left) {
            IncrementalMountOutput.maybeCacheOriginalBounds(host);
            hostBounds.left = childBounds.left;
            needsUpdate = true;
        }
        if (childBounds.right > hostBounds.right) {
            IncrementalMountOutput.maybeCacheOriginalBounds(host);
            hostBounds.right = childBounds.right;
            needsUpdate = true;
        }
        if (needsUpdate) {
            IncrementalMountOutput.ensureHostBounds(host, host.getHostOutput());
        }
    }

    private static void maybeCacheOriginalBounds(IncrementalMountOutput output) {
        if (output.originalBounds == null) {
            output.originalBounds = new Rect(output.bounds);
        }
    }
}

