/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rendercore.incrementalmount;

import android.graphics.Rect;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.rendercore.ErrorReporter;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.HostNotMountedException;
import com.facebook.rendercore.LogLevel;
import com.facebook.rendercore.RenderCoreSystrace;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.rendercore.RenderUnit;
import com.facebook.rendercore.extensions.ExtensionState;
import com.facebook.rendercore.extensions.MountExtension;
import com.facebook.rendercore.extensions.RenderCoreExtension;
import com.facebook.rendercore.incrementalmount.IncrementalMountExtensionConfigs;
import com.facebook.rendercore.incrementalmount.IncrementalMountExtensionInput;
import com.facebook.rendercore.incrementalmount.IncrementalMountOutput;
import com.facebook.rendercore.incrementalmount.IncrementalMountUtils;
import com.facebook.rendercore.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IncrementalMountExtension
extends MountExtension<IncrementalMountExtensionInput, IncrementalMountExtensionState> {
    private static final IncrementalMountExtension sInstance = new IncrementalMountExtension(false);
    private static final IncrementalMountExtension sInstanceDisableForceAcquireMount = new IncrementalMountExtension(true);
    private final boolean mDisableForceAcquireHostMount;

    private IncrementalMountExtension(boolean disableForceAcquireHostMount) {
        this.mDisableForceAcquireHostMount = disableForceAcquireHostMount;
    }

    public static IncrementalMountExtension getInstance(boolean disableForceAcquireMount) {
        return disableForceAcquireMount ? sInstanceDisableForceAcquireMount : sInstance;
    }

    public IncrementalMountExtensionState createState() {
        return new IncrementalMountExtensionState(this.mDisableForceAcquireHostMount);
    }

    public void beforeMount(ExtensionState<IncrementalMountExtensionState> extensionState, IncrementalMountExtensionInput input, Rect localVisibleRect) {
        IncrementalMountUtils.log("beforeMount");
        RenderCoreSystrace.beginSection((String)"IncrementalMountExtension.beforeMount");
        IncrementalMountExtensionState state = (IncrementalMountExtensionState)extensionState.getState();
        IncrementalMountExtension.releaseAcquiredReferencesForRemovedItems(extensionState, input);
        state.mInput = input;
        state.mPreviousLocalVisibleRect.setEmpty();
        IncrementalMountExtension.setVisibleRect(state, localVisibleRect);
        RenderCoreSystrace.endSection();
    }

    public void afterMount(ExtensionState<IncrementalMountExtensionState> extensionState) {
        IncrementalMountUtils.log("afterMount");
        RenderCoreSystrace.beginSection((String)"IncrementalMountExtension.afterMount");
        IncrementalMountExtensionState state = (IncrementalMountExtensionState)extensionState.getState();
        IncrementalMountExtension.setupPreviousMountableOutputData(state, state.mPreviousLocalVisibleRect);
        RenderCoreSystrace.endSection();
    }

    public void beforeMountItem(ExtensionState<IncrementalMountExtensionState> extensionState, RenderTreeNode renderTreeNode, int index) {
        IncrementalMountUtils.log("beforeMountItem [id=" + renderTreeNode.getRenderUnit().getId() + "]");
        RenderCoreSystrace.beginSection((String)"IncrementalMountExtension.beforeMountItem");
        long id = renderTreeNode.getRenderUnit().getId();
        IncrementalMountExtensionState state = (IncrementalMountExtensionState)extensionState.getState();
        IncrementalMountOutput output = state.mInput.getIncrementalMountOutputForId(id);
        if (output == null) {
            throw new IllegalArgumentException("Output with id=" + id + " not found.");
        }
        IncrementalMountExtension.maybeAcquireReference(extensionState, state.mPreviousLocalVisibleRect, output, false);
        RenderCoreSystrace.endSection();
    }

    public void onVisibleBoundsChanged(ExtensionState<IncrementalMountExtensionState> extensionState, Rect localVisibleRect) {
        ThreadUtils.assertMainThread();
        IncrementalMountUtils.log("onVisibleBoundsChanged [visibleBounds=" + localVisibleRect + "]");
        RenderCoreSystrace.beginSection((String)"IncrementalMountExtension.onVisibleBoundsChanged");
        IncrementalMountExtensionState state = (IncrementalMountExtensionState)extensionState.getState();
        if (state.mInput == null) {
            IncrementalMountUtils.log("Skipping: Input is empty.");
            RenderCoreSystrace.endSection();
            return;
        }
        if (localVisibleRect.isEmpty() && state.mPreviousLocalVisibleRect.isEmpty()) {
            IncrementalMountUtils.log("Skipping: Visible area is 0");
            RenderCoreSystrace.endSection();
            return;
        }
        if (state.mPreviousLocalVisibleRect.isEmpty() || localVisibleRect.isEmpty() || localVisibleRect.left != ((IncrementalMountExtensionState)state).mPreviousLocalVisibleRect.left || localVisibleRect.right != ((IncrementalMountExtensionState)state).mPreviousLocalVisibleRect.right) {
            IncrementalMountExtension.initIncrementalMount(extensionState, localVisibleRect, true);
        } else {
            IncrementalMountExtension.performIncrementalMount(extensionState, localVisibleRect);
        }
        IncrementalMountExtension.setVisibleRect(state, localVisibleRect);
        RenderCoreSystrace.endSection();
    }

    public void onUnbind(ExtensionState<IncrementalMountExtensionState> extensionState) {
    }

    public void onBindItem(ExtensionState<IncrementalMountExtensionState> extensionState, RenderUnit<?> renderUnit, Object content, @Nullable Object layoutData) {
        IncrementalMountExtensionState state = (IncrementalMountExtensionState)extensionState.getState();
        long id = renderUnit.getId();
        if (state.mItemsShouldNotNotifyVisibleBoundsChangedOnChildren.remove(id)) {
            return;
        }
        IncrementalMountExtension.recursivelyNotifyVisibleBoundsChanged(state.mInput, id, content);
    }

    public void onMountItem(ExtensionState<IncrementalMountExtensionState> extensionState, RenderUnit<?> renderUnit, Object content, @Nullable Object layoutData) {
        IncrementalMountExtensionState state = (IncrementalMountExtensionState)extensionState.getState();
        state.mItemsShouldNotNotifyVisibleBoundsChangedOnChildren.add(renderUnit.getId());
    }

    public void onUnbindItem(ExtensionState<IncrementalMountExtensionState> extensionState, RenderUnit<?> renderUnit, Object content, @Nullable Object layoutData) {
        IncrementalMountExtensionState state = (IncrementalMountExtensionState)extensionState.getState();
        long id = renderUnit.getId();
        state.mItemsShouldNotNotifyVisibleBoundsChangedOnChildren.remove(id);
    }

    public void onUnmount(ExtensionState<IncrementalMountExtensionState> extensionState) {
        extensionState.releaseAllAcquiredReferences();
        IncrementalMountExtensionState state = (IncrementalMountExtensionState)extensionState.getState();
        state.mPreviousLocalVisibleRect.setEmpty();
        state.mComponentIdsMountedInThisFrame.clear();
    }

    public boolean canPreventMount() {
        return true;
    }

    private static void acquireMountReferenceEnsureHostIsMounted(Rect localVisibleRect, ExtensionState<IncrementalMountExtensionState> extensionState, IncrementalMountOutput output, boolean isMounting) {
        if (((IncrementalMountExtensionState)extensionState.getState()).mDisableForceAcquireHostMount) {
            extensionState.acquireMountReference(output.getId(), isMounting);
        } else {
            IncrementalMountExtension.acquireMountReferenceEnsureHostIsMounted(localVisibleRect, extensionState, output, isMounting, false, null);
        }
    }

    private static void acquireMountReferenceEnsureHostIsMounted(Rect localVisibleRect, ExtensionState<IncrementalMountExtensionState> extensionState, IncrementalMountOutput output, boolean isMounting, boolean forceAcquiredHostToMount, @Nullable List<String> recursionSource) {
        boolean needsHostMount;
        IncrementalMountOutput host = output.getHostOutput();
        boolean ownsHostRef = host == null ? true : extensionState.ownsReference(host.getId());
        boolean bl = needsHostMount = !ownsHostRef || !IncrementalMountExtension.isHostMounted(extensionState, host);
        if (needsHostMount) {
            if (recursionSource == null) {
                recursionSource = new ArrayList<String>();
            }
            String errorMessage = IncrementalMountExtension.getHostNotMountedErrorMessage(localVisibleRect, isMounting, output, host, ownsHostRef);
            if (ownsHostRef) {
                ErrorReporter.getInstance().report(LogLevel.ERROR, "IncrementalMount", errorMessage);
            }
            recursionSource.add(errorMessage);
            IncrementalMountExtension.acquireMountReferenceEnsureHostIsMounted(localVisibleRect, extensionState, host, true, ownsHostRef, recursionSource);
        }
        try {
            if (forceAcquiredHostToMount) {
                extensionState.getMountDelegate().getMountDelegateTarget().notifyMount(output.getId());
            } else {
                extensionState.acquireMountReference(output.getId(), isMounting);
            }
        }
        catch (HostNotMountedException e) {
            String errorMessage = IncrementalMountExtension.getHostNotMountedExceptionMessage(e, recursionSource, output, host);
            throw new RuntimeException(errorMessage);
        }
    }

    private static boolean isHostMounted(ExtensionState<IncrementalMountExtensionState> extensionState, IncrementalMountOutput hostOutput) {
        return hostOutput == null ? true : extensionState.getMountDelegate().getContentById(hostOutput.getId()) != null;
    }

    private static String getHostNotMountedExceptionMessage(HostNotMountedException e, List<String> additionalErrorMessages, IncrementalMountOutput output, IncrementalMountOutput host) {
        String errorMessage = "Failed to mount item with id " + output.getId() + ".";
        errorMessage = errorMessage + (host == null ? " Host is null." : " Host id is " + host.getId() + "\n");
        if (additionalErrorMessages != null) {
            for (String source : additionalErrorMessages) {
                errorMessage = errorMessage + source + "\n";
            }
        }
        errorMessage = errorMessage + "MountDelegateTarget mounting info: ";
        errorMessage = errorMessage + " renderUnit id " + e.renderUnit.getId() + ", host " + (e.parentRenderUnit == null ? " null " : " id " + e.parentRenderUnit.getId()) + "\n";
        errorMessage = errorMessage + e.getMessage();
        return errorMessage;
    }

    private static String getHostNotMountedErrorMessage(Rect localVisibleRect, boolean isMounting, IncrementalMountOutput output, IncrementalMountOutput host, boolean ownsHostRef) {
        return ownsHostRef ? "Forcing acquired host mount in " + localVisibleRect + ", mounting " + isMounting + ". Item:  id = " + output.getId() + ", bounds = " + output.getBounds() + ". Host: id = " + host.getId() + ", originalBounds = " + host.getOriginalBounds() + ", bounds = " + host.getBounds() : "Forcing unaacquired host mount in " + localVisibleRect + ", mounting " + isMounting + " . Item:  id = " + output.getId() + ", bounds = " + output.getBounds() + ". Host: id = " + host.getId() + ", originalBounds = " + host.getOriginalBounds() + ", bounds = " + host.getBounds();
    }

    static void recursivelyNotifyVisibleBoundsChanged(IncrementalMountExtensionInput input, long id, Object content) {
        ThreadUtils.assertMainThread();
        if (input != null && input.renderUnitWithIdHostsRenderTrees(id)) {
            IncrementalMountUtils.log("RecursivelyNotify [RenderUnit=" + id + "]");
            RenderCoreSystrace.beginSection((String)"IncrementalMountExtension.recursivelyNotify");
            RenderCoreExtension.recursivelyNotifyVisibleBoundsChanged((Object)content);
            RenderCoreSystrace.endSection();
        }
    }

    private static void releaseAcquiredReferencesForRemovedItems(ExtensionState<IncrementalMountExtensionState> extensionState, IncrementalMountExtensionInput input) {
        IncrementalMountExtensionState state = (IncrementalMountExtensionState)extensionState.getState();
        if (state.mInput == null) {
            return;
        }
        Collection<IncrementalMountOutput> outputs = state.mInput.getIncrementalMountOutputs();
        for (IncrementalMountOutput output : outputs) {
            long id = output.getId();
            if (input.getIncrementalMountOutputForId(id) != null || !extensionState.ownsReference(id)) continue;
            extensionState.releaseMountReference(id, false);
        }
    }

    private static void initIncrementalMount(ExtensionState<IncrementalMountExtensionState> extensionState, Rect localVisibleRect, boolean isMounting) {
        IncrementalMountExtensionState state = (IncrementalMountExtensionState)extensionState.getState();
        Collection<IncrementalMountOutput> outputs = state.mInput.getIncrementalMountOutputs();
        for (IncrementalMountOutput output : outputs) {
            IncrementalMountExtension.maybeAcquireReference(extensionState, localVisibleRect, output, isMounting);
        }
        IncrementalMountExtension.setupPreviousMountableOutputData(state, localVisibleRect);
    }

    private static void maybeAcquireReference(ExtensionState<IncrementalMountExtensionState> extensionState, Rect localVisibleRect, IncrementalMountOutput incrementalMountOutput, boolean isMounting) {
        IncrementalMountExtensionState state = (IncrementalMountExtensionState)extensionState.getState();
        long id = incrementalMountOutput.getId();
        Object content = IncrementalMountExtension.getContentById(extensionState, (long)id);
        boolean isMountable = IncrementalMountExtension.isMountedHostWithChildContent(content) || Rect.intersects((Rect)localVisibleRect, (Rect)incrementalMountOutput.getBounds()) || IncrementalMountExtension.isRootItem((long)id);
        boolean hasAcquiredMountRef = extensionState.ownsReference(id);
        if (isMountable && !hasAcquiredMountRef) {
            IncrementalMountExtension.acquireMountReferenceEnsureHostIsMounted(localVisibleRect, extensionState, incrementalMountOutput, isMounting);
        } else if (!isMountable && hasAcquiredMountRef) {
            extensionState.releaseMountReference(id, isMounting);
        } else if (isMountable && hasAcquiredMountRef && isMounting) {
            IncrementalMountExtension.recursivelyNotifyVisibleBoundsChanged(state.mInput, id, content);
        }
    }

    private static void setVisibleRect(IncrementalMountExtensionState state, @Nullable Rect localVisibleRect) {
        if (localVisibleRect != null) {
            state.mPreviousLocalVisibleRect.set(localVisibleRect);
        }
    }

    private static boolean performIncrementalMount(ExtensionState<IncrementalMountExtensionState> extensionState, Rect localVisibleRect) {
        Host root;
        int height;
        IncrementalMountExtensionState state = (IncrementalMountExtensionState)extensionState.getState();
        List<IncrementalMountOutput> byTopBounds = state.mInput.getOutputsOrderedByTopBounds();
        List<IncrementalMountOutput> byBottomBounds = state.mInput.getOutputsOrderedByBottomBounds();
        int count = state.mInput.getIncrementalMountOutputCount();
        int itemsMounted = 0;
        int itemsUnmounted = 0;
        if (localVisibleRect.top >= 0 || ((IncrementalMountExtensionState)state).mPreviousLocalVisibleRect.top >= 0) {
            long id;
            IncrementalMountOutput node;
            while (state.mPreviousBottomsIndex < count && localVisibleRect.top >= byBottomBounds.get((int)((IncrementalMountExtensionState)state).mPreviousBottomsIndex).getBounds().bottom) {
                node = byBottomBounds.get(state.mPreviousBottomsIndex);
                id = node.getId();
                if (extensionState.ownsReference(id)) {
                    extensionState.releaseMountReference(id, true);
                    if (IncrementalMountExtensionConfigs.isDebugLoggingEnabled) {
                        ++itemsUnmounted;
                    }
                }
                state.mPreviousBottomsIndex++;
            }
            while (state.mPreviousBottomsIndex > 0 && localVisibleRect.top <= byBottomBounds.get((int)(((IncrementalMountExtensionState)state).mPreviousBottomsIndex - 1)).getBounds().bottom && localVisibleRect.bottom > byBottomBounds.get((int)(((IncrementalMountExtensionState)state).mPreviousBottomsIndex - 1)).getBounds().top) {
                state.mPreviousBottomsIndex--;
                node = byBottomBounds.get(state.mPreviousBottomsIndex);
                id = node.getId();
                if (extensionState.ownsReference(id)) continue;
                IncrementalMountExtension.acquireMountReferenceEnsureHostIsMounted(localVisibleRect, extensionState, node, true);
                state.mComponentIdsMountedInThisFrame.add(id);
                if (!IncrementalMountExtensionConfigs.isDebugLoggingEnabled) continue;
                ++itemsMounted;
            }
        }
        int n = height = (root = extensionState.getRootHost()) != null ? root.getHeight() : 0;
        if (localVisibleRect.bottom < height || ((IncrementalMountExtensionState)state).mPreviousLocalVisibleRect.bottom < height) {
            long id;
            IncrementalMountOutput node;
            while (state.mPreviousTopsIndex < count && localVisibleRect.bottom >= byTopBounds.get((int)((IncrementalMountExtensionState)state).mPreviousTopsIndex).getBounds().top && localVisibleRect.top <= byTopBounds.get((int)((IncrementalMountExtensionState)state).mPreviousTopsIndex).getBounds().bottom) {
                node = byTopBounds.get(state.mPreviousTopsIndex);
                id = node.getId();
                if (!extensionState.ownsReference(id)) {
                    IncrementalMountExtension.acquireMountReferenceEnsureHostIsMounted(localVisibleRect, extensionState, node, true);
                    state.mComponentIdsMountedInThisFrame.add(id);
                    if (IncrementalMountExtensionConfigs.isDebugLoggingEnabled) {
                        ++itemsMounted;
                    }
                }
                state.mPreviousTopsIndex++;
            }
            while (state.mPreviousTopsIndex > 0 && localVisibleRect.bottom < byTopBounds.get((int)(((IncrementalMountExtensionState)state).mPreviousTopsIndex - 1)).getBounds().top) {
                state.mPreviousTopsIndex--;
                node = byTopBounds.get(state.mPreviousTopsIndex);
                id = node.getId();
                if (!extensionState.ownsReference(id)) continue;
                extensionState.releaseMountReference(id, true);
                if (!IncrementalMountExtensionConfigs.isDebugLoggingEnabled) continue;
                ++itemsUnmounted;
            }
        }
        IncrementalMountUtils.log("Updates: [Items Mounted=" + itemsMounted + ", Items Unmounted=" + itemsUnmounted + "]");
        Collection<IncrementalMountOutput> outputs = state.mInput.getIncrementalMountOutputs();
        for (IncrementalMountOutput output : outputs) {
            Object content;
            long id = output.getId();
            if (state.mComponentIdsMountedInThisFrame.contains(id) || !IncrementalMountExtension.isLockedForMount(extensionState, (long)id) || (content = IncrementalMountExtension.getContentWithId(extensionState, id)) == null) continue;
            IncrementalMountExtension.recursivelyNotifyVisibleBoundsChanged(state.mInput, id, content);
        }
        state.mComponentIdsMountedInThisFrame.clear();
        return true;
    }

    private static void setupPreviousMountableOutputData(IncrementalMountExtensionState state, Rect localVisibleRect) {
        int i;
        if (localVisibleRect.isEmpty()) {
            return;
        }
        List<IncrementalMountOutput> byTopBounds = state.mInput.getOutputsOrderedByTopBounds();
        List<IncrementalMountOutput> byBottomBounds = state.mInput.getOutputsOrderedByBottomBounds();
        int mountableOutputCount = state.mInput.getIncrementalMountOutputCount();
        state.mPreviousTopsIndex = mountableOutputCount;
        for (i = 0; i < mountableOutputCount; ++i) {
            if (localVisibleRect.bottom > byTopBounds.get((int)i).getBounds().top) continue;
            state.mPreviousTopsIndex = i;
            break;
        }
        state.mPreviousBottomsIndex = mountableOutputCount;
        for (i = 0; i < mountableOutputCount; ++i) {
            if (localVisibleRect.top >= byBottomBounds.get((int)i).getBounds().bottom) continue;
            state.mPreviousBottomsIndex = i;
            break;
        }
    }

    @Nullable
    private static Object getContentWithId(ExtensionState<IncrementalMountExtensionState> extensionState, long id) {
        return IncrementalMountExtension.getMountTarget(extensionState).getContentById(id);
    }

    @VisibleForTesting
    public static int getPreviousTopsIndex(IncrementalMountExtensionState state) {
        return state.mPreviousTopsIndex;
    }

    @VisibleForTesting
    public static int getPreviousBottomsIndex(IncrementalMountExtensionState state) {
        return state.mPreviousBottomsIndex;
    }

    private static boolean isMountedHostWithChildContent(@Nullable Object content) {
        return content instanceof Host && ((Host)content).getMountItemCount() > 0;
    }

    @VisibleForTesting
    public static class IncrementalMountExtensionState {
        private final Rect mPreviousLocalVisibleRect = new Rect();
        private final Set<Long> mComponentIdsMountedInThisFrame = new HashSet<Long>();
        private final Set<Long> mItemsShouldNotNotifyVisibleBoundsChangedOnChildren = new HashSet<Long>();
        private final boolean mDisableForceAcquireHostMount;
        private IncrementalMountExtensionInput mInput;
        private int mPreviousTopsIndex;
        private int mPreviousBottomsIndex;

        private IncrementalMountExtensionState(boolean disableForceAcquireHostMount) {
            this.mDisableForceAcquireHostMount = disableForceAcquireHostMount;
        }
    }
}

