/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.utils;

import android.graphics.Rect;
import android.support.v4.util.Pools;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.litho.LithoView;
import com.facebook.litho.ThreadUtils;

public class IncrementalMountUtils {
    private static final Pools.SynchronizedPool<Rect> sRectPool = new Pools.SynchronizedPool(10);

    public static void performIncrementalMount(ViewGroup scrollingViewParent) {
        ThreadUtils.assertMainThread();
        int viewGroupWidth = scrollingViewParent.getWidth();
        int viewGroupHeight = scrollingViewParent.getHeight();
        for (int i = 0; i < scrollingViewParent.getChildCount(); ++i) {
            IncrementalMountUtils.maybePerformIncrementalMountOnView(viewGroupWidth, viewGroupHeight, scrollingViewParent.getChildAt(i));
        }
    }

    private static void maybePerformIncrementalMountOnView(int scrollingParentWidth, int scrollingParentHeight, View view) {
        View underlyingView;
        View view2 = underlyingView = view instanceof WrapperView ? ((WrapperView)view).getWrappedView() : view;
        if (!(underlyingView instanceof LithoView)) {
            return;
        }
        LithoView lithoView = (LithoView)underlyingView;
        if (!lithoView.isIncrementalMountEnabled()) {
            return;
        }
        if (view != underlyingView && view.getHeight() != underlyingView.getHeight()) {
            throw new IllegalStateException("ViewDiagnosticsWrapper must be the same height as the underlying view");
        }
        int translationX = (int)view.getTranslationX();
        int translationY = (int)view.getTranslationY();
        int top = view.getTop() + translationY;
        int bottom = view.getBottom() + translationY;
        int left = view.getLeft() + translationX;
        int right = view.getRight() + translationX;
        if (left >= 0 && top >= 0 && right <= scrollingParentWidth && bottom <= scrollingParentHeight && lithoView.getPreviousMountBounds().width() == lithoView.getWidth() && lithoView.getPreviousMountBounds().height() == lithoView.getHeight()) {
            return;
        }
        Rect rect = IncrementalMountUtils.acquireRect();
        rect.set(Math.max(0, -left), Math.max(0, -top), Math.min(right, scrollingParentWidth) - left, Math.min(bottom, scrollingParentHeight) - top);
        if (rect.isEmpty()) {
            IncrementalMountUtils.release(rect);
            return;
        }
        lithoView.performIncrementalMount(rect, true);
        IncrementalMountUtils.release(rect);
    }

    private static Rect acquireRect() {
        Rect rect = (Rect)sRectPool.acquire();
        if (rect == null) {
            rect = new Rect();
        }
        return rect;
    }

    private static void release(Rect rect) {
        rect.setEmpty();
        sRectPool.release((Object)rect);
    }

    public static interface WrapperView {
        public View getWrappedView();
    }
}

