/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.reference;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v4.util.LruCache;
import android.support.v4.util.Pools;
import android.util.StateSet;
import java.util.concurrent.atomic.AtomicInteger;

class DrawableResourcesCache {
    private static final int DRAWABLES_MAX_ENTRIES = 200;
    private static final int DRAWABLES_POOL_MAX_ITEMS = 10;
    private final LruCache<Integer, SimplePoolWithCount<Drawable>> mDrawableCache = new LruCache<Integer, SimplePoolWithCount<Drawable>>(200){

        protected int sizeOf(Integer key, SimplePoolWithCount<Drawable> value) {
            return value.getPoolSize();
        }
    };

    DrawableResourcesCache() {
    }

    @Deprecated
    @Nullable
    public Drawable get(int resId, Resources resources) {
        return this.get(resId, resources, null);
    }

    @Nullable
    public Drawable get(int resId, Resources resources, @Nullable Resources.Theme theme) {
        Drawable drawable;
        SimplePoolWithCount<Drawable> drawablesPool = (SimplePoolWithCount<Drawable>)((Object)this.mDrawableCache.get((Object)resId));
        if (drawablesPool == null) {
            drawablesPool = new SimplePoolWithCount<Drawable>(10);
            this.mDrawableCache.put((Object)resId, drawablesPool);
        }
        if ((drawable = (Drawable)drawablesPool.acquire()) == null) {
            drawable = ResourcesCompat.getDrawable((Resources)resources, (int)resId, (Resources.Theme)theme);
        }
        if (drawable != null && drawablesPool.getPoolSize() == 0) {
            drawablesPool.release(drawable.getConstantState().newDrawable());
        }
        return drawable;
    }

    public void release(Drawable drawable, int resId) {
        SimplePoolWithCount<Drawable> drawablesPool = (SimplePoolWithCount<Drawable>)((Object)this.mDrawableCache.get((Object)resId));
        if (drawablesPool == null) {
            drawablesPool = new SimplePoolWithCount<Drawable>(10);
            this.mDrawableCache.put((Object)resId, drawablesPool);
        }
        if (drawable.isStateful()) {
            drawable.setState(StateSet.WILD_CARD);
            if (Build.VERSION.SDK_INT >= 11) {
                drawable.jumpToCurrentState();
            }
        }
        drawablesPool.release(drawable);
    }

    private static class SimplePoolWithCount<T>
    extends Pools.SynchronizedPool<T> {
        private final AtomicInteger mPoolSize = new AtomicInteger(0);

        public SimplePoolWithCount(int maxPoolSize) {
            super(maxPoolSize);
        }

        public T acquire() {
            Object item = super.acquire();
            if (item != null) {
                this.mPoolSize.decrementAndGet();
            }
            return (T)item;
        }

        public boolean release(T instance) {
            boolean added = super.release(instance);
            if (added) {
                this.mPoolSize.incrementAndGet();
            }
            return added;
        }

        public int getPoolSize() {
            return this.mPoolSize.get();
        }
    }
}

