/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.reference;

import android.graphics.drawable.Drawable;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.reference.Reference;
import com.facebook.litho.reference.ReferenceLifecycle;

public final class DrawableReference
extends ReferenceLifecycle<Drawable> {
    private static DrawableReference sInstance;

    private DrawableReference() {
    }

    public static synchronized DrawableReference get() {
        if (sInstance == null) {
            sInstance = new DrawableReference();
        }
        return sInstance;
    }

    public static PropsBuilder create() {
        return new PropsBuilder(new State());
    }

    @Override
    protected Drawable onAcquire(ComponentContext context, Reference reference) {
        return ((State)reference).mDrawable;
    }

    public static class PropsBuilder
    extends Reference.Builder<Drawable> {
        private final State mState;

        public PropsBuilder(State state) {
            this.mState = state;
        }

        public PropsBuilder drawable(Drawable drawable) {
            this.mState.mDrawable = drawable;
            return this;
        }

        @Override
        public Reference<Drawable> build() {
            return this.mState;
        }
    }

    private static class State
    extends Reference<Drawable> {
        Drawable mDrawable;

        @Override
        public String getSimpleName() {
            return "DrawableReference";
        }

        public int hashCode() {
            return this.mDrawable != null ? this.mDrawable.hashCode() : 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.mDrawable == state.mDrawable;
        }

        protected State() {
            super(DrawableReference.get());
        }
    }
}

