/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.reference;

import android.graphics.PathEffect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Px;
import android.support.v4.util.Pools;
import com.facebook.litho.BorderColorDrawable;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.reference.Reference;
import com.facebook.litho.reference.ReferenceLifecycle;
import javax.annotation.Nullable;

public class BorderColorDrawableReference
extends ReferenceLifecycle<Drawable> {
    private static final Pools.SynchronizedPool<PropsBuilder> sBuilderPool = new Pools.SynchronizedPool(2);
    private static BorderColorDrawableReference sInstance;

    private BorderColorDrawableReference() {
    }

    public static synchronized BorderColorDrawableReference get() {
        if (sInstance == null) {
            sInstance = new BorderColorDrawableReference();
        }
        return sInstance;
    }

    private static PropsBuilder newBuilder(ComponentContext context, State state) {
        PropsBuilder builder = (PropsBuilder)sBuilderPool.acquire();
        if (builder == null) {
            builder = new PropsBuilder();
        }
        builder.init(context, state);
        return builder;
    }

    public static PropsBuilder create(ComponentContext c) {
        return BorderColorDrawableReference.newBuilder(c, new State());
    }

    @Override
    protected Drawable onAcquire(ComponentContext context, Reference reference) {
        BorderColorDrawable drawable = ComponentsPools.acquireBorderColorDrawable();
        State state = (State)reference;
        drawable.init(state.mPathEffect, state.mBorderLeftWidth, state.mBorderTopWidth, state.mBorderRightWidth, state.mBorderBottomWidth, state.mBorderLeftColor, state.mBorderTopColor, state.mBorderRightColor, state.mBorderBottomColor);
        return drawable;
    }

    @Override
    protected void onRelease(ComponentContext context, Drawable drawable, Reference reference) {
        ComponentsPools.release((BorderColorDrawable)drawable);
    }

    public static class PropsBuilder
    extends Reference.Builder<Drawable> {
        private State mState;

        protected void init(ComponentContext context, State state) {
            super.init(context, state);
            this.mState = state;
        }

        @Override
        protected void release() {
            super.release();
            this.mState = null;
            sBuilderPool.release((Object)this);
        }

        public PropsBuilder pathEffect(@Nullable PathEffect pathEffect) {
            this.mState.mPathEffect = pathEffect;
            return this;
        }

        public PropsBuilder borderLeftColor(@ColorInt int color) {
            this.mState.mBorderLeftColor = color;
            return this;
        }

        public PropsBuilder borderTopColor(@ColorInt int color) {
            this.mState.mBorderTopColor = color;
            return this;
        }

        public PropsBuilder borderRightColor(@ColorInt int color) {
            this.mState.mBorderRightColor = color;
            return this;
        }

        public PropsBuilder borderBottomColor(@ColorInt int color) {
            this.mState.mBorderBottomColor = color;
            return this;
        }

        public PropsBuilder borderLeftWidth(@Px int borderLeft) {
            this.mState.mBorderLeftWidth = borderLeft;
            return this;
        }

        public PropsBuilder borderTopWidth(@Px int borderTop) {
            this.mState.mBorderTopWidth = borderTop;
            return this;
        }

        public PropsBuilder borderRightWidth(@Px int borderRight) {
            this.mState.mBorderRightWidth = borderRight;
            return this;
        }

        public PropsBuilder borderBottomWidth(@Px int borderBottom) {
            this.mState.mBorderBottomWidth = borderBottom;
            return this;
        }

        @Override
        public Reference<Drawable> build() {
            State state = this.mState;
            this.release();
            return state;
        }
    }

    private static class State
    extends Reference<Drawable> {
        @Nullable
        PathEffect mPathEffect;
        @ColorInt
        int mBorderLeftColor;
        @ColorInt
        int mBorderTopColor;
        @ColorInt
        int mBorderRightColor;
        @ColorInt
        int mBorderBottomColor;
        int mBorderLeftWidth;
        int mBorderTopWidth;
        int mBorderRightWidth;
        int mBorderBottomWidth;

        @Override
        public String getSimpleName() {
            return "BorderColorDrawableReference";
        }

        protected State() {
            super(BorderColorDrawableReference.get());
        }

        public int hashCode() {
            int result = this.mBorderLeftColor;
            result = 31 * result + this.mBorderTopColor;
            result = 31 * result + this.mBorderRightColor;
            result = 31 * result + this.mBorderBottomColor;
            result = 31 * result + this.mBorderLeftWidth;
            result = 31 * result + this.mBorderTopWidth;
            result = 31 * result + this.mBorderRightWidth;
            result = 31 * result + this.mBorderBottomWidth;
            result = 31 * result + (this.mPathEffect != null ? this.mPathEffect.hashCode() : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.mBorderLeftColor == state.mBorderLeftColor && this.mBorderTopColor == state.mBorderTopColor && this.mBorderRightColor == state.mBorderRightColor && this.mBorderBottomColor == state.mBorderBottomColor && this.mBorderLeftWidth == state.mBorderLeftWidth && this.mBorderTopWidth == state.mBorderTopWidth && this.mBorderRightWidth == state.mBorderRightWidth && this.mBorderBottomWidth == state.mBorderBottomWidth && (this.mPathEffect == state.mPathEffect || this.mPathEffect != null && this.mPathEffect.equals(state.mPathEffect));
        }
    }
}

