/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.internal;

import android.support.v4.util.SimpleArrayMap;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import javax.annotation.Nullable;

public class ArraySet<E>
implements Set<E> {
    private static final Integer SENTINEL_MAP_VALUE = 0;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final SimpleArrayMap<E, Integer> mMap;

    public ArraySet() {
        this.mMap = new SimpleArrayMap();
    }

    public ArraySet(int capacity) {
        this.mMap = new SimpleArrayMap(capacity);
    }

    public ArraySet(@Nullable Collection<? extends E> set) {
        this.mMap = new SimpleArrayMap();
        if (set != null) {
            this.addAll(set);
        }
    }

    @Override
    public boolean add(E value) {
        Object oldValue = this.mMap.put(value, (Object)SENTINEL_MAP_VALUE);
        return oldValue == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.ensureCapacity(this.size() + collection.size());
        boolean added = false;
        if (collection instanceof ArraySet) {
            ArraySet arraySet = (ArraySet)collection;
            int oldSize = this.size();
            this.mMap.putAll(arraySet.mMap);
            added = this.size() != oldSize;
        } else if (collection instanceof List && collection instanceof RandomAccess) {
            List list = (List)collection;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                added |= this.add(list.get(i));
            }
        } else {
            for (E value : collection) {
                added |= this.add(value);
            }
        }
        return added;
    }

    @Override
    public void clear() {
        this.mMap.clear();
    }

    public void clearAndAddAll(ArraySet<? extends E> collection) {
        this.clear();
        this.addAll(collection);
    }

    @Override
    public boolean contains(Object value) {
        return this.mMap.containsKey(value);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof List && collection instanceof RandomAccess) {
            List list = (List)collection;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                if (this.contains(list.get(i))) continue;
                return false;
            }
        } else {
            Iterator<?> it = collection.iterator();
            while (it.hasNext()) {
                if (this.contains(it.next())) continue;
                return false;
            }
        }
        return true;
    }

    public void ensureCapacity(int minimumCapacity) {
        this.mMap.ensureCapacity(minimumCapacity);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            if (this.size() != set.size()) {
                return false;
            }
            try {
                int size = this.size();
                for (int i = 0; i < size; ++i) {
                    E mine = this.valueAt(i);
                    if (set.contains(mine)) continue;
                    return false;
                }
            }
            catch (NullPointerException ignored) {
                return false;
            }
            catch (ClassCastException ignored) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E value = this.valueAt(i);
            if (value == null) continue;
            result += value.hashCode();
        }
        return result;
    }

    public int indexOf(E value) {
        return this.mMap.indexOfKey(value);
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new ArraySetIterator();
    }

    @Override
    public boolean remove(Object value) {
        int index = this.indexOf(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean removed = false;
        if (collection instanceof List && collection instanceof RandomAccess) {
            List list = (List)collection;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                removed |= this.remove(list.get(i));
            }
        } else {
            for (Object value : collection) {
                removed |= this.remove(value);
            }
        }
        return removed;
    }

    public E removeAt(int index) {
        Object value = this.mMap.keyAt(index);
        this.mMap.removeAt(index);
        return (E)value;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean removed = false;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (collection.contains(this.valueAt(i))) continue;
            this.removeAt(i);
            removed = true;
        }
        return removed;
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    @Override
    public Object[] toArray() {
        int size = this.mMap.size();
        if (size == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] array = new Object[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.mMap.keyAt(i);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array.length < size) {
            Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            array = newArray;
        }
        for (int i = 0; i < size; ++i) {
            array[i] = this.valueAt(i);
        }
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        int size = this.size();
        StringBuilder buffer = new StringBuilder(size * 14);
        buffer.append('{');
        for (int i = 0; i < size; ++i) {
            E value;
            if (i > 0) {
                buffer.append(", ");
            }
            if ((value = this.valueAt(i)) != this) {
                buffer.append(value);
                continue;
            }
            buffer.append("(this Set)");
        }
        buffer.append('}');
        return buffer.toString();
    }

    public E valueAt(int index) {
        return (E)this.mMap.keyAt(index);
    }

    private final class ArraySetIterator
    implements Iterator<E> {
        private int mIndex = -1;
        private boolean mRemoved;

        @Override
        public boolean hasNext() {
            return this.mIndex + 1 < ArraySet.this.size();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.mRemoved = false;
            ++this.mIndex;
            return ArraySet.this.valueAt(this.mIndex);
        }

        @Override
        public void remove() {
            if (this.mRemoved) {
                throw new IllegalStateException();
            }
            ArraySet.this.removeAt(this.mIndex);
            this.mRemoved = true;
            --this.mIndex;
        }
    }
}

