/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.displaylist;

import android.graphics.Canvas;
import android.view.DisplayListCanvas;
import android.view.RenderNode;
import com.facebook.litho.displaylist.DisplayListException;
import com.facebook.litho.displaylist.PlatformDisplayList;
import com.facebook.litho.displaylist.Utils;
import java.lang.reflect.Method;

public class DisplayListMarshmallow
implements PlatformDisplayList {
    private static Class sRenderNodeClass;
    private static Method sStartMethod;
    protected static boolean sInitialized;
    protected static boolean sInitializationFailed;
    protected final RenderNode mDisplayList;

    protected static void ensureInitialized() throws Exception {
        if (sInitialized || sInitializationFailed) {
            return;
        }
        sRenderNodeClass = Class.forName("android.view.RenderNode");
        sStartMethod = sRenderNodeClass.getDeclaredMethod("start", Integer.TYPE, Integer.TYPE);
        sInitialized = true;
    }

    static PlatformDisplayList createDisplayList(String debugName) {
        try {
            DisplayListMarshmallow.ensureInitialized();
            if (sInitialized) {
                RenderNode renderNode = RenderNode.create((String)debugName, null);
                return new DisplayListMarshmallow(renderNode);
            }
        }
        catch (Throwable e) {
            sInitializationFailed = true;
        }
        return null;
    }

    DisplayListMarshmallow(RenderNode displayList) {
        this.mDisplayList = displayList;
    }

    @Override
    public Canvas start(int width, int height) throws DisplayListException {
        return (Canvas)Utils.safeInvoke(sStartMethod, this.mDisplayList, width, height);
    }

    @Override
    public void end(Canvas canvas) {
        Canvas displayListCanvas = canvas;
        this.mDisplayList.end((DisplayListCanvas)displayListCanvas);
    }

    @Override
    public void clear() {
        this.mDisplayList.destroyDisplayListData();
    }

    @Override
    public void print(Canvas canvas) {
        this.mDisplayList.output();
    }

    @Override
    public void draw(Canvas canvas) throws DisplayListException {
        Canvas displayListCanvas = canvas;
        if (!(displayListCanvas instanceof DisplayListCanvas)) {
            throw new DisplayListException(new ClassCastException());
        }
        ((DisplayListCanvas)displayListCanvas).drawRenderNode(this.mDisplayList);
    }

    @Override
    public void setBounds(int left, int top, int right, int bottom) {
        this.mDisplayList.setLeftTopRightBottom(left, top, right, bottom);
        this.mDisplayList.setClipToBounds(false);
    }

    @Override
    public boolean isValid() {
        return this.mDisplayList.isValid();
    }

    static {
        sInitialized = false;
        sInitializationFailed = false;
    }
}

