/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.displaylist;

import android.graphics.Canvas;
import android.view.HardwareCanvas;
import android.view.RenderNode;
import com.facebook.litho.displaylist.DisplayListException;
import com.facebook.litho.displaylist.PlatformDisplayList;

public class DisplayListLollipop
implements PlatformDisplayList {
    private final RenderNode mDisplayList;

    static PlatformDisplayList createDisplayList(String debugName) {
        RenderNode renderNode = RenderNode.create((String)debugName, null);
        return new DisplayListLollipop(renderNode);
    }

    private DisplayListLollipop(RenderNode displayList) {
        this.mDisplayList = displayList;
    }

    @Override
    public Canvas start(int width, int height) {
        HardwareCanvas canvas = this.mDisplayList.start(width, height);
        return (Canvas)canvas;
    }

    @Override
    public void end(Canvas canvas) {
        Canvas hardwareCanvas = canvas;
        this.mDisplayList.end((HardwareCanvas)hardwareCanvas);
    }

    @Override
    public void clear() {
        this.mDisplayList.destroyDisplayListData();
    }

    @Override
    public void print(Canvas canvas) {
        this.mDisplayList.output();
    }

    @Override
    public void draw(Canvas canvas) throws DisplayListException {
        Canvas hardwareCanvas = canvas;
        if (!(hardwareCanvas instanceof HardwareCanvas)) {
            throw new DisplayListException(new ClassCastException());
        }
        ((HardwareCanvas)hardwareCanvas).drawRenderNode(this.mDisplayList);
    }

    @Override
    public void setBounds(int left, int top, int right, int bottom) {
        this.mDisplayList.setLeftTopRightBottom(left, top, right, bottom);
        this.mDisplayList.setClipToBounds(false);
    }

    @Override
    public boolean isValid() {
        return this.mDisplayList.isValid();
    }
}

