/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.displaylist;

import android.graphics.Canvas;
import android.view.DisplayList;
import android.view.HardwareCanvas;
import com.facebook.litho.displaylist.DisplayListException;
import com.facebook.litho.displaylist.PlatformDisplayList;
import java.lang.reflect.Constructor;

class DisplayListJB
implements PlatformDisplayList {
    private static Class sDisplayListClass;
    private static boolean sInitialized;
    private static boolean sInitializationFailed;
    private static Constructor sDisplayListConstructor;
    protected final DisplayList mDisplayList;

    private static void ensureInitialized() throws Exception {
        if (sInitialized || sInitializationFailed) {
            return;
        }
        sDisplayListClass = Class.forName("android.view.GLES20DisplayList");
        sDisplayListConstructor = sDisplayListClass.getDeclaredConstructor(String.class);
        sDisplayListConstructor.setAccessible(true);
        sInitialized = true;
    }

    static PlatformDisplayList createDisplayList(String debugName) {
        DisplayList displayList = DisplayListJB.instantiateDisplayList(debugName);
        if (displayList == null) {
            return null;
        }
        return new DisplayListJB(displayList);
    }

    static DisplayList instantiateDisplayList(String debugName) {
        try {
            DisplayListJB.ensureInitialized();
            if (!sInitialized) {
                return null;
            }
        }
        catch (Throwable e) {
            sInitializationFailed = true;
        }
        try {
            return (DisplayList)sDisplayListConstructor.newInstance(debugName);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    DisplayListJB(DisplayList displayList) {
        this.mDisplayList = displayList;
    }

    @Override
    public Canvas start(int width, int height) {
        HardwareCanvas canvas = this.mDisplayList.start();
        canvas.setViewport(width, height);
        canvas.onPreDraw(null);
        return (Canvas)canvas;
    }

    @Override
    public void end(Canvas canvas) {
        Canvas hardwareCanvas = canvas;
        ((HardwareCanvas)hardwareCanvas).onPostDraw();
        this.mDisplayList.end();
    }

    @Override
    public void clear() {
        this.mDisplayList.invalidate();
        this.mDisplayList.clear();
    }

    @Override
    public void print(Canvas canvas) throws DisplayListException {
    }

    @Override
    public void draw(Canvas canvas) throws DisplayListException {
        Canvas hardwareCanvas = canvas;
        if (!(hardwareCanvas instanceof HardwareCanvas)) {
            throw new DisplayListException(new ClassCastException());
        }
        ((HardwareCanvas)hardwareCanvas).drawDisplayList(this.mDisplayList, null, 0);
    }

    @Override
    public void setBounds(int left, int top, int right, int bottom) {
        this.mDisplayList.setLeftTopRightBottom(left, top, right, bottom);
        this.mDisplayList.setClipChildren(false);
    }

    @Override
    public boolean isValid() {
        return this.mDisplayList.isValid();
    }

    static {
        sInitialized = false;
        sInitializationFailed = false;
    }
}

