/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.displaylist;

import android.graphics.Canvas;
import android.os.Build;
import android.support.annotation.Nullable;
import com.facebook.litho.displaylist.DisplayListException;
import com.facebook.litho.displaylist.DisplayListJB;
import com.facebook.litho.displaylist.DisplayListJBMR2;
import com.facebook.litho.displaylist.DisplayListLollipop;
import com.facebook.litho.displaylist.DisplayListMarshmallow;
import com.facebook.litho.displaylist.DisplayListNougat;
import com.facebook.litho.displaylist.PlatformDisplayList;

public class DisplayList {
    private final PlatformDisplayList mDisplayListImpl;
    private boolean mStarted;

    private DisplayList(PlatformDisplayList displayListImpl) {
        this.mDisplayListImpl = displayListImpl;
    }

    @Nullable
    public static DisplayList createDisplayList(String name) {
        PlatformDisplayList platformDisplayList;
        switch (Build.VERSION.SDK_INT) {
            case 24: 
            case 25: {
                platformDisplayList = DisplayListNougat.createDisplayList(name);
                break;
            }
            case 23: {
                platformDisplayList = DisplayListMarshmallow.createDisplayList(name);
                break;
            }
            case 21: 
            case 22: {
                platformDisplayList = DisplayListLollipop.createDisplayList(name);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                platformDisplayList = DisplayListJBMR2.createDisplayList(name);
                break;
            }
            case 16: 
            case 17: {
                platformDisplayList = DisplayListJB.createDisplayList(name);
                break;
            }
            default: {
                platformDisplayList = null;
            }
        }
        if (platformDisplayList == null) {
            return null;
        }
        return new DisplayList(platformDisplayList);
    }

    public Canvas start(int width, int height) throws DisplayListException {
        if (this.mStarted) {
            throw new DisplayListException(new IllegalStateException("Can't start a DisplayList that is already started"));
        }
        Canvas canvas = this.mDisplayListImpl.start(width, height);
        this.mStarted = true;
        return canvas;
    }

    public void end(Canvas canvas) throws DisplayListException {
        if (!this.mStarted) {
            throw new DisplayListException(new IllegalStateException("Can't end a DisplayList that is not started"));
        }
        this.mStarted = false;
        this.mDisplayListImpl.end(canvas);
    }

    public void clear() throws DisplayListException {
        this.mDisplayListImpl.clear();
    }

    public void draw(Canvas canvas) throws DisplayListException {
        this.mDisplayListImpl.draw(canvas);
    }

    public void setBounds(int left, int top, int right, int bottom) throws DisplayListException {
        this.mDisplayListImpl.setBounds(left, top, right, bottom);
    }

    public boolean isValid() {
        return this.mDisplayListImpl.isValid();
    }

    void print(Canvas canvas) throws DisplayListException {
        this.mDisplayListImpl.print(canvas);
    }
}

