/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.dataflow;

import android.support.v4.util.SimpleArrayMap;
import java.util.ArrayList;

public abstract class ValueNode {
    public static final String DEFAULT_INPUT = "default_input";
    private SimpleArrayMap<String, ValueNode> mInputs = null;
    private ArrayList<ValueNode> mOutputs = null;
    private float mValue;
    private long mTimeNs = 0L;

    public float getValue() {
        return this.mValue;
    }

    public void setValue(float value) {
        this.mValue = value;
    }

    protected abstract float calculateValue(long var1);

    protected ValueNode getInput(String name) {
        ValueNode input = this.getInputUnsafe(name);
        if (input == null) {
            throw new RuntimeException("Tried to get non-existent input '" + name + "'. Node only has these inputs: " + this.buildDebugInputsString());
        }
        return input;
    }

    protected ValueNode getInput() {
        if (this.getInputCount() > 1) {
            throw new RuntimeException("Trying to get single input of node with multiple inputs!");
        }
        return this.getInput(DEFAULT_INPUT);
    }

    protected boolean hasInput(String name) {
        if (this.mInputs == null) {
            return false;
        }
        return this.mInputs.containsKey((Object)name);
    }

    protected boolean hasInput() {
        if (this.getInputCount() > 1) {
            throw new RuntimeException("Trying to check for single input of node with multiple inputs!");
        }
        return this.hasInput(DEFAULT_INPUT);
    }

    private String buildDebugInputsString() {
        if (this.mInputs == null) {
            return "[]";
        }
        String inputNames = "";
        for (int i = 0; i < this.mInputs.size(); ++i) {
            inputNames = inputNames + "'" + (String)this.mInputs.keyAt(i) + "'";
            if (i == this.mInputs.size() - 1) continue;
            inputNames = inputNames + ", ";
        }
        return "[" + inputNames + "]";
    }

    ValueNode getInputUnsafe(String name) {
        if (this.mInputs == null) {
            return null;
        }
        return (ValueNode)this.mInputs.get((Object)name);
    }

    final void doCalculateValue(long frameTimeNanos) {
        float value = this.calculateValue(frameTimeNanos);
        if (frameTimeNanos == this.mTimeNs) {
            throw new RuntimeException("Got a calculate value call multiple times in the same frame. This isn't expected.");
        }
        this.mTimeNs = frameTimeNanos;
        this.mValue = value;
    }

    void addOutput(ValueNode node) {
        if (this.mOutputs == null) {
            this.mOutputs = new ArrayList();
        }
        this.mOutputs.add(node);
    }

    int getOutputCount() {
        return this.mOutputs == null ? 0 : this.mOutputs.size();
    }

    ValueNode getOutputAt(int i) {
        return this.mOutputs.get(i);
    }

    ValueNode getOutput() {
        if (this.getOutputCount() != 1) {
            throw new RuntimeException("Node does not have inputs of size 1: " + this.getOutputCount());
        }
        return this.getOutputAt(0);
    }

    void removeOutputAt(int i) {
        if (i >= this.getOutputCount()) {
            throw new RuntimeException("Bad index: " + i + " >= " + this.getOutputCount());
        }
        this.mOutputs.remove(i);
    }

    void removeOutput(ValueNode output) {
        if (!this.mOutputs.remove(output)) {
            throw new RuntimeException("Tried to remove non-existent input!");
        }
    }

    int getInputCount() {
        return this.mInputs == null ? 0 : this.mInputs.size();
    }

    ValueNode getInputAt(int i) {
        if (this.getInputCount() <= i) {
            throw new RuntimeException("Bad index: " + i + " > " + this.getInputCount());
        }
        return (ValueNode)this.mInputs.valueAt(i);
    }

    void setInput(String name, ValueNode input) {
        if (this.mInputs == null) {
            this.mInputs = new SimpleArrayMap();
        }
        this.mInputs.put((Object)name, (Object)input);
    }

    void removeInput(String name) {
        if (this.mInputs == null || this.mInputs.remove((Object)name) == null) {
            throw new RuntimeException("Tried to remove non-existent input with name: " + name);
        }
    }
}

