/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.dataflow;

import com.facebook.litho.dataflow.NodeCanFinish;
import com.facebook.litho.dataflow.ValueNode;

public class TimingNode
extends ValueNode
implements NodeCanFinish {
    public static final String INITIAL_INPUT = "initial";
    public static final String END_INPUT = "end";
    private static final int MS_IN_NANOS = 1000000;
    private final int mDurationMs;
    private long mStartTimeNs = Long.MIN_VALUE;
    private long mExpectedEndTimeNs = Long.MIN_VALUE;
    private long mLastValueTimeNs = Long.MIN_VALUE;
    private float mInitialValue;
    private boolean mAreParentsFinished = false;
    private boolean mIsFinished = false;

    public TimingNode(int durationMs) {
        this.mDurationMs = durationMs;
    }

    @Override
    public float calculateValue(long frameTimeNanos) {
        if (this.mLastValueTimeNs == Long.MIN_VALUE) {
            this.mInitialValue = this.getInput(INITIAL_INPUT).getValue();
            this.mStartTimeNs = frameTimeNanos;
            this.mLastValueTimeNs = frameTimeNanos;
            this.mExpectedEndTimeNs = this.mStartTimeNs + (long)(this.mDurationMs * 1000000);
            return this.mInitialValue;
        }
        float endValue = this.getInput(END_INPUT).getValue();
        if (frameTimeNanos >= this.mExpectedEndTimeNs) {
            this.mIsFinished = true;
            return endValue;
        }
        float lastValue = this.getValue();
        float desiredVelocity = (endValue - lastValue) / (float)(this.mExpectedEndTimeNs - this.mLastValueTimeNs);
        float increment = desiredVelocity * (float)(frameTimeNanos - this.mLastValueTimeNs);
        this.mLastValueTimeNs = frameTimeNanos;
        return lastValue + increment;
    }

    @Override
    public boolean isFinished() {
        return this.mIsFinished && this.mAreParentsFinished;
    }

    @Override
    public void onInputsFinished() {
        this.mAreParentsFinished = true;
        this.mIsFinished = this.mLastValueTimeNs >= this.mExpectedEndTimeNs;
    }
}

