/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.dataflow;

import com.facebook.litho.dataflow.NodeCanFinish;
import com.facebook.litho.dataflow.ValueNode;
import com.facebook.litho.dataflow.springs.Spring;

public class SpringNode
extends ValueNode
implements NodeCanFinish {
    public static final double NS_PER_SECOND = 1.0E9;
    public static final String INITIAL_INPUT = "initial";
    public static final String END_INPUT = "end";
    private final Spring mSpring;
    private long mLastFrameTimeNs = Long.MIN_VALUE;
    private boolean mAreParentsFinished = false;

    public SpringNode() {
        this.mSpring = new Spring();
    }

    @Override
    public float calculateValue(long frameTimeNanos) {
        if (this.mLastFrameTimeNs == Long.MIN_VALUE) {
            this.mLastFrameTimeNs = frameTimeNanos;
            float initialValue = this.getInput(INITIAL_INPUT).getValue();
            float endValue = this.getInput(END_INPUT).getValue();
            this.mSpring.setCurrentValue(initialValue);
            this.mSpring.setEndValue(endValue);
            return initialValue;
        }
        float endValue = this.getInput(END_INPUT).getValue();
        this.mSpring.setEndValue(endValue);
        if (this.isFinished()) {
            return endValue;
        }
        double timeDeltaSec = (double)(frameTimeNanos - this.mLastFrameTimeNs) / 1.0E9;
        this.mSpring.advance(timeDeltaSec);
        this.mLastFrameTimeNs = frameTimeNanos;
        return (float)this.mSpring.getCurrentValue();
    }

    @Override
    public boolean isFinished() {
        return this.mAreParentsFinished && this.mSpring.isAtRest();
    }

    @Override
    public void onInputsFinished() {
        this.mAreParentsFinished = true;
    }
}

