/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.dataflow;

import android.support.annotation.VisibleForTesting;
import com.facebook.litho.dataflow.BindingListener;
import com.facebook.litho.dataflow.DataFlowGraph;
import com.facebook.litho.dataflow.ValueNode;
import com.facebook.litho.internal.ArraySet;
import java.util.ArrayList;

public final class GraphBinding {
    private final DataFlowGraph mDataFlowGraph;
    private final Bindings mBindings = new Bindings();
    private final ArraySet<ValueNode> mAllNodes = new ArraySet();
    private BindingListener mListener;
    private boolean mIsActive = false;
    private boolean mHasBeenActivated = false;

    public static GraphBinding create() {
        return new GraphBinding(DataFlowGraph.getInstance());
    }

    @VisibleForTesting
    public static GraphBinding create(DataFlowGraph dataFlowGraph) {
        return new GraphBinding(dataFlowGraph);
    }

    private GraphBinding(DataFlowGraph dataFlowGraph) {
        this.mDataFlowGraph = dataFlowGraph;
    }

    public void addBinding(ValueNode fromNode, ValueNode toNode, String name) {
        if (this.mHasBeenActivated) {
            throw new RuntimeException("Trying to add binding after DataFlowGraph has already been activated.");
        }
        this.mBindings.addBinding(fromNode, toNode, name);
        this.mAllNodes.add(fromNode);
        this.mAllNodes.add(toNode);
    }

    public void addBinding(ValueNode fromNode, ValueNode toNode) {
        this.addBinding(fromNode, toNode, "default_input");
    }

    ArraySet<ValueNode> getAllNodes() {
        return this.mAllNodes;
    }

    public void activate() {
        this.mBindings.applyBindings();
        this.mHasBeenActivated = true;
        this.mIsActive = true;
        this.mDataFlowGraph.register(this);
    }

    public void deactivate() {
        this.mIsActive = false;
        this.mDataFlowGraph.unregister(this);
        this.mBindings.removeBindings();
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    void notifyNodesHaveFinished() {
        if (this.mListener != null) {
            this.mListener.onAllNodesFinished(this);
        }
    }

    public void setListener(BindingListener listener) {
        if (this.mListener != null && listener != null) {
            throw new RuntimeException("Overriding existing listener!");
        }
        this.mListener = listener;
    }

    private static class Bindings {
        private final ArrayList<ValueNode> mFromNodes = new ArrayList();
        private final ArrayList<ValueNode> mToNodes = new ArrayList();
        private final ArrayList<String> mInputNames = new ArrayList();

        private Bindings() {
        }

        public void addBinding(ValueNode fromNode, ValueNode toNode, String name) {
            this.mFromNodes.add(fromNode);
            this.mToNodes.add(toNode);
            this.mInputNames.add(name);
        }

        public void applyBindings() {
            for (int i = 0; i < this.mFromNodes.size(); ++i) {
                String name;
                ValueNode fromNode = this.mFromNodes.get(i);
                ValueNode toNode = this.mToNodes.get(i);
                ValueNode currentInput = toNode.getInputUnsafe(name = this.mInputNames.get(i));
                if (currentInput != null) {
                    Bindings.unbindNodes(currentInput, toNode, name);
                }
                fromNode.addOutput(toNode);
                toNode.setInput(name, fromNode);
            }
        }

        public void removeBindings() {
            for (int i = 0; i < this.mFromNodes.size(); ++i) {
                String name;
                ValueNode fromNode = this.mFromNodes.get(i);
                ValueNode toNode = this.mToNodes.get(i);
                if (toNode.getInputUnsafe(name = this.mInputNames.get(i)) != fromNode) continue;
                Bindings.unbindNodes(fromNode, toNode, name);
            }
        }

        private static void unbindNodes(ValueNode fromNode, ValueNode toNode, String name) {
            fromNode.removeOutput(toNode);
            toNode.removeInput(name);
        }
    }
}

