/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.dataflow;

import android.support.annotation.VisibleForTesting;
import android.support.v4.util.SimpleArrayMap;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.dataflow.ChoreographerTimingSource;
import com.facebook.litho.dataflow.DetectedCycleException;
import com.facebook.litho.dataflow.GraphBinding;
import com.facebook.litho.dataflow.NodeCanFinish;
import com.facebook.litho.dataflow.TimingSource;
import com.facebook.litho.dataflow.ValueNode;
import com.facebook.litho.internal.ArraySet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;

public class DataFlowGraph {
    private static DataFlowGraph sInstance;
    private final TimingSource mTimingSource;
    private final CopyOnWriteArrayList<GraphBinding> mBindings = new CopyOnWriteArrayList();
    private final ArrayList<ValueNode> mSortedNodes = new ArrayList();
    private final ArraySet<ValueNode> mFinishedNodes = new ArraySet();
    private final ArraySet<ValueNode> mNodesWithFinishedInputs = new ArraySet();
    private final SimpleArrayMap<GraphBinding, ArraySet<ValueNode>> mBindingToNodes = new SimpleArrayMap();
    private final ArraySet<GraphBinding> mFinishedBindings = new ArraySet();
    private boolean mIsDirty = false;

    public static DataFlowGraph getInstance() {
        if (sInstance == null) {
            ChoreographerTimingSource timingSource = new ChoreographerTimingSource();
            sInstance = new DataFlowGraph(timingSource);
            timingSource.setDataFlowGraph(sInstance);
        }
        return sInstance;
    }

    @VisibleForTesting
    public static void setInstance(DataFlowGraph dataFlowGraph) {
        sInstance = dataFlowGraph;
    }

    @VisibleForTesting
    public static DataFlowGraph create(TimingSource timingSource) {
        DataFlowGraph instance = new DataFlowGraph(timingSource);
        timingSource.setDataFlowGraph(instance);
        return instance;
    }

    private DataFlowGraph(TimingSource timingSource) {
        this.mTimingSource = timingSource;
    }

    public void register(GraphBinding binding) {
        if (!binding.isActive()) {
            throw new RuntimeException("Expected added GraphBinding to be active: " + binding);
        }
        this.mBindings.add(binding);
        this.mBindingToNodes.put((Object)binding, binding.getAllNodes());
        if (this.mBindings.size() == 1) {
            this.mTimingSource.start();
        }
        this.mIsDirty = true;
    }

    public void unregister(GraphBinding binding) {
        if (!this.mBindings.remove(binding)) {
            throw new RuntimeException("Tried to unregister non-existent binding");
        }
        this.mBindingToNodes.remove((Object)binding);
        this.mFinishedBindings.remove(binding);
        if (this.mBindings.isEmpty()) {
            this.mTimingSource.stop();
        }
        this.mIsDirty = true;
    }

    void doFrame(long frameTimeNanos) {
        if (this.mIsDirty) {
            this.regenerateSortedNodes();
        }
        this.propagate(frameTimeNanos);
        this.updateFinishedStates();
    }

    private void propagate(long frameTimeNanos) {
        int size = this.mSortedNodes.size();
        for (int i = 0; i < size; ++i) {
            ValueNode node = this.mSortedNodes.get(i);
            node.doCalculateValue(frameTimeNanos);
        }
    }

    private void regenerateSortedNodes() {
        this.mSortedNodes.clear();
        if (this.mBindings.size() == 0) {
            return;
        }
        ArraySet<ValueNode> leafNodes = ComponentsPools.acquireArraySet();
        SimpleArrayMap nodesToOutputsLeft = new SimpleArrayMap();
        int bindingsSize = this.mBindingToNodes.size();
        for (int i = 0; i < bindingsSize; ++i) {
            ArraySet nodes = (ArraySet)this.mBindingToNodes.valueAt(i);
            int nodesSize = nodes.size();
            for (int j = 0; j < nodesSize; ++j) {
                ValueNode node = (ValueNode)nodes.valueAt(j);
                int outputCount = node.getOutputCount();
                if (outputCount == 0) {
                    leafNodes.add(node);
                    continue;
                }
                nodesToOutputsLeft.put((Object)node, (Object)outputCount);
            }
        }
        if (!nodesToOutputsLeft.isEmpty() && leafNodes.isEmpty()) {
            throw new DetectedCycleException("Graph has nodes, but they represent a cycle with no leaf nodes!");
        }
        ArrayDeque<ValueNode> nodesToProcess = ComponentsPools.acquireArrayDeque();
        nodesToProcess.addAll(leafNodes);
        while (!nodesToProcess.isEmpty()) {
            ValueNode next = (ValueNode)nodesToProcess.pollFirst();
            this.mSortedNodes.add(next);
            int count = next.getInputCount();
            for (int i = 0; i < count; ++i) {
                ValueNode input = next.getInputAt(i);
                int outputsLeft = (Integer)nodesToOutputsLeft.get((Object)input) - 1;
                nodesToOutputsLeft.put((Object)input, (Object)outputsLeft);
                if (outputsLeft == 0) {
                    nodesToProcess.addLast(input);
                    continue;
                }
                if (outputsLeft >= 0) continue;
                throw new DetectedCycleException("Detected cycle.");
            }
        }
        int expectedTotalNodes = nodesToOutputsLeft.size() + leafNodes.size();
        if (this.mSortedNodes.size() != expectedTotalNodes) {
            throw new DetectedCycleException("Had unreachable nodes in graph -- this likely means there was a cycle");
        }
        Collections.reverse(this.mSortedNodes);
        this.mIsDirty = false;
        ComponentsPools.release(nodesToProcess);
        ComponentsPools.release(leafNodes);
    }

    private void updateFinishedStates() {
        this.updateFinishedNodes();
        this.notifyFinishedBindings();
    }

    private void updateFinishedNodes() {
        int size = this.mSortedNodes.size();
        for (int i = 0; i < size; ++i) {
            boolean nodeIsNowFinished;
            boolean areInputsFinished;
            ValueNode node = this.mSortedNodes.get(i);
            if (this.mFinishedNodes.contains(node)) continue;
            boolean wereInputsFinished = this.mNodesWithFinishedInputs.contains(node);
            boolean bl = areInputsFinished = wereInputsFinished || this.areInputsFinished(node);
            if (!wereInputsFinished && areInputsFinished) {
                this.mNodesWithFinishedInputs.add(node);
                if (node instanceof NodeCanFinish) {
                    ((NodeCanFinish)((Object)node)).onInputsFinished();
                }
            }
            boolean bl2 = nodeIsNowFinished = !(node instanceof NodeCanFinish) || ((NodeCanFinish)((Object)node)).isFinished();
            if (!nodeIsNowFinished) continue;
            this.mFinishedNodes.add(node);
        }
    }

    private boolean areInputsFinished(ValueNode node) {
        int inputCount = node.getInputCount();
        for (int i = 0; i < inputCount; ++i) {
            if (this.mFinishedNodes.contains(node.getInputAt(i))) continue;
            return false;
        }
        return true;
    }

    private void notifyFinishedBindings() {
        for (int i = this.mBindingToNodes.size() - 1; i >= 0; --i) {
            GraphBinding binding = (GraphBinding)this.mBindingToNodes.keyAt(i);
            if (this.mFinishedBindings.contains(binding)) continue;
            boolean allAreFinished = true;
            ArraySet nodesToCheck = (ArraySet)this.mBindingToNodes.valueAt(i);
            int nodesSize = nodesToCheck.size();
            for (int j = 0; j < nodesSize; ++j) {
                ValueNode node = (ValueNode)nodesToCheck.valueAt(j);
                if (this.mFinishedNodes.contains(node)) continue;
                allAreFinished = false;
                break;
            }
            if (!allAreFinished) continue;
            binding.notifyNodesHaveFinished();
            this.mFinishedBindings.add(binding);
        }
    }
}

