/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.dataflow;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.VisibleForTesting;
import android.view.Choreographer;
import com.facebook.litho.dataflow.ChoreographerCompat;

public class ChoreographerCompatImpl
implements ChoreographerCompat {
    private static final long ONE_FRAME_MILLIS = 17L;
    private static final boolean IS_JELLYBEAN_OR_HIGHER = Build.VERSION.SDK_INT >= 16;
    private static ChoreographerCompat sInstance;
    private Handler mHandler;
    private Choreographer mChoreographer;

    public static ChoreographerCompat getInstance() {
        if (sInstance == null) {
            sInstance = new ChoreographerCompatImpl();
        }
        return sInstance;
    }

    @VisibleForTesting
    public static void setInstance(ChoreographerCompat choreographerCompat) {
        sInstance = choreographerCompat;
    }

    private ChoreographerCompatImpl() {
        if (IS_JELLYBEAN_OR_HIGHER) {
            this.mChoreographer = this.getChoreographer();
        } else {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
    }

    @Override
    public void postFrameCallback(ChoreographerCompat.FrameCallback callbackWrapper) {
        if (IS_JELLYBEAN_OR_HIGHER) {
            this.choreographerPostFrameCallback(callbackWrapper.getFrameCallback());
        } else {
            this.mHandler.postDelayed(callbackWrapper.getRunnable(), 0L);
        }
    }

    @Override
    public void postFrameCallbackDelayed(ChoreographerCompat.FrameCallback callbackWrapper, long delayMillis) {
        if (IS_JELLYBEAN_OR_HIGHER) {
            this.choreographerPostFrameCallbackDelayed(callbackWrapper.getFrameCallback(), delayMillis);
        } else {
            this.mHandler.postDelayed(callbackWrapper.getRunnable(), delayMillis + 17L);
        }
    }

    @Override
    public void removeFrameCallback(ChoreographerCompat.FrameCallback callbackWrapper) {
        if (IS_JELLYBEAN_OR_HIGHER) {
            this.choreographerRemoveFrameCallback(callbackWrapper.getFrameCallback());
        } else {
            this.mHandler.removeCallbacks(callbackWrapper.getRunnable());
        }
    }

    @TargetApi(value=16)
    private Choreographer getChoreographer() {
        return Choreographer.getInstance();
    }

    @TargetApi(value=16)
    private void choreographerPostFrameCallback(Choreographer.FrameCallback frameCallback) {
        this.mChoreographer.postFrameCallback(frameCallback);
    }

    @TargetApi(value=16)
    private void choreographerPostFrameCallbackDelayed(Choreographer.FrameCallback frameCallback, long delayMillis) {
        this.mChoreographer.postFrameCallbackDelayed(frameCallback, delayMillis);
    }

    @TargetApi(value=16)
    private void choreographerRemoveFrameCallback(Choreographer.FrameCallback frameCallback) {
        this.mChoreographer.removeFrameCallback(frameCallback);
    }
}

