/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import android.support.annotation.VisibleForTesting;
import com.facebook.litho.animation.AnimationBinding;
import com.facebook.litho.animation.AnimationBindingListener;
import com.facebook.litho.animation.Resolver;
import com.facebook.litho.dataflow.BindingListener;
import com.facebook.litho.dataflow.GraphBinding;
import com.facebook.litho.dataflow.ValueNode;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class TransitionAnimationBinding
implements AnimationBinding {
    private final GraphBinding mGraphBinding;
    private final CopyOnWriteArrayList<AnimationBindingListener> mListeners = new CopyOnWriteArrayList();

    public TransitionAnimationBinding() {
        this(GraphBinding.create());
    }

    @VisibleForTesting
    TransitionAnimationBinding(GraphBinding graphBinding) {
        this.mGraphBinding = graphBinding;
        this.mGraphBinding.setListener(new BindingListener(){

            @Override
            public void onAllNodesFinished(GraphBinding binding) {
                TransitionAnimationBinding.this.onAllNodesFinished();
            }
        });
    }

    public void addBinding(ValueNode fromNode, ValueNode toNode, String inputName) {
        this.mGraphBinding.addBinding(fromNode, toNode, inputName);
    }

    public void addBinding(ValueNode fromNode, ValueNode toNode) {
        this.mGraphBinding.addBinding(fromNode, toNode);
    }

    @Override
    public void start(Resolver resolver) {
        for (AnimationBindingListener listener : this.mListeners) {
            if (listener.shouldStart(this)) continue;
            this.notifyCanceledBeforeStart();
            return;
        }
        for (AnimationBindingListener listener : this.mListeners) {
            listener.onWillStart(this);
        }
        this.setupBinding(resolver);
        this.mGraphBinding.activate();
    }

    protected abstract void setupBinding(Resolver var1);

    @Override
    public void stop() {
        if (!this.isActive()) {
            return;
        }
        this.mGraphBinding.deactivate();
    }

    @Override
    public boolean isActive() {
        return this.mGraphBinding.isActive();
    }

    private void onAllNodesFinished() {
        for (AnimationBindingListener listener : this.mListeners) {
            listener.onFinish(this);
        }
        this.stop();
    }

    private void notifyCanceledBeforeStart() {
        for (AnimationBindingListener listener : this.mListeners) {
            listener.onCanceledBeforeStart(this);
        }
    }

    @Override
    public void addListener(AnimationBindingListener bindingListener) {
        this.mListeners.add(bindingListener);
    }

    @Override
    public void removeListener(AnimationBindingListener animationBindingListener) {
        this.mListeners.remove(animationBindingListener);
    }
}

