/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import com.facebook.litho.animation.PropertyAnimation;
import com.facebook.litho.animation.Resolver;
import com.facebook.litho.animation.TransitionAnimationBinding;
import com.facebook.litho.dataflow.ConstantNode;
import com.facebook.litho.dataflow.TimingNode;
import java.util.ArrayList;

public class TimingTransition
extends TransitionAnimationBinding {
    private final int mDurationMs;
    private final PropertyAnimation mPropertyAnimation;

    public TimingTransition(int durationMs, PropertyAnimation propertyAnimation) {
        this.mDurationMs = durationMs;
        this.mPropertyAnimation = propertyAnimation;
    }

    @Override
    public void collectTransitioningProperties(ArrayList<PropertyAnimation> outList) {
        outList.add(this.mPropertyAnimation);
    }

    @Override
    protected void setupBinding(Resolver resolver) {
        TimingNode timingNode = new TimingNode(this.mDurationMs);
        ConstantNode initial = new ConstantNode(resolver.getCurrentState(this.mPropertyAnimation.getPropertyHandle()));
        ConstantNode end = new ConstantNode(this.mPropertyAnimation.getTargetValue());
        this.addBinding(initial, timingNode, "initial");
        this.addBinding(end, timingNode, "end");
        this.addBinding(timingNode, resolver.getAnimatedPropertyNode(this.mPropertyAnimation.getPropertyHandle()));
    }
}

