/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import com.facebook.litho.animation.AnimationBinding;
import com.facebook.litho.animation.AnimationBindingListener;
import com.facebook.litho.animation.PropertyAnimation;
import com.facebook.litho.animation.Resolver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SequenceBinding
implements AnimationBinding {
    private final CopyOnWriteArrayList<AnimationBindingListener> mListeners = new CopyOnWriteArrayList();
    private final List<AnimationBinding> mBindings;
    private final AnimationBindingListener mChildListener;
    private Resolver mResolver;
    private int mCurrentIndex = 0;
    private boolean mIsActive = false;

    public SequenceBinding(List<AnimationBinding> bindings) {
        this.mBindings = bindings;
        if (this.mBindings.isEmpty()) {
            throw new IllegalArgumentException("Empty binding sequence");
        }
        this.mChildListener = new AnimationBindingListener(){

            @Override
            public void onWillStart(AnimationBinding binding) {
            }

            @Override
            public void onFinish(AnimationBinding binding) {
                SequenceBinding.this.onBindingFinished(binding);
            }

            @Override
            public void onCanceledBeforeStart(AnimationBinding binding) {
                SequenceBinding.this.onBindingFinished(binding);
            }

            @Override
            public boolean shouldStart(AnimationBinding binding) {
                return true;
            }
        };
    }

    private void onBindingFinished(AnimationBinding binding) {
        if (binding != this.mBindings.get(this.mCurrentIndex)) {
            throw new RuntimeException("Unexpected Binding completed");
        }
        binding.removeListener(this.mChildListener);
        ++this.mCurrentIndex;
        if (this.mCurrentIndex >= this.mBindings.size()) {
            this.finish();
        } else {
            AnimationBinding next = this.mBindings.get(this.mCurrentIndex);
            next.addListener(this.mChildListener);
            next.start(this.mResolver);
        }
    }

    private void finish() {
        for (AnimationBindingListener listener : this.mListeners) {
            listener.onFinish(this);
        }
        this.mIsActive = false;
        this.mResolver = null;
    }

    private void notifyCanceledBeforeStart() {
        for (AnimationBindingListener listener : this.mListeners) {
            listener.onCanceledBeforeStart(this);
        }
    }

    @Override
    public void start(Resolver resolver) {
        if (this.mIsActive) {
            throw new RuntimeException("Already started");
        }
        for (AnimationBindingListener listener : this.mListeners) {
            if (listener.shouldStart(this)) continue;
            this.notifyCanceledBeforeStart();
            return;
        }
        for (AnimationBindingListener listener : this.mListeners) {
            listener.onWillStart(this);
        }
        this.mIsActive = true;
        this.mResolver = resolver;
        AnimationBinding first = this.mBindings.get(0);
        first.addListener(this.mChildListener);
        first.start(this.mResolver);
    }

    @Override
    public void stop() {
        if (!this.mIsActive) {
            return;
        }
        this.mIsActive = false;
        this.mBindings.get(this.mCurrentIndex).stop();
    }

    @Override
    public boolean isActive() {
        return this.mIsActive;
    }

    @Override
    public void collectTransitioningProperties(ArrayList<PropertyAnimation> outList) {
        int size = this.mBindings.size();
        for (int i = 0; i < size; ++i) {
            this.mBindings.get(i).collectTransitioningProperties(outList);
        }
    }

    @Override
    public void addListener(AnimationBindingListener animationBindingListener) {
        this.mListeners.add(animationBindingListener);
    }

    @Override
    public void removeListener(AnimationBindingListener animationBindingListener) {
        this.mListeners.remove(animationBindingListener);
    }
}

