/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import com.facebook.litho.animation.AnimationBinding;
import com.facebook.litho.animation.AnimationBindingListener;
import com.facebook.litho.animation.PropertyAnimation;
import com.facebook.litho.animation.Resolver;
import com.facebook.litho.dataflow.ChoreographerCompat;
import com.facebook.litho.dataflow.ChoreographerCompatImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ParallelBinding
implements AnimationBinding {
    private final CopyOnWriteArrayList<AnimationBindingListener> mListeners = new CopyOnWriteArrayList();
    private final List<AnimationBinding> mBindings;
    private final AnimationBindingListener mChildListener;
    private final HashSet<AnimationBinding> mBindingsFinished = new HashSet();
    private final ChoreographerCompat.FrameCallback mStaggerCallback;
    private final int mStaggerMs;
    private int mNextIndexToStart = 0;
    private int mChildrenFinished = 0;
    private boolean mHasStarted = false;
    private boolean mIsActive = false;
    private Resolver mResolver;

    public ParallelBinding(int staggerMs, List<AnimationBinding> bindings) {
        this.mStaggerMs = staggerMs;
        this.mBindings = bindings;
        if (this.mBindings.isEmpty()) {
            throw new IllegalArgumentException("Empty binding parallel");
        }
        this.mChildListener = new AnimationBindingListener(){

            @Override
            public void onWillStart(AnimationBinding binding) {
            }

            @Override
            public void onFinish(AnimationBinding binding) {
                ParallelBinding.this.onBindingFinished(binding);
            }

            @Override
            public void onCanceledBeforeStart(AnimationBinding binding) {
                ParallelBinding.this.onBindingFinished(binding);
            }

            @Override
            public boolean shouldStart(AnimationBinding binding) {
                return true;
            }
        };
        this.mStaggerCallback = this.mStaggerMs == 0 ? null : new ChoreographerCompat.FrameCallback(){

            @Override
            public void doFrame(long frameTimeNanos) {
                if (!ParallelBinding.this.mIsActive) {
                    return;
                }
                ParallelBinding.this.startNextBindingForStagger();
            }
        };
    }

    private void onBindingFinished(AnimationBinding binding) {
        if (this.mBindingsFinished.contains(binding)) {
            throw new RuntimeException("Binding unexpectedly completed twice");
        }
        this.mBindingsFinished.add(binding);
        ++this.mChildrenFinished;
        binding.removeListener(this.mChildListener);
        if (this.mChildrenFinished >= this.mBindings.size()) {
            this.finish();
        }
    }

    private void finish() {
        this.mIsActive = false;
        for (AnimationBindingListener listener : this.mListeners) {
            listener.onFinish(this);
        }
    }

    @Override
    public void start(Resolver resolver) {
        if (this.mHasStarted) {
            throw new RuntimeException("Starting binding multiple times");
        }
        this.mHasStarted = true;
        this.mResolver = resolver;
        for (AnimationBindingListener listener : this.mListeners) {
            if (listener.shouldStart(this)) continue;
            this.notifyCanceledBeforeStart();
            return;
        }
        for (AnimationBindingListener listener : this.mListeners) {
            listener.onWillStart(this);
        }
        this.mIsActive = true;
        for (AnimationBinding binding : this.mBindings) {
            binding.addListener(this.mChildListener);
        }
        if (this.mStaggerMs == 0) {
            int size = this.mBindings.size();
            for (int i = 0; i < size; ++i) {
                AnimationBinding binding = this.mBindings.get(i);
                binding.start(this.mResolver);
            }
            this.mNextIndexToStart = this.mBindings.size();
        } else {
            this.startNextBindingForStagger();
        }
    }

    private void startNextBindingForStagger() {
        this.mBindings.get(this.mNextIndexToStart).start(this.mResolver);
        ++this.mNextIndexToStart;
        if (this.mNextIndexToStart < this.mBindings.size()) {
            ChoreographerCompatImpl.getInstance().postFrameCallbackDelayed(this.mStaggerCallback, this.mStaggerMs);
        }
    }

    private void notifyCanceledBeforeStart() {
        for (AnimationBindingListener listener : this.mListeners) {
            listener.onCanceledBeforeStart(this);
        }
    }

    @Override
    public void stop() {
        if (!this.mIsActive) {
            return;
        }
        this.mIsActive = false;
        this.mResolver = null;
        int size = this.mBindings.size();
        for (int i = 0; i < size; ++i) {
            AnimationBinding childBinding = this.mBindings.get(i);
            if (!childBinding.isActive()) continue;
            childBinding.stop();
        }
    }

    @Override
    public boolean isActive() {
        return this.mIsActive;
    }

    @Override
    public void collectTransitioningProperties(ArrayList<PropertyAnimation> outList) {
        int size = this.mBindings.size();
        for (int i = 0; i < size; ++i) {
            this.mBindings.get(i).collectTransitioningProperties(outList);
        }
    }

    @Override
    public void addListener(AnimationBindingListener animationBindingListener) {
        this.mListeners.add(animationBindingListener);
    }

    @Override
    public void removeListener(AnimationBindingListener animationBindingListener) {
        this.mListeners.remove(animationBindingListener);
    }
}

