/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import android.content.Context;
import android.util.DisplayMetrics;
import com.facebook.litho.animation.AnimatedProperties;
import com.facebook.litho.animation.PropertyHandle;
import com.facebook.litho.animation.Resolver;
import com.facebook.litho.animation.RuntimeValue;

public class DimensionValue
implements RuntimeValue {
    private final Type mType;
    private final float mValue;

    public static DimensionValue absolute(float value) {
        return new DimensionValue(Type.ABSOLUTE, value);
    }

    public static DimensionValue offsetPx(float value) {
        return new DimensionValue(Type.OFFSET, value);
    }

    public static DimensionValue offsetDip(Context context, int valueDp) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        float valuePx = displayMetrics.density * (float)valueDp;
        return DimensionValue.offsetPx(valuePx);
    }

    public static DimensionValue widthPercentageOffset(float value) {
        return new DimensionValue(Type.OFFSET_WIDTH_PERCENTAGE, value);
    }

    public static DimensionValue heightPercentageOffset(float value) {
        return new DimensionValue(Type.OFFSET_HEIGHT_PERCENTAGE, value);
    }

    private DimensionValue(Type type, float value) {
        this.mType = type;
        this.mValue = value;
    }

    @Override
    public float resolve(Resolver resolver, PropertyHandle propertyHandle) {
        float currentValue = resolver.getCurrentState(propertyHandle);
        switch (this.mType) {
            case ABSOLUTE: {
                return this.mValue;
            }
            case OFFSET: {
                return this.mValue + currentValue;
            }
            case OFFSET_WIDTH_PERCENTAGE: {
                float width = resolver.getCurrentState(new PropertyHandle(propertyHandle.getTransitionKey(), AnimatedProperties.WIDTH));
                return this.mValue / 100.0f * width + currentValue;
            }
            case OFFSET_HEIGHT_PERCENTAGE: {
                float height = resolver.getCurrentState(new PropertyHandle(propertyHandle.getTransitionKey(), AnimatedProperties.HEIGHT));
                return this.mValue / 100.0f * height + currentValue;
            }
        }
        throw new RuntimeException("Missing RuntimeValue type: " + (Object)((Object)this.mType));
    }

    private static enum Type {
        ABSOLUTE,
        OFFSET,
        OFFSET_WIDTH_PERCENTAGE,
        OFFSET_HEIGHT_PERCENTAGE;

    }
}

