/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import com.facebook.litho.animation.PropertyAnimation;
import com.facebook.litho.animation.Resolver;
import com.facebook.litho.animation.TransitionAnimationBinding;
import com.facebook.litho.dataflow.ConstantNode;
import com.facebook.litho.dataflow.SpringNode;
import com.facebook.litho.dataflow.ValueNode;
import java.util.ArrayList;

public class BezierTransition
extends TransitionAnimationBinding {
    private final PropertyAnimation mXPropertyAnimation;
    private final PropertyAnimation mYPropertyAnimation;
    private final float mControlX;
    private final float mControlY;

    public BezierTransition(PropertyAnimation xProperty, PropertyAnimation yProperty, float controlX, float controlY) {
        this.mXPropertyAnimation = xProperty;
        this.mYPropertyAnimation = yProperty;
        this.mControlX = controlX;
        this.mControlY = controlY;
    }

    @Override
    public void collectTransitioningProperties(ArrayList<PropertyAnimation> outList) {
        outList.add(this.mXPropertyAnimation);
        outList.add(this.mYPropertyAnimation);
    }

    @Override
    protected void setupBinding(Resolver resolver) {
        float startX = resolver.getCurrentState(this.mXPropertyAnimation.getPropertyHandle());
        float endX = this.mXPropertyAnimation.getTargetValue();
        float startY = resolver.getCurrentState(this.mYPropertyAnimation.getPropertyHandle());
        float endY = this.mYPropertyAnimation.getTargetValue();
        float controlX = (endX - startX) * this.mControlX + startX;
        float controlY = (endY - startY) * this.mControlY + startY;
        SpringNode springNode = new SpringNode();
        BezierNode xBezierNode = new BezierNode(startX, endX, controlX);
        BezierNode yBezierNode = new BezierNode(startY, endY, controlY);
        this.addBinding(new ConstantNode(0.0f), springNode, "initial");
        this.addBinding(new ConstantNode(1.0f), springNode, "end");
        this.addBinding(springNode, xBezierNode);
        this.addBinding(springNode, yBezierNode);
        this.addBinding(xBezierNode, resolver.getAnimatedPropertyNode(this.mXPropertyAnimation.getPropertyHandle()));
        this.addBinding(yBezierNode, resolver.getAnimatedPropertyNode(this.mYPropertyAnimation.getPropertyHandle()));
    }

    private static class BezierNode
    extends ValueNode {
        private final float mInitial;
        private final float mEnd;
        private final float mControlPoint;

        public BezierNode(float initial, float end, float controlPoint) {
            this.mInitial = initial;
            this.mEnd = end;
            this.mControlPoint = controlPoint;
        }

        @Override
        protected float calculateValue(long frameTimeNanos) {
            float t = this.getInput().getValue();
            return (1.0f - t) * (1.0f - t) * this.mInitial + 2.0f * t * (1.0f - t) * this.mControlPoint + t * t * this.mEnd;
        }
    }
}

