/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import com.facebook.litho.animation.AnimatedProperty;
import com.facebook.litho.dataflow.ValueNode;
import java.lang.ref.WeakReference;

public class AnimatedPropertyNode
extends ValueNode {
    private final AnimatedProperty mAnimatedProperty;
    private WeakReference<Object> mMountContent;

    public AnimatedPropertyNode(Object mountContent, AnimatedProperty animatedProperty) {
        this.mMountContent = new WeakReference<Object>(mountContent);
        this.mAnimatedProperty = animatedProperty;
    }

    public void setMountContent(Object mountContent) {
        this.mMountContent = new WeakReference<Object>(mountContent);
        if (mountContent != null) {
            this.mAnimatedProperty.set(mountContent, this.getValue());
        }
    }

    @Override
    public void setValue(float value) {
        super.setValue(value);
        Object mountContent = this.mMountContent.get();
        if (mountContent != null) {
            this.mAnimatedProperty.set(mountContent, value);
        }
    }

    @Override
    public float calculateValue(long frameTimeNanos) {
        Object mountContent = this.mMountContent.get();
        boolean hasInput = this.hasInput();
        if (mountContent == null) {
            if (hasInput) {
                return this.getInput().getValue();
            }
            return this.getValue();
        }
        if (!hasInput) {
            return this.mAnimatedProperty.get(mountContent);
        }
        float value = this.getInput().getValue();
        this.mAnimatedProperty.set(mountContent, value);
        return value;
    }
}

