/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import android.graphics.drawable.Drawable;
import android.view.View;
import com.facebook.litho.AnimatableItem;
import com.facebook.litho.BoundsHelper;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.LithoView;
import com.facebook.litho.animation.AnimatedProperty;

public final class AnimatedProperties {
    public static final AnimatedProperty X = new XAnimatedProperty();
    public static final AnimatedProperty Y = new YAnimatedProperty();
    public static final AnimatedProperty WIDTH = new WidthAnimatedProperty();
    public static final AnimatedProperty HEIGHT = new HeightAnimatedProperty();
    public static final AnimatedProperty ALPHA = new AlphaAnimatedProperty();
    public static final AnimatedProperty SCALE = new ScaleAnimatedProperty();
    public static final AnimatedProperty SCALE_X = new ScaleXAnimatedProperty();
    public static final AnimatedProperty SCALE_Y = new ScaleYAnimatedProperty();
    public static final AnimatedProperty[] ALL_PROPERTIES = new AnimatedProperty[]{X, Y, ALPHA};

    private AnimatedProperties() {
    }

    private static View assertIsView(Object mountContent, AnimatedProperty property) {
        if (!(mountContent instanceof View)) {
            throw new RuntimeException("Animating '" + property.getName() + "' is only supported on Views (got " + mountContent + ")");
        }
        return (View)mountContent;
    }

    private static float getPositionRelativeToLithoView(View mountContent, boolean getX) {
        float pos = 0.0f;
        View currentView = mountContent;
        while (true) {
            if (currentView == null) {
                throw new RuntimeException("Got unexpected null parent");
            }
            if (currentView instanceof LithoView) {
                return pos;
            }
            pos += getX ? currentView.getX() : currentView.getY();
            if (!(mountContent.getParent() instanceof View)) {
                throw new RuntimeException("Expected parent to be View, was " + mountContent.getParent());
            }
            currentView = (View)currentView.getParent();
        }
    }

    private static class ScaleYAnimatedProperty
    implements AnimatedProperty {
        private ScaleYAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "scale_y";
        }

        @Override
        public float get(Object mountContent) {
            return AnimatedProperties.assertIsView(mountContent, this).getScaleY();
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return 1.0f;
        }

        @Override
        public void set(Object mountContent, float value) {
            AnimatedProperties.assertIsView(mountContent, this).setScaleY(value);
        }

        @Override
        public void reset(Object mountContent) {
            AnimatedProperties.assertIsView(mountContent, this).setScaleY(1.0f);
        }
    }

    private static class ScaleXAnimatedProperty
    implements AnimatedProperty {
        private ScaleXAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "scale_x";
        }

        @Override
        public float get(Object mountContent) {
            return AnimatedProperties.assertIsView(mountContent, this).getScaleX();
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return 1.0f;
        }

        @Override
        public void set(Object mountContent, float value) {
            AnimatedProperties.assertIsView(mountContent, this).setScaleX(value);
        }

        @Override
        public void reset(Object mountContent) {
            AnimatedProperties.assertIsView(mountContent, this).setScaleX(1.0f);
        }
    }

    private static class ScaleAnimatedProperty
    implements AnimatedProperty {
        private ScaleAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "scale";
        }

        @Override
        public float get(Object mountContent) {
            View asView = AnimatedProperties.assertIsView(mountContent, this);
            float scale = asView.getScaleX();
            if (scale != asView.getScaleY()) {
                throw new RuntimeException("Tried to get scale of view, but scaleX and scaleY are different");
            }
            return scale;
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return animatableItem.isScaleSet() ? animatableItem.getScale() : 1.0f;
        }

        @Override
        public void set(Object mountContent, float value) {
            View asView = AnimatedProperties.assertIsView(mountContent, this);
            asView.setScaleX(value);
            asView.setScaleY(value);
        }

        @Override
        public void reset(Object mountContent) {
        }
    }

    private static class AlphaAnimatedProperty
    implements AnimatedProperty {
        private AlphaAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "alpha";
        }

        @Override
        public float get(Object mountContent) {
            return AnimatedProperties.assertIsView(mountContent, this).getAlpha();
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return animatableItem.isAlphaSet() ? animatableItem.getAlpha() : 1.0f;
        }

        @Override
        public void set(Object mountContent, float value) {
            AnimatedProperties.assertIsView(mountContent, this).setAlpha(value);
        }

        @Override
        public void reset(Object mountContent) {
            AnimatedProperties.assertIsView(mountContent, this).setAlpha(1.0f);
        }
    }

    private static class HeightAnimatedProperty
    implements AnimatedProperty {
        private HeightAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "height";
        }

        @Override
        public float get(Object mountContent) {
            return AnimatedProperties.assertIsView(mountContent, this).getHeight();
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return animatableItem.getBounds().height();
        }

        @Override
        public void set(Object mountContent, float value) {
            if (mountContent instanceof ComponentHost) {
                ComponentHost view = (ComponentHost)((Object)mountContent);
                if (view instanceof LithoView) {
                    ((LithoView)view).setAnimatedHeight((int)value);
                } else {
                    int top = view.getTop();
                    BoundsHelper.applyBoundsToView((View)view, view.getLeft(), top, view.getRight(), (int)((float)top + value), false);
                }
                Drawable animatingMountItem = view.getLinkedDrawableForAnimation();
                if (animatingMountItem != null) {
                    BoundsHelper.applySizeToDrawableForAnimation(animatingMountItem, view.getWidth(), (int)value);
                }
            } else {
                throw new UnsupportedOperationException("Setting height on unsupported mount content: " + mountContent);
            }
        }

        @Override
        public void reset(Object mountContent) {
        }
    }

    private static class WidthAnimatedProperty
    implements AnimatedProperty {
        private WidthAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "width";
        }

        @Override
        public float get(Object mountContent) {
            return AnimatedProperties.assertIsView(mountContent, this).getWidth();
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return animatableItem.getBounds().width();
        }

        @Override
        public void set(Object mountContent, float value) {
            throw new UnsupportedOperationException("Setting width in animations is not supported yet.");
        }

        @Override
        public void reset(Object mountContent) {
        }
    }

    private static class YAnimatedProperty
    implements AnimatedProperty {
        private YAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "y";
        }

        @Override
        public float get(Object mountContent) {
            return AnimatedProperties.getPositionRelativeToLithoView(AnimatedProperties.assertIsView(mountContent, this), false);
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return animatableItem.getBounds().top;
        }

        @Override
        public void set(Object mountContent, float value) {
            View mountView = AnimatedProperties.assertIsView(mountContent, this);
            float parentY = AnimatedProperties.getPositionRelativeToLithoView((View)mountView.getParent(), false);
            mountView.setY(value - parentY);
        }

        @Override
        public void reset(Object mountContent) {
            AnimatedProperties.assertIsView(mountContent, this).setTranslationY(0.0f);
        }
    }

    private static class XAnimatedProperty
    implements AnimatedProperty {
        private XAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "x";
        }

        @Override
        public float get(Object mountContent) {
            return AnimatedProperties.getPositionRelativeToLithoView(AnimatedProperties.assertIsView(mountContent, this), true);
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return animatableItem.getBounds().left;
        }

        @Override
        public void set(Object mountContent, float value) {
            View mountView = AnimatedProperties.assertIsView(mountContent, this);
            float parentX = AnimatedProperties.getPositionRelativeToLithoView((View)mountView.getParent(), true);
            mountView.setX(value - parentX);
        }

        @Override
        public void reset(Object mountContent) {
            AnimatedProperties.assertIsView(mountContent, this).setTranslationX(0.0f);
        }
    }
}

