/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import com.facebook.litho.EventHandler;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.UnfocusedVisibleEvent;

class VisibilityItem {
    private static final int FLAG_LEFT_EDGE_VISIBLE = 2;
    private static final int FLAG_TOP_EDGE_VISIBLE = 4;
    private static final int FLAG_RIGHT_EDGE_VISIBLE = 8;
    private static final int FLAG_BOTTOM_EDGE_VISIBLE = 16;
    private static final int FLAG_FOCUSED_RANGE = 32;
    private String mGlobalKey;
    private int mFlags = 0;
    private EventHandler<InvisibleEvent> mInvisibleHandler = null;
    private EventHandler<UnfocusedVisibleEvent> mUnfocusedHandler = null;

    String getGlobalKey() {
        return this.mGlobalKey;
    }

    void setGlobalKey(String globalKey) {
        this.mGlobalKey = globalKey;
    }

    void setInvisibleHandler(EventHandler<InvisibleEvent> invisibleHandler) {
        this.mInvisibleHandler = invisibleHandler;
    }

    EventHandler<InvisibleEvent> getInvisibleHandler() {
        return this.mInvisibleHandler;
    }

    void setUnfocusedHandler(EventHandler<UnfocusedVisibleEvent> unfocusedHandler) {
        this.mUnfocusedHandler = unfocusedHandler;
    }

    EventHandler<UnfocusedVisibleEvent> getUnfocusedHandler() {
        return this.mUnfocusedHandler;
    }

    boolean isInFocusedRange() {
        return (this.mFlags & 0x20) != 0;
    }

    void setFocusedRange(boolean isFocused) {
        this.mFlags = isFocused ? (this.mFlags |= 0x20) : (this.mFlags &= 0xFFFFFFDF);
    }

    boolean isInFullImpressionRange() {
        int allEdgesVisible = 30;
        return (this.mFlags & 0x1E) == 30;
    }

    void setVisibleEdges(Rect componentBounds, Rect componentVisibleBounds) {
        if (componentBounds.top == componentVisibleBounds.top) {
            this.mFlags |= 4;
        }
        if (componentBounds.bottom == componentVisibleBounds.bottom) {
            this.mFlags |= 0x10;
        }
        if (componentBounds.left == componentVisibleBounds.left) {
            this.mFlags |= 2;
        }
        if (componentBounds.right == componentVisibleBounds.right) {
            this.mFlags |= 8;
        }
    }

    void release() {
        this.mFlags = 0;
        this.mInvisibleHandler = null;
        this.mUnfocusedHandler = null;
    }
}

