/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.InternalNode;
import com.facebook.litho.reference.Reference;
import com.facebook.yoga.YogaDirection;
import java.util.concurrent.atomic.AtomicInteger;

class ViewNodeInfo {
    private final AtomicInteger mReferenceCount = new AtomicInteger(0);
    private Reference<Drawable> mBackground;
    private Drawable mForeground;
    private Rect mPadding;
    private Rect mExpandedTouchBounds;
    private YogaDirection mLayoutDirection;
    private String mTransitionKey;
    private boolean mClipChildren;

    ViewNodeInfo() {
    }

    void setBackground(Reference<? extends Drawable> background) {
        this.mBackground = background;
    }

    Reference<Drawable> getBackground() {
        return this.mBackground;
    }

    void setForeground(Drawable foreground) {
        this.mForeground = foreground;
    }

    Drawable getForeground() {
        return this.mForeground;
    }

    int getPaddingLeft() {
        return this.mPadding != null ? this.mPadding.left : 0;
    }

    int getPaddingTop() {
        return this.mPadding != null ? this.mPadding.top : 0;
    }

    int getPaddingRight() {
        return this.mPadding != null ? this.mPadding.right : 0;
    }

    int getPaddingBottom() {
        return this.mPadding != null ? this.mPadding.bottom : 0;
    }

    void setPadding(int l, int t, int r, int b) {
        if (l == 0 && t == 0 && r == 0 && b == 0) {
            return;
        }
        if (this.mPadding != null) {
            throw new IllegalStateException("Padding already initialized for this ViewNodeInfo.");
        }
        this.mPadding = ComponentsPools.acquireRect();
        this.mPadding.set(l, t, r, b);
    }

    boolean hasPadding() {
        return this.mPadding != null;
    }

    void setLayoutDirection(YogaDirection layoutDirection) {
        this.mLayoutDirection = layoutDirection;
    }

    YogaDirection getLayoutDirection() {
        return this.mLayoutDirection;
    }

    void setExpandedTouchBounds(InternalNode node, int l, int t, int r, int b) {
        if (!node.hasTouchExpansion()) {
            return;
        }
        int touchExpansionLeft = node.getTouchExpansionLeft();
        int touchExpansionTop = node.getTouchExpansionTop();
        int touchExpansionRight = node.getTouchExpansionRight();
        int touchExpansionBottom = node.getTouchExpansionBottom();
        if (touchExpansionLeft == 0 && touchExpansionTop == 0 && touchExpansionRight == 0 && touchExpansionBottom == 0) {
            return;
        }
        if (this.mExpandedTouchBounds != null) {
            throw new IllegalStateException("ExpandedTouchBounds already initialized for this ViewNodeInfo.");
        }
        this.mExpandedTouchBounds = ComponentsPools.acquireRect();
        this.mExpandedTouchBounds.set(l - touchExpansionLeft, t - touchExpansionTop, r + touchExpansionRight, b + touchExpansionBottom);
    }

    Rect getExpandedTouchBounds() {
        if (this.mExpandedTouchBounds == null || this.mExpandedTouchBounds.isEmpty()) {
            return null;
        }
        return this.mExpandedTouchBounds;
    }

    void setTransitionKey(String key) {
        this.mTransitionKey = key;
    }

    String getTransitionKey() {
        return this.mTransitionKey;
    }

    void setClipChildren(boolean clipChildren) {
        this.mClipChildren = clipChildren;
    }

    boolean getClipChildren() {
        return this.mClipChildren;
    }

    static ViewNodeInfo acquire() {
        ViewNodeInfo viewNodeInfo = ComponentsPools.acquireViewNodeInfo();
        if (viewNodeInfo.mReferenceCount.getAndSet(1) != 0) {
            throw new IllegalStateException("The ViewNodeInfo reference acquired from the pool  wasn't correctly released.");
        }
        return viewNodeInfo;
    }

    ViewNodeInfo acquireRef() {
        if (this.mReferenceCount.getAndIncrement() < 1) {
            throw new IllegalStateException("The ViewNodeInfo being acquired wasn't correctly initialized.");
        }
        return this;
    }

    void release() {
        int count = this.mReferenceCount.decrementAndGet();
        if (count < 0) {
            throw new IllegalStateException("Trying to release a recycled ViewNodeInfo.");
        }
        if (count > 0) {
            return;
        }
        this.mBackground = null;
        this.mForeground = null;
        this.mLayoutDirection = YogaDirection.INHERIT;
        this.mTransitionKey = null;
        if (this.mPadding != null) {
            ComponentsPools.release(this.mPadding);
            this.mPadding = null;
        }
        if (this.mExpandedTouchBounds != null) {
            ComponentsPools.release(this.mExpandedTouchBounds);
            this.mExpandedTouchBounds = null;
        }
        ComponentsPools.release(this);
    }
}

