/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.support.v4.util.Pools;
import android.support.v4.util.SimpleArrayMap;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.ContextUtils;
import com.facebook.litho.Size;
import com.facebook.litho.viewcompat.ViewBinder;
import com.facebook.litho.viewcompat.ViewCreator;

public class ViewCompatComponent<V extends View>
extends ComponentLifecycle {
    private static final Pools.SynchronizedPool<Builder> sBuilderPool = new Pools.SynchronizedPool(2);
    private static final SimpleArrayMap<ViewCreator, ViewCompatComponent> sInstances = new SimpleArrayMap();
    private final ViewCreator mViewCreator;
    private final String mComponentName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V extends View> ViewCompatComponent<V> get(ViewCreator<V> viewCreator, String componentName) {
        ViewCompatComponent<V> componentLifecycle;
        SimpleArrayMap<ViewCreator, ViewCompatComponent> simpleArrayMap = sInstances;
        synchronized (simpleArrayMap) {
            componentLifecycle = (ViewCompatComponent<V>)sInstances.get(viewCreator);
            if (componentLifecycle == null) {
                componentLifecycle = new ViewCompatComponent<V>(viewCreator, componentName);
                sInstances.put(viewCreator, componentLifecycle);
            }
        }
        return componentLifecycle;
    }

    public Builder<V> create(ComponentContext componentContext) {
        ViewCompatComponentImpl impl = new ViewCompatComponentImpl(this);
        Builder builder = (Builder)sBuilderPool.acquire();
        if (builder == null) {
            builder = new Builder();
        }
        builder.init(componentContext, impl);
        return builder;
    }

    private ViewCompatComponent(ViewCreator viewCreator, String componentName) {
        this.mViewCreator = viewCreator;
        this.mComponentName = "ViewCompatComponent_" + componentName;
    }

    @Override
    protected boolean canMeasure() {
        return true;
    }

    @Override
    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size, Component<?> component) {
        ViewCompatComponentImpl impl = (ViewCompatComponentImpl)component;
        ViewBinder viewBinder = impl.mViewBinder;
        boolean isSafeToAllocatePool = ContextUtils.getValidActivityForContext((Context)c) != null;
        Object toMeasure = (View)ComponentsPools.acquireMountContent((Context)c, this.getTypeId(), isSafeToAllocatePool);
        if (toMeasure == null) {
            toMeasure = this.mViewCreator.createView((Context)c);
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(size.width, size.height);
        toMeasure.setLayoutParams(layoutParams);
        viewBinder.bind(toMeasure);
        if (toMeasure.getVisibility() == 8) {
            size.width = 0;
            size.height = 0;
        } else {
            toMeasure.measure(widthSpec, heightSpec);
            size.width = toMeasure.getMeasuredWidth();
            size.height = toMeasure.getMeasuredHeight();
        }
        viewBinder.unbind(toMeasure);
        ComponentsPools.release((Context)c, this, toMeasure);
    }

    @Override
    protected void onPrepare(ComponentContext c, Component<?> component) {
        ViewCompatComponentImpl impl = (ViewCompatComponentImpl)component;
        impl.mViewBinder.prepare();
    }

    @Override
    void bind(ComponentContext c, Object mountedContent, Component<?> component) {
        ViewCompatComponentImpl impl = (ViewCompatComponentImpl)component;
        impl.mViewBinder.bind((View)mountedContent);
    }

    @Override
    void unbind(ComponentContext c, Object mountedContent, Component<?> component) {
        ViewCompatComponentImpl impl = (ViewCompatComponentImpl)component;
        impl.mViewBinder.unbind((View)mountedContent);
    }

    @Override
    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.VIEW;
    }

    private String getSimpleName() {
        return this.mComponentName;
    }

    V createMountContent(ComponentContext c) {
        return this.mViewCreator.createView((Context)c);
    }

    public static final class Builder<V extends View>
    extends Component.Builder<ViewCompatComponent<V>, Builder<V>> {
        private ViewCompatComponentImpl mImpl;

        private void init(ComponentContext context, ViewCompatComponentImpl impl) {
            super.init(context, 0, 0, impl);
            this.mImpl = impl;
        }

        public Builder<V> viewBinder(ViewBinder<V> viewBinder) {
            this.mImpl.mViewBinder = viewBinder;
            return this;
        }

        @Override
        public Builder<V> getThis() {
            return this;
        }

        @Override
        public Component<ViewCompatComponent<V>> build() {
            if (this.mImpl.mViewBinder == null) {
                throw new IllegalStateException("To create a ViewCompatComponent you must provide a ViewBinder.");
            }
            ViewCompatComponentImpl impl = this.mImpl;
            this.release();
            return impl;
        }

        @Override
        protected void release() {
            super.release();
            this.mImpl = null;
            sBuilderPool.release((Object)this);
        }
    }

    private static final class ViewCompatComponentImpl<V extends View>
    extends Component<ViewCompatComponent<V>>
    implements Cloneable {
        private ViewBinder<V> mViewBinder;

        protected ViewCompatComponentImpl(ViewCompatComponent lifecycle) {
            super(lifecycle);
        }

        @Override
        public String getSimpleName() {
            return ((ViewCompatComponent)this.getLifecycle()).getSimpleName();
        }
    }
}

