/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.support.v4.util.ArrayMap;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.ComponentsPools;
import java.util.Collections;
import java.util.Map;

@ThreadConfined(value="ANY")
public class TreeProps {
    private final ArrayMap<Class, Object> mMap = new ArrayMap();

    public void put(Class key, Object value) {
        this.mMap.put((Object)key, value);
    }

    public <T> T get(Class key) {
        return (T)this.mMap.get((Object)key);
    }

    public Map<Class, Object> toMap() {
        return Collections.unmodifiableMap(this.mMap);
    }

    @ThreadSafe(enableChecks=false)
    public static TreeProps copy(TreeProps source) {
        TreeProps newProps = ComponentsPools.acquireTreeProps();
        if (source != null) {
            newProps.mMap.putAll(source.mMap);
        }
        return newProps;
    }

    void reset() {
        this.mMap.clear();
    }
}

