/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.Transition;
import com.facebook.litho.TransitionSet;
import com.facebook.litho.animation.AnimatedProperties;
import java.util.ArrayList;

class TransitionUtils {
    TransitionUtils() {
    }

    public static boolean hasBoundsAnimation(String transitionKey, Transition transition) {
        if (transition instanceof TransitionSet) {
            ArrayList<Transition> children = ((TransitionSet)transition).getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                if (!TransitionUtils.hasBoundsAnimation(transitionKey, children.get(i))) continue;
                return true;
            }
            return false;
        }
        if (transition instanceof Transition.TransitionUnit) {
            Transition.TransitionUnit transitionUnit = (Transition.TransitionUnit)transition;
            return transitionUnit.targetsKey(transitionKey) && transitionUnit.targetsProperty(AnimatedProperties.HEIGHT);
        }
        if (transition instanceof Transition.TransitionUnitsBuilder) {
            Transition.TransitionUnitsBuilder builder = (Transition.TransitionUnitsBuilder)transition;
            ArrayList<Transition.TransitionUnit> units = builder.getTransitionUnits();
            int size = units.size();
            for (int i = 0; i < size; ++i) {
                if (!TransitionUtils.hasBoundsAnimation(transitionKey, units.get(i))) continue;
                return true;
            }
            return false;
        }
        throw new RuntimeException("Unhandled transition type: " + transition);
    }
}

