/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.view.View;
import android.view.ViewParent;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoView;
import com.facebook.litho.MountState;
import com.facebook.litho.ParallelTransitionSet;
import com.facebook.litho.Transition;
import com.facebook.litho.TransitionSet;
import com.facebook.litho.animation.AnimatedProperties;
import com.facebook.litho.animation.AnimatedProperty;
import com.facebook.litho.animation.AnimatedPropertyNode;
import com.facebook.litho.animation.AnimationBinding;
import com.facebook.litho.animation.AnimationBindingListener;
import com.facebook.litho.animation.ParallelBinding;
import com.facebook.litho.animation.PropertyAnimation;
import com.facebook.litho.animation.PropertyHandle;
import com.facebook.litho.animation.Resolver;
import com.facebook.litho.internal.ArraySet;
import java.util.ArrayList;

public class TransitionManager {
    private final SimpleArrayMap<AnimationBinding, ArraySet<PropertyHandle>> mAnimationsToPropertyHandles = new SimpleArrayMap();
    private final SimpleArrayMap<String, AnimationState> mAnimationStates = new SimpleArrayMap();
    private final SimpleArrayMap<PropertyHandle, Float> mInitialStatesToRestore = new SimpleArrayMap();
    private final ArraySet<AnimationBinding> mRunningRootAnimations = new ArraySet();
    private final TransitionsAnimationBindingListener mAnimationBindingListener = new TransitionsAnimationBindingListener();
    private final RootAnimationListener mRootAnimationListener = new RootAnimationListener();
    private final TransitionsResolver mResolver = new TransitionsResolver();
    private final OnAnimationCompleteListener mOnAnimationCompleteListener;
    private final MountState mMountState;
    private AnimationBinding mRootAnimationToRun;

    public TransitionManager(OnAnimationCompleteListener onAnimationCompleteListener, MountState mountState) {
        this.mOnAnimationCompleteListener = onAnimationCompleteListener;
        this.mMountState = mountState;
    }

    void setupTransitions(LayoutState currentLayoutState, LayoutState nextLayoutState, ArrayList<Transition> mountTimeTransitions) {
        int size = this.mAnimationStates.size();
        for (int i = 0; i < size; ++i) {
            ((AnimationState)this.mAnimationStates.valueAt((int)i)).seenInLastTransition = false;
        }
        SimpleArrayMap<String, LayoutOutput> nextTransitionKeys = nextLayoutState.getTransitionKeyMapping();
        if (currentLayoutState == null) {
            int size2 = nextTransitionKeys.size();
            for (int i = 0; i < size2; ++i) {
                String transitionKey = (String)nextTransitionKeys.keyAt(i);
                LayoutOutput nextLayoutOutput = (LayoutOutput)nextTransitionKeys.valueAt(i);
                this.recordLayoutOutputDiff(transitionKey, null, nextLayoutOutput);
            }
        } else {
            int i;
            SimpleArrayMap<String, LayoutOutput> currentTransitionKeys = currentLayoutState.getTransitionKeyMapping();
            boolean[] seenIndicesInNewLayout = new boolean[currentTransitionKeys.size()];
            int size3 = nextTransitionKeys.size();
            for (i = 0; i < size3; ++i) {
                String transitionKey = (String)nextTransitionKeys.keyAt(i);
                LayoutOutput nextLayoutOutput = (LayoutOutput)nextTransitionKeys.valueAt(i);
                int currentIndex = currentTransitionKeys.indexOfKey((Object)transitionKey);
                LayoutOutput currentLayoutOutput = null;
                if (currentIndex >= 0) {
                    currentLayoutOutput = (LayoutOutput)currentTransitionKeys.valueAt(currentIndex);
                    seenIndicesInNewLayout[currentIndex] = true;
                }
                this.recordLayoutOutputDiff(transitionKey, currentLayoutOutput, nextLayoutOutput);
            }
            size3 = currentTransitionKeys.size();
            for (i = 0; i < size3; ++i) {
                if (seenIndicesInNewLayout[i]) continue;
                this.recordLayoutOutputDiff((String)currentTransitionKeys.keyAt(i), (LayoutOutput)currentTransitionKeys.valueAt(i), null);
            }
        }
        this.createTransitionAnimations(this.getRootTransition(nextLayoutState, mountTimeTransitions));
        this.cleanupNonAnimatingAnimationStates();
    }

    void runTransitions() {
        this.restoreInitialStates();
        if (this.mRootAnimationToRun != null) {
            this.mRootAnimationToRun.addListener(this.mRootAnimationListener);
            this.mRootAnimationToRun.start(this.mResolver);
            this.mRootAnimationToRun = null;
        }
        this.cleanupLayoutOutputs();
    }

    void setMountContent(String transitionKey, Object mountContent) {
        AnimationState animationState = (AnimationState)this.mAnimationStates.get((Object)transitionKey);
        if (animationState != null) {
            this.setMountContentInner(transitionKey, animationState, mountContent);
        }
    }

    boolean isKeyAnimating(String key) {
        return this.mAnimationStates.containsKey((Object)key);
    }

    boolean isKeyDisappearing(String key) {
        AnimationState animationState = (AnimationState)this.mAnimationStates.get((Object)key);
        if (animationState == null) {
            return false;
        }
        return animationState.changeType == 2;
    }

    void reset() {
        int i;
        int size = this.mAnimationStates.size();
        for (i = 0; i < size; ++i) {
            String key = (String)this.mAnimationStates.keyAt(i);
            AnimationState animationState = (AnimationState)this.mAnimationStates.valueAt(i);
            this.setMountContentInner(key, animationState, null);
            TransitionManager.clearLayoutOutputs(animationState);
        }
        this.mAnimationStates.clear();
        this.mAnimationsToPropertyHandles.clear();
        for (i = this.mRunningRootAnimations.size() - 1; i >= 0; --i) {
            this.mRunningRootAnimations.valueAt(i).stop();
        }
        this.mRunningRootAnimations.clear();
        this.mRootAnimationToRun = null;
    }

    private void recordLayoutOutputDiff(String transitionKey, LayoutOutput currentLayoutOutput, LayoutOutput nextLayoutOutput) {
        AnimationState animationState = (AnimationState)this.mAnimationStates.get((Object)transitionKey);
        if (animationState == null) {
            animationState = new AnimationState();
            this.mAnimationStates.put((Object)transitionKey, (Object)animationState);
        }
        if (currentLayoutOutput == null && nextLayoutOutput == null) {
            throw new RuntimeException("Both current and next LayoutOutputs were null!");
        }
        animationState.changeType = currentLayoutOutput == null && nextLayoutOutput != null ? 0 : (currentLayoutOutput != null && nextLayoutOutput != null ? 1 : 2);
        animationState.currentLayoutOutput = currentLayoutOutput;
        animationState.nextLayoutOutput = nextLayoutOutput;
        if (animationState.currentLayoutOutput != null) {
            animationState.currentLayoutOutput.incrementRefCount();
        }
        if (animationState.nextLayoutOutput != null) {
            animationState.nextLayoutOutput.incrementRefCount();
        }
        this.recordLastMountedValues(animationState);
        animationState.seenInLastTransition = true;
    }

    private void recordLastMountedValues(AnimationState animationState) {
        int size = animationState.propertyStates.size();
        for (int i = 0; i < size; ++i) {
            PropertyState propertyState = (PropertyState)animationState.propertyStates.valueAt(i);
            if (animationState.nextLayoutOutput == null) {
                propertyState.lastMountedValue = null;
                continue;
            }
            AnimatedProperty property = (AnimatedProperty)animationState.propertyStates.keyAt(i);
            propertyState.lastMountedValue = Float.valueOf(property.get(animationState.nextLayoutOutput));
        }
    }

    private Transition getRootTransition(LayoutState nextLayoutState, ArrayList<Transition> mountTimeTransitions) {
        ArrayList<Transition> layoutStateTransitions;
        ArrayList<Transition> arrayList = layoutStateTransitions = nextLayoutState.getTransitionContext() != null ? nextLayoutState.getTransitionContext().getTransitions() : null;
        if (mountTimeTransitions == null || mountTimeTransitions.isEmpty()) {
            return this.getRootTransitionFromList(layoutStateTransitions);
        }
        if (layoutStateTransitions == null || layoutStateTransitions.isEmpty()) {
            return this.getRootTransitionFromList(mountTimeTransitions);
        }
        ArrayList<Transition> mergedList = new ArrayList<Transition>(layoutStateTransitions.size() + mountTimeTransitions.size());
        mergedList.addAll(layoutStateTransitions);
        mergedList.addAll(mountTimeTransitions);
        return new ParallelTransitionSet(mergedList);
    }

    private Transition getRootTransitionFromList(ArrayList<Transition> transitions) {
        if (transitions == null || transitions.isEmpty()) {
            throw new RuntimeException("Expected list of transitions to be non-empty");
        }
        if (transitions.size() == 1) {
            return transitions.get(0);
        }
        return new ParallelTransitionSet(transitions);
    }

    private void createTransitionAnimations(Transition rootTransition) {
        this.mRootAnimationToRun = this.createAnimationsForTransition(rootTransition);
    }

    private AnimationBinding createAnimationsForTransition(Transition transition) {
        if (transition instanceof Transition.TransitionUnit) {
            return this.createAnimationsForTransitionUnit((Transition.TransitionUnit)transition);
        }
        if (transition instanceof TransitionSet) {
            return this.createAnimationsForTransitionSet((TransitionSet)transition);
        }
        throw new RuntimeException("Unhandled Transition type: " + transition);
    }

    private AnimationBinding createAnimationsForTransitionSet(TransitionSet transitionSet) {
        ArrayList<Transition> children = transitionSet.getChildren();
        ArrayList<AnimationBinding> createdAnimations = new ArrayList<AnimationBinding>();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            AnimationBinding animation = this.createAnimationsForTransition(children.get(i));
            if (animation == null) continue;
            createdAnimations.add(animation);
        }
        if (createdAnimations.isEmpty()) {
            return null;
        }
        return transitionSet.createAnimation(createdAnimations);
    }

    private AnimationBinding createAnimationsForTransitionUnit(Transition.TransitionUnit transition) {
        Transition.AnimationTarget animationTarget = transition.getAnimationTarget();
        ArrayList<AnimationBinding> createdAnimations = new ArrayList<AnimationBinding>();
        switch (animationTarget.componentTarget.componentTargetType) {
            case ALL: {
                this.createAnimationsForTransitionUnitAllKeys(transition, createdAnimations);
                break;
            }
            case SET: {
                String[] keys = (String[])animationTarget.componentTarget.componentTargetExtraData;
                for (int j = 0; j < keys.length; ++j) {
                    this.createAnimationsForTransitionUnit(transition, keys[j], createdAnimations);
                }
                break;
            }
            case SINGLE: {
                this.createAnimationsForTransitionUnit(transition, (String)animationTarget.componentTarget.componentTargetExtraData, createdAnimations);
            }
        }
        if (createdAnimations.isEmpty()) {
            return null;
        }
        if (createdAnimations.size() == 1) {
            return createdAnimations.get(0);
        }
        return new ParallelBinding(0, createdAnimations);
    }

    private void createAnimationsForTransitionUnitAllKeys(Transition.TransitionUnit transition, ArrayList<AnimationBinding> outList) {
        int size = this.mAnimationStates.size();
        for (int i = 0; i < size; ++i) {
            AnimationState animationState = (AnimationState)this.mAnimationStates.valueAt(i);
            if (!animationState.seenInLastTransition) continue;
            this.createAnimationsForTransitionUnit(transition, (String)this.mAnimationStates.keyAt(i), outList);
        }
    }

    private void createAnimationsForTransitionUnit(Transition.TransitionUnit transition, String key, ArrayList<AnimationBinding> outList) {
        Transition.AnimationTarget animationTarget = transition.getAnimationTarget();
        switch (animationTarget.propertyTarget.propertyTargetType) {
            case ALL: {
                for (int i = 0; i < AnimatedProperties.ALL_PROPERTIES.length; ++i) {
                    AnimationBinding createdAnimation = this.maybeCreateAnimation(transition, key, AnimatedProperties.ALL_PROPERTIES[i]);
                    if (createdAnimation == null) continue;
                    outList.add(createdAnimation);
                }
                break;
            }
            case SET: {
                AnimatedProperty[] properties = (AnimatedProperty[])animationTarget.propertyTarget.propertyTargetExtraData;
                for (int i = 0; i < properties.length; ++i) {
                    AnimationBinding createdAnimation = this.maybeCreateAnimation(transition, key, properties[i]);
                    if (createdAnimation == null) continue;
                    outList.add(createdAnimation);
                }
                break;
            }
            case SINGLE: {
                AnimationBinding createdAnimation = this.maybeCreateAnimation(transition, key, (AnimatedProperty)animationTarget.propertyTarget.propertyTargetExtraData);
                if (createdAnimation == null) break;
                outList.add(createdAnimation);
            }
        }
    }

    @Nullable
    private AnimationBinding maybeCreateAnimation(Transition.TransitionUnit transition, String key, AnimatedProperty property) {
        boolean isRoot;
        AnimationState animationState = (AnimationState)this.mAnimationStates.get((Object)key);
        if (animationState == null || animationState.currentLayoutOutput == null && animationState.nextLayoutOutput == null) {
            return null;
        }
        int changeType = animationState.changeType;
        String changeTypeString = TransitionManager.changeTypeToString(animationState.changeType);
        if (changeType == 0 && !transition.hasAppearAnimation() || changeType == 2 && !transition.hasDisappearAnimation()) {
            return null;
        }
        PropertyState existingState = (PropertyState)animationState.propertyStates.get((Object)property);
        PropertyHandle propertyHandle = new PropertyHandle(key, property);
        float startValue = existingState != null ? existingState.animatedPropertyNode.getValue() : (animationState.changeType != 0 ? property.get(animationState.currentLayoutOutput) : transition.getAppearFrom().resolve(this.mResolver, propertyHandle));
        LayoutOutput layoutOutput = animationState.nextLayoutOutput != null ? animationState.nextLayoutOutput : animationState.currentLayoutOutput;
        boolean bl = isRoot = layoutOutput.getId() == 0L;
        if (isRoot && property == AnimatedProperties.HEIGHT && !this.mMountState.getLithoView().isExpectingBoundsAnimation()) {
            return null;
        }
        float endValue = animationState.changeType != 2 ? property.get(animationState.nextLayoutOutput) : transition.getDisappearTo().resolve(this.mResolver, propertyHandle);
        if (existingState != null && existingState.targetValue != null ? endValue == existingState.targetValue.floatValue() : startValue == endValue) {
            return null;
        }
        AnimationBinding animation = transition.createAnimation(propertyHandle, endValue);
        animation.addListener(this.mAnimationBindingListener);
        PropertyState propertyState = existingState;
        if (propertyState == null) {
            propertyState = new PropertyState();
            propertyState.animatedPropertyNode = new AnimatedPropertyNode(animationState.mountContent, property);
            animationState.propertyStates.put((Object)property, (Object)propertyState);
        }
        propertyState.animatedPropertyNode.setValue(startValue);
        ++propertyState.numPendingAnimations;
        ArraySet<PropertyHandle> animatedPropertyHandles = new ArraySet<PropertyHandle>();
        animatedPropertyHandles.add(propertyHandle);
        this.mAnimationsToPropertyHandles.put((Object)animation, animatedPropertyHandles);
        this.mInitialStatesToRestore.put((Object)propertyHandle, (Object)Float.valueOf(startValue));
        return animation;
    }

    private void restoreInitialStates() {
        int size = this.mInitialStatesToRestore.size();
        for (int i = 0; i < size; ++i) {
            PropertyHandle propertyHandle = (PropertyHandle)this.mInitialStatesToRestore.keyAt(i);
            float value = ((Float)this.mInitialStatesToRestore.valueAt(i)).floatValue();
            AnimationState animationState = (AnimationState)this.mAnimationStates.get((Object)propertyHandle.getTransitionKey());
            AnimatedProperty property = propertyHandle.getProperty();
            property.set(animationState.mountContent, value);
        }
        this.mInitialStatesToRestore.clear();
    }

    private void setMountContentInner(String key, AnimationState animationState, Object mountContent) {
        int i;
        int size;
        if (animationState.mountContent == mountContent) {
            return;
        }
        SimpleArrayMap<AnimatedProperty, PropertyState> animatingProperties = animationState.propertyStates;
        if (animationState.mountContent != null) {
            size = animatingProperties.size();
            for (i = 0; i < size; ++i) {
                ((AnimatedProperty)animatingProperties.keyAt(i)).reset(animationState.mountContent);
            }
            this.recursivelySetChildClipping(animationState.mountContent, true);
        }
        size = animatingProperties.size();
        for (i = 0; i < size; ++i) {
            ((PropertyState)animatingProperties.valueAt((int)i)).animatedPropertyNode.setMountContent(mountContent);
        }
        this.recursivelySetChildClipping(mountContent, false);
        animationState.mountContent = mountContent;
    }

    private void recursivelySetChildClipping(Object mountContent, boolean clipChildren) {
        if (!(mountContent instanceof View)) {
            return;
        }
        this.recursivelySetChildClippingForView((View)mountContent, clipChildren);
    }

    private void recursivelySetChildClippingForView(View view, boolean clipChildren) {
        ViewParent parent;
        if (view instanceof ComponentHost) {
            ((ComponentHost)view).setClipChildren(clipChildren);
        }
        if ((parent = view.getParent()) instanceof ComponentHost) {
            this.recursivelySetChildClippingForView((View)parent, clipChildren);
        }
    }

    private void cleanupNonAnimatingAnimationStates() {
        for (int i = this.mAnimationStates.size() - 1; i >= 0; --i) {
            AnimationState animationState = (AnimationState)this.mAnimationStates.valueAt(i);
            if (!animationState.propertyStates.isEmpty()) continue;
            this.setMountContentInner((String)this.mAnimationStates.keyAt(i), animationState, null);
            TransitionManager.clearLayoutOutputs((AnimationState)this.mAnimationStates.removeAt(i));
        }
    }

    private void cleanupLayoutOutputs() {
        for (int i = 0; i < this.mAnimationStates.size(); ++i) {
            AnimationState animationState = (AnimationState)this.mAnimationStates.valueAt(i);
            TransitionManager.clearLayoutOutputs(animationState);
        }
    }

    private void debugLogStartingAnimations() {
        throw new RuntimeException("Trying to debug log animations without debug flag set!");
    }

    private static String changeTypeToString(int changeType) {
        switch (changeType) {
            case 0: {
                return "APPEARED";
            }
            case 1: {
                return "CHANGED";
            }
            case 2: {
                return "DISAPPEARED";
            }
            case -1: {
                return "UNSET";
            }
        }
        throw new RuntimeException("Unknown changeType: " + changeType);
    }

    private static void clearLayoutOutputs(AnimationState animationState) {
        if (animationState.currentLayoutOutput != null) {
            animationState.currentLayoutOutput.decrementRefCount();
            animationState.currentLayoutOutput = null;
        }
        if (animationState.nextLayoutOutput != null) {
            animationState.nextLayoutOutput.decrementRefCount();
            animationState.nextLayoutOutput = null;
        }
    }

    private class RootAnimationListener
    implements AnimationBindingListener {
        private RootAnimationListener() {
        }

        @Override
        public void onWillStart(AnimationBinding binding) {
            TransitionManager.this.mRunningRootAnimations.add(binding);
        }

        @Override
        public void onFinish(AnimationBinding binding) {
            TransitionManager.this.mRunningRootAnimations.remove(binding);
        }

        @Override
        public void onCanceledBeforeStart(AnimationBinding binding) {
            TransitionManager.this.mRunningRootAnimations.remove(binding);
        }

        @Override
        public boolean shouldStart(AnimationBinding binding) {
            return true;
        }
    }

    private class TransitionsResolver
    implements Resolver {
        private TransitionsResolver() {
        }

        @Override
        public float getCurrentState(PropertyHandle propertyHandle) {
            LayoutOutput layoutOutputToCheck;
            AnimatedProperty animatedProperty = propertyHandle.getProperty();
            AnimationState animationState = (AnimationState)TransitionManager.this.mAnimationStates.get((Object)propertyHandle.getTransitionKey());
            PropertyState propertyState = (PropertyState)animationState.propertyStates.get((Object)animatedProperty);
            if (propertyState != null) {
                return propertyState.animatedPropertyNode.getValue();
            }
            LayoutOutput layoutOutput = layoutOutputToCheck = animationState.changeType == 0 ? animationState.nextLayoutOutput : animationState.currentLayoutOutput;
            if (layoutOutputToCheck == null) {
                throw new RuntimeException("Both LayoutOutputs were null!");
            }
            return animatedProperty.get(layoutOutputToCheck);
        }

        @Override
        public AnimatedPropertyNode getAnimatedPropertyNode(PropertyHandle propertyHandle) {
            AnimationState state = (AnimationState)TransitionManager.this.mAnimationStates.get((Object)propertyHandle.getTransitionKey());
            PropertyState propertyState = (PropertyState)state.propertyStates.get((Object)propertyHandle.getProperty());
            return propertyState.animatedPropertyNode;
        }
    }

    private class TransitionsAnimationBindingListener
    implements AnimationBindingListener {
        private final ArrayList<PropertyAnimation> mTempPropertyAnimations = new ArrayList();

        private TransitionsAnimationBindingListener() {
        }

        @Override
        public void onWillStart(AnimationBinding binding) {
            binding.collectTransitioningProperties(this.mTempPropertyAnimations);
            int size = this.mTempPropertyAnimations.size();
            for (int i = 0; i < size; ++i) {
                PropertyAnimation propertyAnimation = this.mTempPropertyAnimations.get(i);
                String key = propertyAnimation.getTransitionKey();
                AnimationState animationState = (AnimationState)TransitionManager.this.mAnimationStates.get((Object)key);
                PropertyState propertyState = (PropertyState)animationState.propertyStates.get((Object)propertyAnimation.getProperty());
                propertyState.targetValue = Float.valueOf(propertyAnimation.getTargetValue());
                propertyState.animation = binding;
            }
            this.mTempPropertyAnimations.clear();
        }

        @Override
        public void onFinish(AnimationBinding binding) {
            this.finishAnimation(binding);
        }

        @Override
        public void onCanceledBeforeStart(AnimationBinding binding) {
            this.finishAnimation(binding);
        }

        @Override
        public boolean shouldStart(AnimationBinding binding) {
            binding.collectTransitioningProperties(this.mTempPropertyAnimations);
            boolean shouldStart = true;
            int size = this.mTempPropertyAnimations.size();
            for (int i = 0; i < size; ++i) {
                PropertyAnimation propertyAnimation = this.mTempPropertyAnimations.get(i);
                String key = propertyAnimation.getTransitionKey();
                AnimationState animationState = (AnimationState)TransitionManager.this.mAnimationStates.get((Object)key);
                PropertyState propertyState = (PropertyState)animationState.propertyStates.get((Object)propertyAnimation.getProperty());
                if (propertyState.lastMountedValue == null || propertyState.lastMountedValue.floatValue() == propertyAnimation.getTargetValue()) continue;
                shouldStart = false;
            }
            this.mTempPropertyAnimations.clear();
            return shouldStart;
        }

        private void finishAnimation(AnimationBinding binding) {
            ArraySet keys = (ArraySet)TransitionManager.this.mAnimationsToPropertyHandles.remove((Object)binding);
            if (keys == null) {
                return;
            }
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                boolean didFinish;
                boolean isDisappearAnimation;
                PropertyHandle propertyHandle = (PropertyHandle)keys.valueAt(i);
                String key = propertyHandle.getTransitionKey();
                AnimatedProperty property = propertyHandle.getProperty();
                AnimationState animationState = (AnimationState)TransitionManager.this.mAnimationStates.get((Object)key);
                boolean bl = isDisappearAnimation = animationState.changeType == 2;
                if (isDisappearAnimation) {
                    PropertyState propertyState = (PropertyState)animationState.propertyStates.get((Object)property);
                    if (propertyState == null) {
                        throw new RuntimeException("Some animation bookkeeping is wrong: tried to remove an animation from the list of active animations, but it wasn't there.");
                    }
                    --propertyState.numPendingAnimations;
                    didFinish = this.areAllDisappearingAnimationsFinished(animationState);
                    if (didFinish && animationState.mountContent != null) {
                        for (int j = 0; j < animationState.propertyStates.size(); ++j) {
                            ((AnimatedProperty)animationState.propertyStates.keyAt(j)).reset(animationState.mountContent);
                        }
                    }
                } else {
                    int index = animationState.propertyStates.indexOfKey((Object)property);
                    if (index < 0) {
                        throw new RuntimeException("Some animation bookkeeping is wrong: tried to remove an animation from the list of active animations, but it wasn't there.");
                    }
                    PropertyState propertyState = (PropertyState)animationState.propertyStates.valueAt(index);
                    --propertyState.numPendingAnimations;
                    if (propertyState.numPendingAnimations > 0) {
                        didFinish = false;
                    } else {
                        animationState.propertyStates.removeAt(index);
                        didFinish = animationState.propertyStates.isEmpty();
                        if (animationState.mountContent != null) {
                            property.reset(animationState.mountContent);
                        }
                    }
                }
                if (!didFinish) continue;
                if (animationState.mountContent instanceof LithoView) {
                    ((LithoView)((Object)animationState.mountContent)).endBoundsAnimation();
                }
                TransitionManager.this.recursivelySetChildClipping(animationState.mountContent, true);
                if (TransitionManager.this.mOnAnimationCompleteListener != null) {
                    TransitionManager.this.mOnAnimationCompleteListener.onAnimationComplete(key);
                }
                TransitionManager.this.mAnimationStates.remove((Object)key);
                TransitionManager.clearLayoutOutputs(animationState);
            }
        }

        private boolean areAllDisappearingAnimationsFinished(AnimationState animationState) {
            if (animationState.changeType != 2) {
                throw new RuntimeException("This should only be checked for disappearing animations");
            }
            int size = animationState.propertyStates.size();
            for (int i = 0; i < size; ++i) {
                PropertyState propertyState = (PropertyState)animationState.propertyStates.valueAt(i);
                AnimationBinding animation = propertyState.animation;
                if (propertyState.numPendingAnimations <= 0 && (animation == null || !animation.isActive())) continue;
                return false;
            }
            return true;
        }
    }

    private static class AnimationState {
        public final SimpleArrayMap<AnimatedProperty, PropertyState> propertyStates = new SimpleArrayMap();
        public Object mountContent;
        public int changeType = -1;
        @Nullable
        public LayoutOutput currentLayoutOutput;
        @Nullable
        public LayoutOutput nextLayoutOutput;
        public boolean seenInLastTransition = false;

        private AnimationState() {
        }
    }

    private static class PropertyState {
        public AnimatedPropertyNode animatedPropertyNode;
        public AnimationBinding animation;
        public Float targetValue;
        public Float lastMountedValue;
        public int numPendingAnimations;

        private PropertyState() {
        }
    }

    public static interface OnAnimationCompleteListener {
        public void onAnimationComplete(String var1);
    }
}

