/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.ParallelTransitionSet;
import com.facebook.litho.SequenceTransitionSet;
import com.facebook.litho.TransitionSet;
import com.facebook.litho.animation.AnimatedProperty;
import com.facebook.litho.animation.AnimationBinding;
import com.facebook.litho.animation.FloatValue;
import com.facebook.litho.animation.PropertyAnimation;
import com.facebook.litho.animation.PropertyHandle;
import com.facebook.litho.animation.RuntimeValue;
import com.facebook.litho.animation.SpringTransition;
import com.facebook.litho.animation.TransitionAnimationBinding;
import java.util.ArrayList;

public abstract class Transition {
    private static final TransitionAnimator DEFAULT_ANIMATOR = new SpringTransitionAnimator();

    public static ComponentTarget allKeys() {
        return new ComponentTarget(ComponentTargetType.ALL, null);
    }

    public static PropertyTarget allProperties() {
        return new PropertyTarget(PropertyTargetType.ALL, null);
    }

    public static TransitionUnitsBuilder create(String key) {
        return new TransitionUnitsBuilder(ComponentTargetType.SINGLE, key);
    }

    public static TransitionUnitsBuilder create(String ... keys) {
        return new TransitionUnitsBuilder(ComponentTargetType.SET, keys);
    }

    public static TransitionUnitsBuilder create(ComponentTarget target) {
        return new TransitionUnitsBuilder(target.componentTargetType, target.componentTargetExtraData);
    }

    public static <T extends Transition> TransitionSet parallel(T ... transitions) {
        return new ParallelTransitionSet(transitions);
    }

    public static <T extends Transition> TransitionSet stagger(int staggerMs, T ... transitions) {
        return new ParallelTransitionSet(staggerMs, transitions);
    }

    public static <T extends Transition> TransitionSet sequence(T ... transitions) {
        return new SequenceTransitionSet(transitions);
    }

    private static <T> boolean arrayContains(T[] array, T value) {
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static class SpringTransitionAnimator
    implements TransitionAnimator {
        @Override
        public TransitionAnimationBinding createAnimation(PropertyAnimation propertyAnimation) {
            return new SpringTransition(propertyAnimation);
        }
    }

    public static class TransitionUnitsBuilder
    extends Transition {
        private final ArrayList<TransitionUnit> mBuiltTransitions = new ArrayList();
        private final ComponentTarget mComponentTarget;
        private PropertyTarget mPropertyTarget;
        private TransitionAnimator mTransitionAnimator = Transition.access$100();
        private RuntimeValue mAppearFrom;
        private RuntimeValue mDisappearTo;

        TransitionUnitsBuilder(ComponentTarget componentTarget) {
            this.mComponentTarget = componentTarget;
        }

        TransitionUnitsBuilder(ComponentTargetType componentTargetType, Object componentTargetExtraData) {
            this.mComponentTarget = new ComponentTarget(componentTargetType, componentTargetExtraData);
        }

        public TransitionUnitsBuilder animate(AnimatedProperty property) {
            this.maybeCommitCurrentBuilder();
            this.mPropertyTarget = new PropertyTarget(PropertyTargetType.SINGLE, property);
            return this;
        }

        public TransitionUnitsBuilder animate(AnimatedProperty ... properties) {
            this.maybeCommitCurrentBuilder();
            this.mPropertyTarget = new PropertyTarget(PropertyTargetType.SET, properties);
            return this;
        }

        public TransitionUnitsBuilder animate(PropertyTarget propertyTarget) {
            this.maybeCommitCurrentBuilder();
            this.mPropertyTarget = propertyTarget;
            return this;
        }

        public TransitionUnitsBuilder animator(TransitionAnimator animator) {
            this.mTransitionAnimator = animator;
            return this;
        }

        public TransitionUnitsBuilder appearFrom(RuntimeValue value) {
            if (this.mPropertyTarget == null || this.mPropertyTarget.propertyTargetType != PropertyTargetType.SINGLE) {
                throw new RuntimeException("Must specify a single property using #animate() before specifying an appearFrom value!");
            }
            this.mAppearFrom = value;
            return this;
        }

        public TransitionUnitsBuilder disappearTo(RuntimeValue value) {
            if (this.mPropertyTarget == null || this.mPropertyTarget.propertyTargetType != PropertyTargetType.SINGLE) {
                throw new RuntimeException("Must specify a single property using #animate() before specifying an disappearTo value!");
            }
            this.mDisappearTo = value;
            return this;
        }

        public TransitionUnitsBuilder appearFrom(float value) {
            return this.appearFrom(new FloatValue(value));
        }

        public TransitionUnitsBuilder disappearTo(float value) {
            return this.disappearTo(new FloatValue(value));
        }

        ArrayList<TransitionUnit> getTransitionUnits() {
            this.maybeCommitCurrentBuilder();
            return this.mBuiltTransitions;
        }

        private void maybeCommitCurrentBuilder() {
            if (this.mPropertyTarget == null) {
                return;
            }
            this.mBuiltTransitions.add(new TransitionUnit(new AnimationTarget(this.mComponentTarget, this.mPropertyTarget), this.mTransitionAnimator, this.mAppearFrom, this.mDisappearTo));
            this.mPropertyTarget = null;
            this.mTransitionAnimator = DEFAULT_ANIMATOR;
            this.mAppearFrom = null;
            this.mDisappearTo = null;
        }
    }

    public static class TransitionUnit
    extends Transition {
        private final AnimationTarget mAnimationTarget;
        private final TransitionAnimator mTransitionAnimator;
        private final RuntimeValue mAppearFrom;
        private final RuntimeValue mDisappearTo;

        TransitionUnit(AnimationTarget animationTarget, TransitionAnimator transitionAnimator, RuntimeValue appearFrom, RuntimeValue disappearTo) {
            this.mAnimationTarget = animationTarget;
            this.mTransitionAnimator = transitionAnimator;
            this.mAppearFrom = appearFrom;
            this.mDisappearTo = disappearTo;
        }

        AnimationTarget getAnimationTarget() {
            return this.mAnimationTarget;
        }

        boolean hasAppearAnimation() {
            return this.mAppearFrom != null;
        }

        boolean hasDisappearAnimation() {
            return this.mDisappearTo != null;
        }

        RuntimeValue getAppearFrom() {
            return this.mAppearFrom;
        }

        RuntimeValue getDisappearTo() {
            return this.mDisappearTo;
        }

        AnimationBinding createAnimation(PropertyHandle propertyHandle, float targetValue) {
            PropertyAnimation propertyAnimation = new PropertyAnimation(propertyHandle, targetValue);
            return this.mTransitionAnimator.createAnimation(propertyAnimation);
        }

        boolean targetsKey(String key) {
            switch (this.mAnimationTarget.componentTarget.componentTargetType) {
                case ALL: {
                    return true;
                }
                case SET: {
                    return Transition.arrayContains((String[])this.mAnimationTarget.componentTarget.componentTargetExtraData, key);
                }
                case SINGLE: {
                    return key.equals(this.mAnimationTarget.componentTarget.componentTargetExtraData);
                }
            }
            throw new RuntimeException("Didn't handle type: " + (Object)((Object)this.mAnimationTarget.componentTarget.componentTargetType));
        }

        boolean targetsProperty(AnimatedProperty property) {
            switch (this.mAnimationTarget.propertyTarget.propertyTargetType) {
                case ALL: {
                    return true;
                }
                case SET: {
                    return Transition.arrayContains((AnimatedProperty[])this.mAnimationTarget.propertyTarget.propertyTargetExtraData, property);
                }
                case SINGLE: {
                    return property.equals(this.mAnimationTarget.propertyTarget.propertyTargetExtraData);
                }
            }
            throw new RuntimeException("Didn't handle type: " + this.mAnimationTarget.propertyTarget.propertyTargetExtraData);
        }
    }

    public static interface TransitionAnimator {
        public TransitionAnimationBinding createAnimation(PropertyAnimation var1);
    }

    public static class PropertyTarget {
        public final PropertyTargetType propertyTargetType;
        public final Object propertyTargetExtraData;

        PropertyTarget(PropertyTargetType propertyTargetType, Object propertyTargetExtraData) {
            this.propertyTargetType = propertyTargetType;
            this.propertyTargetExtraData = propertyTargetExtraData;
        }
    }

    public static class ComponentTarget {
        public final ComponentTargetType componentTargetType;
        public final Object componentTargetExtraData;

        ComponentTarget(ComponentTargetType componentTargetType, Object componentTargetExtraData) {
            this.componentTargetType = componentTargetType;
            this.componentTargetExtraData = componentTargetExtraData;
        }
    }

    public static class AnimationTarget {
        public final ComponentTarget componentTarget;
        public final PropertyTarget propertyTarget;

        AnimationTarget(ComponentTarget componentTarget, PropertyTarget propertyTarget) {
            this.componentTarget = componentTarget;
            this.propertyTarget = propertyTarget;
        }
    }

    static enum PropertyTargetType {
        ALL,
        SET,
        SINGLE;

    }

    static enum ComponentTargetType {
        ALL,
        SET,
        SINGLE;

    }
}

