/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.v4.util.Pools;
import android.support.v4.util.SparseArrayCompat;
import android.view.MotionEvent;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewConfiguration;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentHostUtils;

class TouchExpansionDelegate
extends TouchDelegate {
    private static final Rect IGNORED_RECT = new Rect();
    private static final Pools.SimplePool<SparseArrayCompat<InnerTouchDelegate>> sInnerTouchDelegateScrapArrayPool = new Pools.SimplePool(4);
    private final SparseArrayCompat<InnerTouchDelegate> mDelegates = new SparseArrayCompat();
    private SparseArrayCompat<InnerTouchDelegate> mScrapDelegates;

    TouchExpansionDelegate(ComponentHost host) {
        super(IGNORED_RECT, (View)host);
    }

    void registerTouchExpansion(int index, View view, Rect touchExpansion) {
        this.mDelegates.put(index, (Object)InnerTouchDelegate.acquire(view, touchExpansion));
    }

    void unregisterTouchExpansion(int index) {
        if (this.maybeUnregisterFromScrap(index)) {
            return;
        }
        int valueIndex = this.mDelegates.indexOfKey(index);
        InnerTouchDelegate touchDelegate = (InnerTouchDelegate)this.mDelegates.valueAt(valueIndex);
        this.mDelegates.removeAt(valueIndex);
        touchDelegate.release();
    }

    private boolean maybeUnregisterFromScrap(int index) {
        int valueIndex;
        if (this.mScrapDelegates != null && (valueIndex = this.mScrapDelegates.indexOfKey(index)) >= 0) {
            InnerTouchDelegate touchDelegate = (InnerTouchDelegate)this.mScrapDelegates.valueAt(valueIndex);
            this.mScrapDelegates.removeAt(valueIndex);
            touchDelegate.release();
            return true;
        }
        return false;
    }

    void draw(Canvas canvas, Paint paint) {
        for (int i = this.mDelegates.size() - 1; i >= 0; --i) {
            canvas.drawRect(((InnerTouchDelegate)this.mDelegates.valueAt(i)).mDelegateBounds, paint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        for (int i = this.mDelegates.size() - 1; i >= 0; --i) {
            InnerTouchDelegate touchDelegate = (InnerTouchDelegate)this.mDelegates.valueAt(i);
            if (!touchDelegate.onTouchEvent(event)) continue;
            return true;
        }
        return false;
    }

    void moveTouchExpansionIndexes(int oldIndex, int newIndex) {
        if (this.mDelegates.get(newIndex) != null) {
            this.ensureScrapDelegates();
            ComponentHostUtils.scrapItemAt(newIndex, this.mDelegates, this.mScrapDelegates);
        }
        ComponentHostUtils.moveItem(oldIndex, newIndex, this.mDelegates, this.mScrapDelegates);
        this.releaseScrapDelegatesIfNeeded();
    }

    private void ensureScrapDelegates() {
        if (this.mScrapDelegates == null) {
            this.mScrapDelegates = TouchExpansionDelegate.acquireScrapTouchDelegatesArray();
        }
    }

    private static SparseArrayCompat<InnerTouchDelegate> acquireScrapTouchDelegatesArray() {
        SparseArrayCompat sparseArray = (SparseArrayCompat)sInnerTouchDelegateScrapArrayPool.acquire();
        if (sparseArray == null) {
            sparseArray = new SparseArrayCompat(4);
        }
        return sparseArray;
    }

    private void releaseScrapDelegatesIfNeeded() {
        if (this.mScrapDelegates != null && this.mScrapDelegates.size() == 0) {
            TouchExpansionDelegate.releaseScrapTouchDelegatesArray(this.mScrapDelegates);
            this.mScrapDelegates = null;
        }
    }

    private static void releaseScrapTouchDelegatesArray(SparseArrayCompat<InnerTouchDelegate> sparseArray) {
        sInnerTouchDelegateScrapArrayPool.release(sparseArray);
    }

    private static class InnerTouchDelegate {
        private static final Pools.SimplePool<InnerTouchDelegate> sPool = new Pools.SimplePool(4);
        private View mDelegateView;
        private boolean mIsHandlingTouch;
        private int mSlop;
        private final Rect mDelegateBounds = new Rect();
        private final Rect mDelegateSlopBounds = new Rect();

        private InnerTouchDelegate() {
        }

        void init(View delegateView, Rect delegateBounds) {
            this.mDelegateView = delegateView;
            this.mSlop = ViewConfiguration.get((Context)delegateView.getContext()).getScaledTouchSlop();
            this.mDelegateBounds.set(delegateBounds);
            this.mDelegateSlopBounds.set(delegateBounds);
            this.mDelegateSlopBounds.inset(-this.mSlop, -this.mSlop);
        }

        boolean onTouchEvent(MotionEvent event) {
            int x = (int)event.getX();
            int y = (int)event.getY();
            boolean shouldDelegateTouchEvent = false;
            boolean touchWithinViewBounds = true;
            boolean handled = false;
            switch (event.getAction()) {
                case 0: {
                    shouldDelegateTouchEvent = this.mIsHandlingTouch = this.mDelegateBounds.contains(x, y);
                    break;
                }
                case 1: 
                case 2: {
                    shouldDelegateTouchEvent = this.mIsHandlingTouch;
                    if (this.mIsHandlingTouch && !this.mDelegateSlopBounds.contains(x, y)) {
                        touchWithinViewBounds = false;
                    }
                    if (event.getAction() != 1) break;
                    this.mIsHandlingTouch = false;
                    break;
                }
                case 3: {
                    shouldDelegateTouchEvent = this.mIsHandlingTouch;
                    this.mIsHandlingTouch = false;
                }
            }
            if (shouldDelegateTouchEvent) {
                if (touchWithinViewBounds) {
                    event.setLocation((float)(this.mDelegateView.getWidth() / 2), (float)(this.mDelegateView.getHeight() / 2));
                } else {
                    event.setLocation((float)(-(this.mSlop * 2)), (float)(-(this.mSlop * 2)));
                }
                handled = this.mDelegateView.dispatchTouchEvent(event);
            }
            return handled;
        }

        static InnerTouchDelegate acquire(View delegateView, Rect bounds) {
            InnerTouchDelegate touchDelegate = (InnerTouchDelegate)sPool.acquire();
            if (touchDelegate == null) {
                touchDelegate = new InnerTouchDelegate();
            }
            touchDelegate.init(delegateView, bounds);
            return touchDelegate;
        }

        void release() {
            this.mDelegateView = null;
            this.mDelegateBounds.setEmpty();
            this.mDelegateSlopBounds.setEmpty();
            this.mIsHandlingTouch = false;
            this.mSlop = 0;
            sPool.release((Object)this);
        }
    }
}

