/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.Nullable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.DiffNode;
import com.facebook.litho.LayoutState;
import com.facebook.litho.StateHandler;
import com.facebook.litho.TestComponent;
import com.facebook.litho.TestComponentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TestComponentTree
extends ComponentTree {
    public static Builder create(ComponentContext context, Component<?> root) {
        return new Builder(context, root);
    }

    private TestComponentTree(ComponentTree.Builder builder) {
        super(builder);
    }

    public List<Component> getSubComponents() {
        return TestComponentTree.extractSubComponents(this.getMainThreadLayoutState().getDiffTree());
    }

    @Override
    protected LayoutState calculateLayoutState(@Nullable Object lock, ComponentContext context, Component<?> root, int widthSpec, int heightSpec, boolean diffingEnabled, @Nullable DiffNode diffNode) {
        return LayoutState.calculate(new TestComponentContext((Context)ComponentContext.withComponentTree(new TestComponentContext((Context)context), this), new StateHandler()), root, this.mId, widthSpec, heightSpec, diffingEnabled, diffNode, false, false, true);
    }

    private static List<Component> extractSubComponents(DiffNode root) {
        if (root == null) {
            return Collections.emptyList();
        }
        ArrayList<Component> output = new ArrayList<Component>();
        if (root.getChildCount() == 0) {
            if (root.getComponent() != null && root.getComponent() instanceof TestComponent) {
                TestComponent testSubcomponent = (TestComponent)root.getComponent();
                output.add(testSubcomponent.getWrappedComponent());
            }
            return output;
        }
        for (DiffNode child : root.getChildren()) {
            output.addAll(TestComponentTree.extractSubComponents(child));
        }
        return output;
    }

    public static class Builder
    extends ComponentTree.Builder {
        private Builder(ComponentContext context, Component<?> root) {
            super(context, root);
        }

        @Override
        public Builder incrementalMount(boolean isEnabled) {
            return (Builder)super.incrementalMount(isEnabled);
        }

        @Override
        public Builder layoutDiffing(boolean enabled) {
            return (Builder)super.layoutDiffing(enabled);
        }

        @Override
        public Builder layoutThreadLooper(Looper looper) {
            return (Builder)super.layoutThreadLooper(looper);
        }

        @Override
        public Builder layoutLock(Object layoutLock) {
            return (Builder)super.layoutLock(layoutLock);
        }

        @Override
        public TestComponentTree build() {
            return new TestComponentTree(this);
        }
    }
}

