/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.support.v4.util.Pools;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentsPools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

public class StateHandler {
    private static final int INITIAL_STATE_UPDATE_LIST_CAPACITY = 4;
    private static final int INITIAL_MAP_CAPACITY = 4;
    private static final int POOL_CAPACITY = 10;
    private static final Pools.SynchronizedPool<List<ComponentLifecycle.StateUpdate>> sStateUpdatesListPool = new Pools.SynchronizedPool(10);
    private static final Pools.SynchronizedPool<Map<String, List<ComponentLifecycle.StateUpdate>>> sPendingStateUpdatesMapPool = new Pools.SynchronizedPool(10);
    private static final Pools.SynchronizedPool<Map<String, ComponentLifecycle.StateContainer>> sStateContainersMapPool = new Pools.SynchronizedPool(10);
    @GuardedBy(value="this")
    private Map<String, List<ComponentLifecycle.StateUpdate>> mPendingStateUpdates;
    @GuardedBy(value="this")
    public Map<String, ComponentLifecycle.StateContainer> mStateContainers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(StateHandler stateHandler) {
        if (stateHandler == null) {
            return;
        }
        StateHandler stateHandler2 = this;
        synchronized (stateHandler2) {
            this.copyPendingStateUpdatesMap(stateHandler.getPendingStateUpdates());
            this.copyCurrentStateContainers(stateHandler.getStateContainers());
        }
    }

    public static StateHandler acquireNewInstance(StateHandler stateHandler) {
        return ComponentsPools.acquireStateHandler(stateHandler);
    }

    public synchronized boolean isEmpty() {
        return this.mStateContainers == null || this.mStateContainers.isEmpty();
    }

    synchronized void queueStateUpdate(String key, ComponentLifecycle.StateUpdate stateUpdate) {
        this.maybeInitPendingUpdates();
        List<ComponentLifecycle.StateUpdate> pendingStateUpdatesForKey = this.mPendingStateUpdates.get(key);
        if (pendingStateUpdatesForKey == null) {
            pendingStateUpdatesForKey = StateHandler.acquireStateUpdatesList();
            this.mPendingStateUpdates.put(key, pendingStateUpdatesForKey);
        }
        pendingStateUpdatesForKey.add(stateUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe(enableChecks=false)
    void applyStateUpdatesForComponent(Component component) {
        List<ComponentLifecycle.StateUpdate> stateUpdatesForKey;
        ComponentLifecycle.StateContainer previousStateContainer;
        ComponentLifecycle.StateContainer currentStateContainer;
        this.maybeInitStateContainers();
        Object lifecycle = component.getLifecycle();
        if (!((ComponentLifecycle)lifecycle).hasState()) {
            return;
        }
        String key = component.getGlobalKey();
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            currentStateContainer = this.mStateContainers.get(key);
        }
        if (currentStateContainer != null) {
            ((ComponentLifecycle)lifecycle).transferState(component.getScopedContext(), currentStateContainer, component);
            previousStateContainer = currentStateContainer;
        } else {
            ((ComponentLifecycle)lifecycle).createInitialState(component.getScopedContext(), component);
            previousStateContainer = component.getStateContainer();
        }
        Object object = this;
        synchronized (object) {
            stateUpdatesForKey = this.mPendingStateUpdates == null ? null : this.mPendingStateUpdates.get(key);
        }
        if (stateUpdatesForKey != null) {
            for (ComponentLifecycle.StateUpdate update : stateUpdatesForKey) {
                update.updateState(previousStateContainer, component);
            }
        }
        object = this;
        synchronized (object) {
            this.mStateContainers.put(key, component.getStateContainer());
        }
    }

    void commit(StateHandler stateHandler) {
        this.clearStateUpdates(stateHandler.getPendingStateUpdates());
        this.updateCurrentComponentsWithState(stateHandler.getStateContainers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearStateUpdates(Map<String, List<ComponentLifecycle.StateUpdate>> appliedStateUpdates) {
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            if (appliedStateUpdates == null || this.mPendingStateUpdates == null || this.mPendingStateUpdates.isEmpty()) {
                return;
            }
        }
        for (String key : appliedStateUpdates.keySet()) {
            List<ComponentLifecycle.StateUpdate> pendingStateUpdatesForKey;
            StateHandler stateHandler2 = this;
            synchronized (stateHandler2) {
                pendingStateUpdatesForKey = this.mPendingStateUpdates.get(key);
            }
            if (pendingStateUpdatesForKey == null) continue;
            List<ComponentLifecycle.StateUpdate> appliedStateUpdatesForKey = appliedStateUpdates.get(key);
            if (pendingStateUpdatesForKey.size() == appliedStateUpdatesForKey.size()) {
                StateHandler stateHandler3 = this;
                synchronized (stateHandler3) {
                    this.mPendingStateUpdates.remove(key);
                }
                StateHandler.releaseStateUpdatesList(pendingStateUpdatesForKey);
                continue;
            }
            pendingStateUpdatesForKey.removeAll(appliedStateUpdatesForKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentComponentsWithState(Map<String, ComponentLifecycle.StateContainer> updatedStateContainers) {
        if (updatedStateContainers == null || updatedStateContainers.isEmpty()) {
            return;
        }
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            this.maybeInitStateContainers();
            this.mStateContainers.putAll(updatedStateContainers);
        }
    }

    synchronized void release() {
        if (this.mPendingStateUpdates != null) {
            this.mPendingStateUpdates.clear();
            sPendingStateUpdatesMapPool.release(this.mPendingStateUpdates);
            this.mPendingStateUpdates = null;
        }
        if (this.mStateContainers != null) {
            this.mStateContainers.clear();
            sStateContainersMapPool.release(this.mStateContainers);
            this.mStateContainers = null;
        }
    }

    private static List<ComponentLifecycle.StateUpdate> acquireStateUpdatesList() {
        return StateHandler.acquireStateUpdatesList(null);
    }

    private static List<ComponentLifecycle.StateUpdate> acquireStateUpdatesList(List<ComponentLifecycle.StateUpdate> copyFrom) {
        ArrayList<ComponentLifecycle.StateUpdate> list = (ArrayList<ComponentLifecycle.StateUpdate>)sStateUpdatesListPool.acquire();
        if (list == null) {
            list = new ArrayList<ComponentLifecycle.StateUpdate>(copyFrom == null ? 4 : copyFrom.size());
        }
        if (copyFrom != null) {
            list.addAll(copyFrom);
        }
        return list;
    }

    private static void releaseStateUpdatesList(List<ComponentLifecycle.StateUpdate> list) {
        list.clear();
        sStateUpdatesListPool.release(list);
    }

    synchronized Map<String, ComponentLifecycle.StateContainer> getStateContainers() {
        return this.mStateContainers;
    }

    synchronized Map<String, List<ComponentLifecycle.StateUpdate>> getPendingStateUpdates() {
        return this.mPendingStateUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPendingStateUpdatesMap(Map<String, List<ComponentLifecycle.StateUpdate>> pendingStateUpdates) {
        if (pendingStateUpdates == null || pendingStateUpdates.isEmpty()) {
            return;
        }
        this.maybeInitPendingUpdates();
        for (String key : pendingStateUpdates.keySet()) {
            StateHandler stateHandler = this;
            synchronized (stateHandler) {
                this.mPendingStateUpdates.put(key, StateHandler.acquireStateUpdatesList(pendingStateUpdates.get(key)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCurrentStateContainers(Map<String, ComponentLifecycle.StateContainer> stateContainers) {
        if (stateContainers == null || stateContainers.isEmpty()) {
            return;
        }
        this.maybeInitStateContainers();
        for (String key : stateContainers.keySet()) {
            StateHandler stateHandler = this;
            synchronized (stateHandler) {
                this.mStateContainers.put(key, stateContainers.get(key));
            }
        }
    }

    private synchronized void maybeInitStateContainers() {
        if (this.mStateContainers == null) {
            this.mStateContainers = (Map)sStateContainersMapPool.acquire();
            if (this.mStateContainers == null) {
                this.mStateContainers = new HashMap<String, ComponentLifecycle.StateContainer>(4);
            }
        }
    }

    private synchronized void maybeInitPendingUpdates() {
        if (this.mPendingStateUpdates == null) {
            this.mPendingStateUpdates = (Map)sPendingStateUpdatesMapPool.acquire();
            if (this.mPendingStateUpdates == null) {
                this.mPendingStateUpdates = new HashMap<String, List<ComponentLifecycle.StateUpdate>>(4);
            }
        }
    }
}

