/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.support.v4.util.SimpleArrayMap;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.internal.ArraySet;
import java.util.List;

public class RenderState {
    private final SimpleArrayMap<String, ComponentLifecycle.RenderData> mRenderData = new SimpleArrayMap();
    private final ArraySet<String> mSeenGlobalKeys = new ArraySet();

    void recordRenderData(List<Component> components) {
        if (components == null) {
            return;
        }
        int size = components.size();
        for (int i = 0; i < size; ++i) {
            this.recordRenderData(components.get(i));
        }
        this.mSeenGlobalKeys.clear();
    }

    void applyPreviousRenderData(List<Component> components) {
        if (components == null) {
            return;
        }
        int size = components.size();
        for (int i = 0; i < size; ++i) {
            this.applyPreviousRenderData(components.get(i));
        }
    }

    private void recordRenderData(Component component) {
        Object lifecycle = component.getLifecycle();
        if (!((ComponentLifecycle)lifecycle).needsPreviousRenderData()) {
            throw new RuntimeException("Trying to record previous render data for component that doesn't support it");
        }
        String key = component.getGlobalKey();
        if (this.mSeenGlobalKeys.contains(key)) {
            throw new RuntimeException("Cannot record previous render data for " + component.getSimpleName() + ", found another Component with the same key: " + key);
        }
        this.mSeenGlobalKeys.add(key);
        ComponentLifecycle.RenderData existingInfo = (ComponentLifecycle.RenderData)this.mRenderData.get((Object)key);
        ComponentLifecycle.RenderData newInfo = ((ComponentLifecycle)lifecycle).recordRenderData(component, existingInfo);
        this.mRenderData.put((Object)key, (Object)newInfo);
    }

    private void applyPreviousRenderData(Component component) {
        Object lifecycle = component.getLifecycle();
        if (!((ComponentLifecycle)lifecycle).needsPreviousRenderData()) {
            throw new RuntimeException("Trying to apply previous render data to component that doesn't support it");
        }
        String key = component.getGlobalKey();
        ComponentLifecycle.RenderData previousRenderData = (ComponentLifecycle.RenderData)this.mRenderData.get((Object)key);
        ((ComponentLifecycle)lifecycle).applyPreviousRenderData(component, previousRenderData);
    }

    void reset() {
        this.mRenderData.clear();
        this.mSeenGlobalKeys.clear();
    }
}

