/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.util.SparseArray;
import android.view.ViewOutlineProvider;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.DispatchPopulateAccessibilityEventEvent;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FocusChangedEvent;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.LongClickEvent;
import com.facebook.litho.OnInitializeAccessibilityEventEvent;
import com.facebook.litho.OnInitializeAccessibilityNodeInfoEvent;
import com.facebook.litho.OnPopulateAccessibilityEventEvent;
import com.facebook.litho.OnRequestSendAccessibilityEventEvent;
import com.facebook.litho.PerformAccessibilityActionEvent;
import com.facebook.litho.SendAccessibilityEventEvent;
import com.facebook.litho.SendAccessibilityEventUncheckedEvent;
import com.facebook.litho.TouchEvent;
import java.util.concurrent.atomic.AtomicInteger;

@ThreadConfined(value="ANY")
class NodeInfo {
    static final short FOCUS_UNSET = 0;
    static final short FOCUS_SET_TRUE = 1;
    static final short FOCUS_SET_FALSE = 2;
    static final short ENABLED_UNSET = 0;
    static final short ENABLED_SET_TRUE = 1;
    static final short ENABLED_SET_FALSE = 2;
    private static final int PFLAG_CONTENT_DESCRIPTION_IS_SET = 1;
    private static final int PFLAG_VIEW_TAG_IS_SET = 2;
    private static final int PFLAG_VIEW_TAGS_IS_SET = 4;
    private static final int PFLAG_CLICK_HANDLER_IS_SET = 8;
    private static final int PFLAG_LONG_CLICK_HANDLER_IS_SET = 16;
    private static final int PFLAG_TOUCH_HANDLER_IS_SET = 32;
    private static final int PFLAG_DISPATCH_POPULATE_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 64;
    private static final int PFLAG_ON_INITIALIZE_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 128;
    private static final int PFLAG_ON_INITIALIZE_ACCESSIBILITY_NODE_INFO_HANDLER_IS_SET = 256;
    private static final int PFLAG_ON_POPULATE_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 512;
    private static final int PFLAG_ON_REQUEST_SEND_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 1024;
    private static final int PFLAG_PERFORM_ACCESSIBILITY_ACTION_HANDLER_IS_SET = 2048;
    private static final int PFLAG_SEND_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 4096;
    private static final int PFLAG_SEND_ACCESSIBILITY_EVENT_UNCHECKED_HANDLER_IS_SET = 8192;
    private static final int PFLAG_SHADOW_ELEVATION_IS_SET = 16384;
    private static final int PFLAG_OUTINE_PROVIDER_IS_SET = 32768;
    private static final int PFLAG_CLIP_TO_OUTLINE_IS_SET = 65536;
    private static final int PFLAG_FOCUS_CHANGE_HANDLER_IS_SET = 131072;
    private static final int PFLAG_INTERCEPT_TOUCH_HANDLER_IS_SET = 262144;
    private static final int PFLAG_SCALE_IS_SET = 524288;
    private static final int PFLAG_ALPHA_IS_SET = 0x100000;
    private final AtomicInteger mReferenceCount = new AtomicInteger(0);
    private CharSequence mContentDescription;
    private Object mViewTag;
    private SparseArray<Object> mViewTags;
    private float mShadowElevation;
    private ViewOutlineProvider mOutlineProvider;
    private boolean mClipToOutline;
    private float mScale = 1.0f;
    private float mAlpha = 1.0f;
    private EventHandler<ClickEvent> mClickHandler;
    private EventHandler<FocusChangedEvent> mFocusChangeHandler;
    private EventHandler<LongClickEvent> mLongClickHandler;
    private EventHandler<TouchEvent> mTouchHandler;
    private EventHandler<InterceptTouchEvent> mInterceptTouchHandler;
    private EventHandler<DispatchPopulateAccessibilityEventEvent> mDispatchPopulateAccessibilityEventHandler;
    private EventHandler<OnInitializeAccessibilityEventEvent> mOnInitializeAccessibilityEventHandler;
    private EventHandler<OnPopulateAccessibilityEventEvent> mOnPopulateAccessibilityEventHandler;
    private EventHandler<OnInitializeAccessibilityNodeInfoEvent> mOnInitializeAccessibilityNodeInfoHandler;
    private EventHandler<OnRequestSendAccessibilityEventEvent> mOnRequestSendAccessibilityEventHandler;
    private EventHandler<PerformAccessibilityActionEvent> mPerformAccessibilityActionHandler;
    private EventHandler<SendAccessibilityEventEvent> mSendAccessibilityEventHandler;
    private EventHandler<SendAccessibilityEventUncheckedEvent> mSendAccessibilityEventUncheckedHandler;
    private short mFocusState = 0;
    private short mEnabledState = 0;
    private int mPrivateFlags;

    NodeInfo() {
    }

    void setContentDescription(CharSequence contentDescription) {
        this.mPrivateFlags |= 1;
        this.mContentDescription = contentDescription;
    }

    CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    void setViewTag(Object viewTag) {
        this.mPrivateFlags |= 2;
        this.mViewTag = viewTag;
    }

    Object getViewTag() {
        return this.mViewTag;
    }

    void setViewTags(SparseArray<Object> viewTags) {
        this.mPrivateFlags |= 4;
        this.mViewTags = viewTags;
    }

    float getShadowElevation() {
        return this.mShadowElevation;
    }

    public void setShadowElevation(float shadowElevation) {
        this.mPrivateFlags |= 0x4000;
        this.mShadowElevation = shadowElevation;
    }

    ViewOutlineProvider getOutlineProvider() {
        return this.mOutlineProvider;
    }

    public void setOutlineProvider(ViewOutlineProvider outlineProvider) {
        this.mPrivateFlags |= 0x8000;
        this.mOutlineProvider = outlineProvider;
    }

    public boolean getClipToOutline() {
        return this.mClipToOutline;
    }

    public void setClipToOutline(boolean clipToOutline) {
        this.mPrivateFlags |= 0x10000;
        this.mClipToOutline = clipToOutline;
    }

    SparseArray<Object> getViewTags() {
        return this.mViewTags;
    }

    void setClickHandler(EventHandler<ClickEvent> clickHandler) {
        this.mPrivateFlags |= 8;
        this.mClickHandler = clickHandler;
    }

    EventHandler<ClickEvent> getClickHandler() {
        return this.mClickHandler;
    }

    void setLongClickHandler(EventHandler<LongClickEvent> longClickHandler) {
        this.mPrivateFlags |= 0x10;
        this.mLongClickHandler = longClickHandler;
    }

    EventHandler<LongClickEvent> getLongClickHandler() {
        return this.mLongClickHandler;
    }

    void setFocusChangeHandler(EventHandler<FocusChangedEvent> focusChangedHandler) {
        this.mPrivateFlags |= 0x20000;
        this.mFocusChangeHandler = focusChangedHandler;
    }

    EventHandler<FocusChangedEvent> getFocusChangeHandler() {
        return this.mFocusChangeHandler;
    }

    boolean hasFocusChangeHandler() {
        return this.mFocusChangeHandler != null;
    }

    void setTouchHandler(EventHandler<TouchEvent> touchHandler) {
        this.mPrivateFlags |= 0x20;
        this.mTouchHandler = touchHandler;
    }

    EventHandler<TouchEvent> getTouchHandler() {
        return this.mTouchHandler;
    }

    void setInterceptTouchHandler(EventHandler<InterceptTouchEvent> interceptTouchHandler) {
        this.mPrivateFlags |= 0x40000;
        this.mInterceptTouchHandler = interceptTouchHandler;
    }

    EventHandler<InterceptTouchEvent> getInterceptTouchHandler() {
        return this.mInterceptTouchHandler;
    }

    boolean hasTouchEventHandlers() {
        return this.mClickHandler != null || this.mLongClickHandler != null || this.mTouchHandler != null || this.mInterceptTouchHandler != null;
    }

    void setDispatchPopulateAccessibilityEventHandler(EventHandler<DispatchPopulateAccessibilityEventEvent> dispatchPopulateAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x40;
        this.mDispatchPopulateAccessibilityEventHandler = dispatchPopulateAccessibilityEventHandler;
    }

    EventHandler<DispatchPopulateAccessibilityEventEvent> getDispatchPopulateAccessibilityEventHandler() {
        return this.mDispatchPopulateAccessibilityEventHandler;
    }

    void setOnInitializeAccessibilityEventHandler(EventHandler<OnInitializeAccessibilityEventEvent> onInitializeAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x80;
        this.mOnInitializeAccessibilityEventHandler = onInitializeAccessibilityEventHandler;
    }

    EventHandler<OnInitializeAccessibilityEventEvent> getOnInitializeAccessibilityEventHandler() {
        return this.mOnInitializeAccessibilityEventHandler;
    }

    void setOnInitializeAccessibilityNodeInfoHandler(EventHandler<OnInitializeAccessibilityNodeInfoEvent> onInitializeAccessibilityNodeInfoHandler) {
        this.mPrivateFlags |= 0x100;
        this.mOnInitializeAccessibilityNodeInfoHandler = onInitializeAccessibilityNodeInfoHandler;
    }

    EventHandler<OnInitializeAccessibilityNodeInfoEvent> getOnInitializeAccessibilityNodeInfoHandler() {
        return this.mOnInitializeAccessibilityNodeInfoHandler;
    }

    void setOnPopulateAccessibilityEventHandler(EventHandler<OnPopulateAccessibilityEventEvent> onPopulateAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x200;
        this.mOnPopulateAccessibilityEventHandler = onPopulateAccessibilityEventHandler;
    }

    EventHandler<OnPopulateAccessibilityEventEvent> getOnPopulateAccessibilityEventHandler() {
        return this.mOnPopulateAccessibilityEventHandler;
    }

    void setOnRequestSendAccessibilityEventHandler(EventHandler<OnRequestSendAccessibilityEventEvent> onRequestSendAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x400;
        this.mOnRequestSendAccessibilityEventHandler = onRequestSendAccessibilityEventHandler;
    }

    EventHandler<OnRequestSendAccessibilityEventEvent> getOnRequestSendAccessibilityEventHandler() {
        return this.mOnRequestSendAccessibilityEventHandler;
    }

    void setPerformAccessibilityActionHandler(EventHandler<PerformAccessibilityActionEvent> performAccessibilityActionHandler) {
        this.mPrivateFlags |= 0x800;
        this.mPerformAccessibilityActionHandler = performAccessibilityActionHandler;
    }

    EventHandler<PerformAccessibilityActionEvent> getPerformAccessibilityActionHandler() {
        return this.mPerformAccessibilityActionHandler;
    }

    void setSendAccessibilityEventHandler(EventHandler<SendAccessibilityEventEvent> sendAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x1000;
        this.mSendAccessibilityEventHandler = sendAccessibilityEventHandler;
    }

    EventHandler<SendAccessibilityEventEvent> getSendAccessibilityEventHandler() {
        return this.mSendAccessibilityEventHandler;
    }

    void setSendAccessibilityEventUncheckedHandler(EventHandler<SendAccessibilityEventUncheckedEvent> sendAccessibilityEventUncheckedHandler) {
        this.mPrivateFlags |= 0x2000;
        this.mSendAccessibilityEventUncheckedHandler = sendAccessibilityEventUncheckedHandler;
    }

    EventHandler<SendAccessibilityEventUncheckedEvent> getSendAccessibilityEventUncheckedHandler() {
        return this.mSendAccessibilityEventUncheckedHandler;
    }

    boolean hasAccessibilityHandlers() {
        return this.mOnInitializeAccessibilityEventHandler != null || this.mOnInitializeAccessibilityNodeInfoHandler != null || this.mOnPopulateAccessibilityEventHandler != null || this.mOnRequestSendAccessibilityEventHandler != null || this.mPerformAccessibilityActionHandler != null || this.mDispatchPopulateAccessibilityEventHandler != null || this.mSendAccessibilityEventHandler != null || this.mSendAccessibilityEventUncheckedHandler != null;
    }

    void setFocusable(boolean isFocusable) {
        this.mFocusState = isFocusable ? (short)1 : (short)2;
    }

    short getFocusState() {
        return this.mFocusState;
    }

    void setEnabled(boolean isEnabled) {
        this.mEnabledState = isEnabled ? (short)1 : (short)2;
    }

    short getEnabledState() {
        return this.mEnabledState;
    }

    float getScale() {
        return this.mScale;
    }

    void setScale(float scale) {
        this.mScale = scale;
        this.mPrivateFlags |= 0x80000;
    }

    boolean isScaleSet() {
        return (this.mPrivateFlags & 0x80000) != 0;
    }

    float getAlpha() {
        return this.mAlpha;
    }

    void setAlpha(float alpha) {
        this.mAlpha = alpha;
        this.mPrivateFlags |= 0x100000;
    }

    boolean isAlphaSet() {
        return (this.mPrivateFlags & 0x100000) != 0;
    }

    void updateWith(NodeInfo newInfo) {
        if ((newInfo.mPrivateFlags & 8) != 0) {
            this.mClickHandler = newInfo.mClickHandler;
        }
        if ((newInfo.mPrivateFlags & 0x10) != 0) {
            this.mLongClickHandler = newInfo.mLongClickHandler;
        }
        if ((newInfo.mPrivateFlags & 0x20000) != 0) {
            this.mFocusChangeHandler = newInfo.mFocusChangeHandler;
        }
        if ((newInfo.mPrivateFlags & 0x20) != 0) {
            this.mTouchHandler = newInfo.mTouchHandler;
        }
        if ((newInfo.mPrivateFlags & 0x40000) != 0) {
            this.mInterceptTouchHandler = newInfo.mInterceptTouchHandler;
        }
        if ((newInfo.mPrivateFlags & 0x40) != 0) {
            this.mDispatchPopulateAccessibilityEventHandler = newInfo.mDispatchPopulateAccessibilityEventHandler;
        }
        if ((newInfo.mPrivateFlags & 0x80) != 0) {
            this.mOnInitializeAccessibilityEventHandler = newInfo.mOnInitializeAccessibilityEventHandler;
        }
        if ((newInfo.mPrivateFlags & 0x100) != 0) {
            this.mOnInitializeAccessibilityNodeInfoHandler = newInfo.mOnInitializeAccessibilityNodeInfoHandler;
        }
        if ((newInfo.mPrivateFlags & 0x200) != 0) {
            this.mOnPopulateAccessibilityEventHandler = newInfo.mOnPopulateAccessibilityEventHandler;
        }
        if ((newInfo.mPrivateFlags & 0x400) != 0) {
            this.mOnRequestSendAccessibilityEventHandler = newInfo.mOnRequestSendAccessibilityEventHandler;
        }
        if ((newInfo.mPrivateFlags & 0x800) != 0) {
            this.mPerformAccessibilityActionHandler = newInfo.mPerformAccessibilityActionHandler;
        }
        if ((newInfo.mPrivateFlags & 0x1000) != 0) {
            this.mSendAccessibilityEventHandler = newInfo.mSendAccessibilityEventHandler;
        }
        if ((newInfo.mPrivateFlags & 0x2000) != 0) {
            this.mSendAccessibilityEventUncheckedHandler = newInfo.mSendAccessibilityEventUncheckedHandler;
        }
        if ((newInfo.mPrivateFlags & 1) != 0) {
            this.mContentDescription = newInfo.mContentDescription;
        }
        if ((newInfo.mPrivateFlags & 0x4000) != 0) {
            this.mShadowElevation = newInfo.mShadowElevation;
        }
        if ((newInfo.mPrivateFlags & 0x8000) != 0) {
            this.mOutlineProvider = newInfo.mOutlineProvider;
        }
        if ((newInfo.mPrivateFlags & 0x10000) != 0) {
            this.mClipToOutline = newInfo.mClipToOutline;
        }
        if (newInfo.mViewTag != null) {
            this.mViewTag = newInfo.mViewTag;
        }
        if (newInfo.mViewTags != null) {
            this.mViewTags = newInfo.mViewTags;
        }
        if (newInfo.getFocusState() != 0) {
            this.mFocusState = newInfo.getFocusState();
        }
        if (newInfo.getEnabledState() != 0) {
            this.mEnabledState = newInfo.getEnabledState();
        }
        if ((newInfo.mPrivateFlags & 0x80000) != 0) {
            this.mScale = newInfo.mScale;
        }
        if ((newInfo.mPrivateFlags & 0x100000) != 0) {
            this.mAlpha = newInfo.mAlpha;
        }
    }

    void copyInto(ComponentLayout.Builder layout) {
        if ((this.mPrivateFlags & 8) != 0) {
            layout.clickHandler(this.mClickHandler);
        }
        if ((this.mPrivateFlags & 0x10) != 0) {
            layout.longClickHandler(this.mLongClickHandler);
        }
        if ((this.mPrivateFlags & 0x20000) != 0) {
            layout.focusChangeHandler(this.mFocusChangeHandler);
        }
        if ((this.mPrivateFlags & 0x20) != 0) {
            layout.touchHandler(this.mTouchHandler);
        }
        if ((this.mPrivateFlags & 0x40000) != 0) {
            layout.interceptTouchHandler(this.mInterceptTouchHandler);
        }
        if ((this.mPrivateFlags & 0x40) != 0) {
            layout.dispatchPopulateAccessibilityEventHandler(this.mDispatchPopulateAccessibilityEventHandler);
        }
        if ((this.mPrivateFlags & 0x80) != 0) {
            layout.onInitializeAccessibilityEventHandler(this.mOnInitializeAccessibilityEventHandler);
        }
        if ((this.mPrivateFlags & 0x100) != 0) {
            layout.onInitializeAccessibilityNodeInfoHandler(this.mOnInitializeAccessibilityNodeInfoHandler);
        }
        if ((this.mPrivateFlags & 0x200) != 0) {
            layout.onPopulateAccessibilityEventHandler(this.mOnPopulateAccessibilityEventHandler);
        }
        if ((this.mPrivateFlags & 0x400) != 0) {
            layout.onRequestSendAccessibilityEventHandler(this.mOnRequestSendAccessibilityEventHandler);
        }
        if ((this.mPrivateFlags & 0x800) != 0) {
            layout.performAccessibilityActionHandler(this.mPerformAccessibilityActionHandler);
        }
        if ((this.mPrivateFlags & 0x1000) != 0) {
            layout.sendAccessibilityEventHandler(this.mSendAccessibilityEventHandler);
        }
        if ((this.mPrivateFlags & 0x2000) != 0) {
            layout.sendAccessibilityEventUncheckedHandler(this.mSendAccessibilityEventUncheckedHandler);
        }
        if ((this.mPrivateFlags & 1) != 0) {
            layout.contentDescription(this.mContentDescription);
        }
        if ((this.mPrivateFlags & 0x4000) != 0) {
            layout.shadowElevationPx(this.mShadowElevation);
        }
        if ((this.mPrivateFlags & 0x8000) != 0) {
            layout.outlineProvider(this.mOutlineProvider);
        }
        if ((this.mPrivateFlags & 0x10000) != 0) {
            layout.clipToOutline(this.mClipToOutline);
        }
        if (this.mViewTag != null) {
            layout.viewTag(this.mViewTag);
        }
        if (this.mViewTags != null) {
            layout.viewTags(this.mViewTags);
        }
        if (this.getFocusState() != 0) {
            layout.focusable(this.getFocusState() == 1);
        }
        if (this.getEnabledState() != 0) {
            layout.enabled(this.getEnabledState() == 1);
        }
        if ((this.mPrivateFlags & 0x80000) != 0) {
            layout.scale(this.mScale);
        }
        if ((this.mPrivateFlags & 0x100000) != 0) {
            layout.alpha(this.mAlpha);
        }
    }

    static NodeInfo acquire() {
        NodeInfo nodeInfo = ComponentsPools.acquireNodeInfo();
        if (nodeInfo.mReferenceCount.getAndSet(1) != 0) {
            throw new IllegalStateException("The NodeInfo reference acquired from the pool  wasn't correctly released.");
        }
        return nodeInfo;
    }

    NodeInfo acquireRef() {
        if (this.mReferenceCount.getAndIncrement() < 1) {
            throw new IllegalStateException("The NodeInfo being acquired wasn't correctly initialized.");
        }
        return this;
    }

    void release() {
        int count = this.mReferenceCount.decrementAndGet();
        if (count < 0) {
            throw new IllegalStateException("Trying to release a recycled NodeInfo.");
        }
        if (count > 0) {
            return;
        }
        this.mContentDescription = null;
        this.mViewTag = null;
        this.mViewTags = null;
        this.mClickHandler = null;
        this.mLongClickHandler = null;
        this.mFocusChangeHandler = null;
        this.mTouchHandler = null;
        this.mInterceptTouchHandler = null;
        this.mDispatchPopulateAccessibilityEventHandler = null;
        this.mOnInitializeAccessibilityEventHandler = null;
        this.mOnPopulateAccessibilityEventHandler = null;
        this.mOnInitializeAccessibilityNodeInfoHandler = null;
        this.mOnRequestSendAccessibilityEventHandler = null;
        this.mPerformAccessibilityActionHandler = null;
        this.mSendAccessibilityEventHandler = null;
        this.mSendAccessibilityEventUncheckedHandler = null;
        this.mFocusState = 0;
        this.mEnabledState = 0;
        this.mPrivateFlags = 0;
        this.mShadowElevation = 0.0f;
        this.mOutlineProvider = null;
        this.mClipToOutline = false;
        this.mScale = 1.0f;
        this.mAlpha = 1.0f;
        ComponentsPools.release(this);
    }
}

