/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.LongSparseArray;
import android.support.v4.util.SimpleArrayMap;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.BoundsHelper;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentClickListener;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentFocusChangeListener;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentHostUtils;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentLongClickListener;
import com.facebook.litho.ComponentTouchListener;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.DrawableComponent;
import com.facebook.litho.EventDispatcherUtils;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FocusChangedEvent;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.HasLithoViewChildren;
import com.facebook.litho.HostComponent;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoView;
import com.facebook.litho.LogEvent;
import com.facebook.litho.LongClickEvent;
import com.facebook.litho.MountItem;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.R;
import com.facebook.litho.TestItem;
import com.facebook.litho.TestOutput;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.TouchEvent;
import com.facebook.litho.Transition;
import com.facebook.litho.TransitionManager;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.litho.VisibilityItem;
import com.facebook.litho.VisibilityOutput;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.reference.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@ThreadConfined(value="UI")
class MountState
implements TransitionManager.OnAnimationCompleteListener {
    static final int ROOT_HOST_ID = 0;
    private final LongSparseArray<MountItem> mIndexToItemMap;
    private final LongSparseArray<VisibilityItem> mVisibilityIdToItemMap;
    private final LongSparseArray<MountItem> mCanMountIncrementallyMountItems;
    private final Map<String, Deque<TestItem>> mTestItemMap;
    @Nullable
    private long[] mLayoutOutputsIds;
    private boolean mIsDirty;
    private final LongSparseArray<ComponentHost> mHostsByMarker = new LongSparseArray();
    private static final Rect sTempRect = new Rect();
    private final ComponentContext mContext;
    private final LithoView mLithoView;
    private final Rect mPreviousLocalVisibleRect = new Rect();
    private final PrepareMountStats mPrepareMountStats = new PrepareMountStats();
    private final MountStats mMountStats = new MountStats();
    private TransitionManager mTransitionManager;
    private int mPreviousTopsIndex;
    private int mPreviousBottomsIndex;
    private int mLastMountedComponentTreeId = -1;
    private final HashMap<String, MountItem> mDisappearingMountItems = new HashMap();
    private final HashSet<String> mAnimatingTransitionKeys = new HashSet();
    private LayoutState mLastMountedLayoutState;
    private int[] mAnimationLockedIndices;
    private boolean mIsFirstMountOfComponentTree = false;
    @Nullable
    private ArrayList<Transition> mMountTimeTransitions;
    private final MountItem mRootHostMountItem;

    public MountState(LithoView view) {
        this.mIndexToItemMap = new LongSparseArray();
        this.mVisibilityIdToItemMap = new LongSparseArray();
        this.mCanMountIncrementallyMountItems = new LongSparseArray();
        this.mContext = (ComponentContext)view.getContext();
        this.mLithoView = view;
        this.mIsDirty = true;
        this.mTestItemMap = ComponentsConfiguration.isEndToEndTestRun ? new HashMap() : null;
        this.mRootHostMountItem = ComponentsPools.acquireRootHostMountItem(HostComponent.create(), this.mLithoView, (Object)this.mLithoView);
    }

    void setDirty() {
        ThreadUtils.assertMainThread();
        this.mIsDirty = true;
        this.mPreviousLocalVisibleRect.setEmpty();
    }

    boolean isDirty() {
        ThreadUtils.assertMainThread();
        return this.mIsDirty;
    }

    void setIsFirstMountOfComponentTree() {
        ThreadUtils.assertMainThread();
        this.mIsFirstMountOfComponentTree = true;
    }

    void mount(LayoutState layoutState, Rect localVisibleRect, boolean processVisibilityOutputs) {
        ThreadUtils.assertMainThread();
        if (layoutState == null) {
            throw new IllegalStateException("Trying to mount a null layoutState");
        }
        ComponentsSystrace.beginSection("mount");
        ComponentTree componentTree = this.mLithoView.getComponentTree();
        ComponentsLogger logger = componentTree.getContext().getLogger();
        int componentTreeId = layoutState.getComponentTreeId();
        if (componentTreeId != this.mLastMountedComponentTreeId) {
            this.releaseLastMountedLayoutState();
        }
        LogEvent mountEvent = null;
        if (logger != null) {
            mountEvent = logger.newPerformanceEvent(6);
        }
        if (this.mIsDirty) {
            this.updateTransitions(layoutState);
            this.suppressInvalidationsOnHosts(true);
            this.prepareMount(layoutState);
        }
        this.mMountStats.reset();
        boolean isIncrementalMountEnabled = localVisibleRect != null;
        boolean isTracing = ComponentsSystrace.isTracing();
        if (!isIncrementalMountEnabled || !this.performIncrementalMount(layoutState, localVisibleRect, processVisibilityOutputs)) {
            MountItem rootMountItem = (MountItem)this.mIndexToItemMap.get(0L);
            int size = layoutState.getMountableOutputCount();
            for (int i = 0; i < size; ++i) {
                boolean isMountable;
                MountItem currentMountItem;
                LayoutOutput layoutOutput = layoutState.getMountableOutputAt(i);
                Component<?> component = layoutOutput.getComponent();
                if (isTracing) {
                    ComponentsSystrace.beginSection(component.getSimpleName());
                }
                boolean isMounted = (currentMountItem = this.getItemAt(i)) != null;
                boolean bl = isMountable = !isIncrementalMountEnabled || this.isMountedHostWithChildContent(currentMountItem) || Rect.intersects((Rect)localVisibleRect, (Rect)layoutOutput.getBounds()) || this.isAnimationLocked(i) || currentMountItem != null && currentMountItem == rootMountItem;
                if (isMountable && !isMounted) {
                    this.mountLayoutOutput(i, layoutOutput, layoutState);
                } else if (!isMountable && isMounted) {
                    this.unmountItem(this.mContext, i, this.mHostsByMarker);
                } else if (isMounted) {
                    if (this.mIsDirty) {
                        boolean useUpdateValueFromLayoutOutput = componentTreeId >= 0 && componentTreeId == this.mLastMountedComponentTreeId;
                        boolean itemUpdated = this.updateMountItemIfNeeded(layoutOutput, currentMountItem, useUpdateValueFromLayoutOutput, logger, componentTreeId, i);
                        if (itemUpdated) {
                            this.mMountStats.updatedCount++;
                        } else {
                            this.mMountStats.noOpCount++;
                        }
                    }
                    if (isIncrementalMountEnabled && MountState.canMountIncrementally(component)) {
                        MountState.mountItemIncrementally(currentMountItem, layoutOutput.getBounds(), localVisibleRect, processVisibilityOutputs);
                    }
                }
                if (!isTracing) continue;
                ComponentsSystrace.endSection();
            }
            if (isIncrementalMountEnabled) {
                this.setupPreviousMountableOutputData(layoutState, localVisibleRect);
            }
        }
        if (this.shouldAnimateTransitions(layoutState) && this.hasTransitionsToAnimate(layoutState)) {
            this.mTransitionManager.runTransitions();
        }
        this.mMountTimeTransitions = null;
        this.mIsDirty = false;
        this.mIsFirstMountOfComponentTree = false;
        if (localVisibleRect != null) {
            this.mPreviousLocalVisibleRect.set(localVisibleRect);
        }
        this.releaseLastMountedLayoutState();
        this.mLastMountedComponentTreeId = componentTreeId;
        this.mLastMountedLayoutState = layoutState.acquireRef();
        if (processVisibilityOutputs) {
            this.processVisibilityOutputs(layoutState, localVisibleRect);
        }
        this.processTestOutputs(layoutState);
        this.suppressInvalidationsOnHosts(false);
        if (logger != null) {
            mountEvent.addParam("log_tag", componentTree.getContext().getLogTag());
            mountEvent.addParam("mounted_count", String.valueOf(this.mMountStats.mountedCount));
            mountEvent.addParam("unmounted_count", String.valueOf(this.mMountStats.unmountedCount));
            mountEvent.addParam("updated_count", String.valueOf(this.mMountStats.updatedCount));
            mountEvent.addParam("no_op_count", String.valueOf(this.mMountStats.noOpCount));
            mountEvent.addParam("is_dirty", String.valueOf(this.mIsDirty));
            logger.log(mountEvent);
        }
        ComponentsSystrace.endSection();
    }

    private void processVisibilityOutputs(LayoutState layoutState, Rect localVisibleRect) {
        if (localVisibleRect == null) {
            return;
        }
        int size = layoutState.getVisibilityOutputCount();
        for (int j = 0; j < size; ++j) {
            VisibilityOutput visibilityOutput = layoutState.getVisibilityOutputAt(j);
            EventHandler<VisibleEvent> visibleHandler = visibilityOutput.getVisibleEventHandler();
            EventHandler<FocusedVisibleEvent> focusedHandler = visibilityOutput.getFocusedEventHandler();
            EventHandler<UnfocusedVisibleEvent> unfocusedHandler = visibilityOutput.getUnfocusedEventHandler();
            EventHandler<FullImpressionVisibleEvent> fullImpressionHandler = visibilityOutput.getFullImpressionEventHandler();
            EventHandler<InvisibleEvent> invisibleHandler = visibilityOutput.getInvisibleEventHandler();
            long visibilityOutputId = visibilityOutput.getId();
            Rect visibilityOutputBounds = visibilityOutput.getBounds();
            sTempRect.set(visibilityOutputBounds);
            boolean isCurrentlyVisible = sTempRect.intersect(localVisibleRect) && this.isInVisibleRange(visibilityOutput, visibilityOutputBounds, localVisibleRect);
            VisibilityItem visibilityItem = (VisibilityItem)this.mVisibilityIdToItemMap.get(visibilityOutputId);
            if (visibilityItem != null) {
                boolean hasGlobalKeyChanged;
                String previousGlobalKey = visibilityItem.getGlobalKey();
                String currentGlobalKey = visibilityOutput.getComponent() != null ? visibilityOutput.getComponent().getGlobalKey() : null;
                boolean bl = hasGlobalKeyChanged = previousGlobalKey != null && !previousGlobalKey.equals(currentGlobalKey);
                if (!hasGlobalKeyChanged) {
                    visibilityItem.setUnfocusedHandler(unfocusedHandler);
                    visibilityItem.setInvisibleHandler(invisibleHandler);
                }
                if (!isCurrentlyVisible || hasGlobalKeyChanged) {
                    if (visibilityItem.getInvisibleHandler() != null) {
                        EventDispatcherUtils.dispatchOnInvisible(visibilityItem.getInvisibleHandler());
                    }
                    if (visibilityItem.isInFocusedRange()) {
                        visibilityItem.setFocusedRange(false);
                        if (visibilityItem.getUnfocusedHandler() != null) {
                            EventDispatcherUtils.dispatchOnUnfocused(visibilityItem.getUnfocusedHandler());
                        }
                    }
                    this.mVisibilityIdToItemMap.remove(visibilityOutputId);
                    ComponentsPools.release(visibilityItem);
                    visibilityItem = null;
                }
            }
            if (!isCurrentlyVisible) continue;
            if (visibilityItem == null) {
                String globalKey = visibilityOutput.getComponent() != null ? visibilityOutput.getComponent().getGlobalKey() : null;
                visibilityItem = ComponentsPools.acquireVisibilityItem(globalKey, invisibleHandler, unfocusedHandler);
                this.mVisibilityIdToItemMap.put(visibilityOutputId, (Object)visibilityItem);
                if (visibleHandler != null) {
                    EventDispatcherUtils.dispatchOnVisible(visibleHandler);
                }
            }
            if (focusedHandler != null || unfocusedHandler != null) {
                if (this.isInFocusedRange(visibilityOutputBounds, sTempRect)) {
                    if (!visibilityItem.isInFocusedRange()) {
                        visibilityItem.setFocusedRange(true);
                        if (focusedHandler != null) {
                            EventDispatcherUtils.dispatchOnFocused(focusedHandler);
                        }
                    }
                } else if (visibilityItem.isInFocusedRange()) {
                    visibilityItem.setFocusedRange(false);
                    if (unfocusedHandler != null) {
                        EventDispatcherUtils.dispatchOnUnfocused(unfocusedHandler);
                    }
                }
            }
            if (fullImpressionHandler == null || visibilityItem.isInFullImpressionRange()) continue;
            visibilityItem.setVisibleEdges(visibilityOutputBounds, sTempRect);
            if (!visibilityItem.isInFullImpressionRange()) continue;
            EventDispatcherUtils.dispatchOnFullImpression(fullImpressionHandler);
        }
    }

    private void processTestOutputs(LayoutState layoutState) {
        if (this.mTestItemMap == null) {
            return;
        }
        for (Collection collection : this.mTestItemMap.values()) {
            for (TestItem item : collection) {
                ComponentsPools.release(item);
            }
        }
        this.mTestItemMap.clear();
        int n = layoutState.getTestOutputCount();
        for (int i = 0; i < n; ++i) {
            TestOutput testOutput = layoutState.getTestOutputAt(i);
            long hostMarker = testOutput.getHostMarker();
            long layoutOutputId = testOutput.getLayoutOutputId();
            MountItem mountItem = layoutOutputId == -1L ? null : (MountItem)this.mIndexToItemMap.get(layoutOutputId);
            TestItem testItem = ComponentsPools.acquireTestItem();
            testItem.setHost(hostMarker == -1L ? null : (ComponentHost)((Object)this.mHostsByMarker.get(hostMarker)));
            testItem.setBounds(testOutput.getBounds());
            testItem.setTestKey(testOutput.getTestKey());
            testItem.setContent(mountItem == null ? null : mountItem.getContent());
            LinkedList<TestItem> items = this.mTestItemMap.get(testOutput.getTestKey());
            LinkedList<TestItem> updatedItems = items == null ? new LinkedList<TestItem>() : items;
            updatedItems.add(testItem);
            this.mTestItemMap.put(testOutput.getTestKey(), updatedItems);
        }
    }

    private boolean isMountedHostWithChildContent(MountItem mountItem) {
        if (mountItem == null) {
            return false;
        }
        Object content = mountItem.getContent();
        if (!(content instanceof ComponentHost)) {
            return false;
        }
        ComponentHost host = (ComponentHost)((Object)content);
        return host.getMountItemCount() > 0;
    }

    private void setupPreviousMountableOutputData(LayoutState layoutState, Rect localVisibleRect) {
        int i;
        if (localVisibleRect.isEmpty()) {
            return;
        }
        ArrayList<LayoutOutput> layoutOutputTops = layoutState.getMountableOutputTops();
        ArrayList<LayoutOutput> layoutOutputBottoms = layoutState.getMountableOutputBottoms();
        int mountableOutputCount = layoutState.getMountableOutputCount();
        this.mPreviousTopsIndex = layoutState.getMountableOutputCount();
        for (i = 0; i < mountableOutputCount; ++i) {
            if (localVisibleRect.bottom > layoutOutputTops.get((int)i).getBounds().top) continue;
            this.mPreviousTopsIndex = i;
            break;
        }
        this.mPreviousBottomsIndex = layoutState.getMountableOutputCount();
        for (i = 0; i < mountableOutputCount; ++i) {
            if (localVisibleRect.top >= layoutOutputBottoms.get((int)i).getBounds().bottom) continue;
            this.mPreviousBottomsIndex = i;
            break;
        }
    }

    private void clearVisibilityItems() {
        for (int i = this.mVisibilityIdToItemMap.size() - 1; i >= 0; --i) {
            VisibilityItem visibilityItem = (VisibilityItem)this.mVisibilityIdToItemMap.valueAt(i);
            EventHandler<InvisibleEvent> invisibleHandler = visibilityItem.getInvisibleHandler();
            EventHandler<UnfocusedVisibleEvent> unfocusedHandler = visibilityItem.getUnfocusedHandler();
            if (invisibleHandler != null) {
                EventDispatcherUtils.dispatchOnInvisible(invisibleHandler);
            }
            if (visibilityItem.isInFocusedRange()) {
                visibilityItem.setFocusedRange(false);
                if (unfocusedHandler != null) {
                    EventDispatcherUtils.dispatchOnUnfocused(unfocusedHandler);
                }
            }
            this.mVisibilityIdToItemMap.removeAt(i);
            ComponentsPools.release(visibilityItem);
        }
    }

    private void registerHost(long id2, ComponentHost host) {
        host.suppressInvalidations(true);
        this.mHostsByMarker.put(id2, (Object)host);
    }

    private boolean isInVisibleRange(VisibilityOutput visibilityOutput, Rect bounds, Rect visibleBounds) {
        float heightRatio = visibilityOutput.getVisibleHeightRatio();
        float widthRatio = visibilityOutput.getVisibleWidthRatio();
        if (heightRatio == 0.0f && widthRatio == 0.0f) {
            return true;
        }
        return MountState.isInRatioRange(heightRatio, bounds.height(), visibleBounds.height()) && MountState.isInRatioRange(widthRatio, bounds.width(), visibleBounds.width());
    }

    private static boolean isInRatioRange(float ratio, int length, int visiblelength) {
        return (float)visiblelength >= ratio * (float)length;
    }

    private boolean isInFocusedRange(Rect componentBounds, Rect componentVisibleBounds) {
        View parent = (View)this.mLithoView.getParent();
        if (parent == null) {
            return false;
        }
        int halfViewportArea = parent.getWidth() * parent.getHeight() / 2;
        int totalComponentArea = MountState.computeRectArea(componentBounds);
        int visibleComponentArea = MountState.computeRectArea(componentVisibleBounds);
        return totalComponentArea >= halfViewportArea ? visibleComponentArea >= halfViewportArea : componentBounds.equals((Object)componentVisibleBounds);
    }

    private static int computeRectArea(Rect rect) {
        return rect.isEmpty() ? 0 : rect.width() * rect.height();
    }

    private void suppressInvalidationsOnHosts(boolean suppressInvalidations) {
        for (int i = this.mHostsByMarker.size() - 1; i >= 0; --i) {
            ((ComponentHost)((Object)this.mHostsByMarker.valueAt(i))).suppressInvalidations(suppressInvalidations);
        }
    }

    private boolean updateMountItemIfNeeded(LayoutOutput layoutOutput, MountItem currentMountItem, boolean useUpdateValueFromLayoutOutput, ComponentsLogger logger, int componentTreeId, int index) {
        ComponentHost host;
        Component<?> layoutOutputComponent = layoutOutput.getComponent();
        Component<?> itemComponent = currentMountItem.getComponent();
        boolean shouldUpdate = MountState.shouldUpdateMountItem(layoutOutput, currentMountItem, useUpdateValueFromLayoutOutput, this.mIndexToItemMap, this.mLayoutOutputsIds, logger);
        if (shouldUpdate) {
            Component<?> component;
            this.maybeUpdateAnimatingMountContent(currentMountItem, null);
            if (this.mLastMountedComponentTreeId != componentTreeId && Component.isHostSpec(component = currentMountItem.getComponent())) {
                ComponentHost componentHost = (ComponentHost)((Object)currentMountItem.getContent());
                this.removeDisappearingMountContentFromComponentHost(componentHost);
            }
            MountState.unsetViewAttributes(currentMountItem);
            host = currentMountItem.getHost();
            host.maybeUnregisterTouchExpansion(index, currentMountItem);
        }
        if (currentMountItem.isBound()) {
            ((ComponentLifecycle)itemComponent.getLifecycle()).onUnbind(this.getContextForComponent(itemComponent), currentMountItem.getContent(), itemComponent);
            currentMountItem.setIsBound(false);
        }
        currentMountItem.init(layoutOutput.getComponent(), currentMountItem, layoutOutput);
        if (shouldUpdate) {
            host = currentMountItem.getHost();
            host.maybeRegisterTouchExpansion(index, currentMountItem);
            this.updateMountedContent(currentMountItem, layoutOutput, itemComponent);
            MountState.setViewAttributes(currentMountItem);
        }
        Object currentContent = currentMountItem.getContent();
        ((ComponentLifecycle)layoutOutputComponent.getLifecycle()).bind(this.getContextForComponent(layoutOutputComponent), currentContent, layoutOutputComponent);
        currentMountItem.setIsBound(true);
        this.updateBoundsForMountedLayoutOutput(layoutOutput, currentMountItem);
        if (shouldUpdate) {
            this.maybeUpdateAnimatingMountContent(currentMountItem, currentMountItem.getContent());
        }
        ComponentHostUtils.maybeInvalidateAccessibilityState(currentMountItem);
        if (currentMountItem.getContent() instanceof Drawable) {
            ComponentHostUtils.maybeSetDrawableState((View)currentMountItem.getHost(), (Drawable)currentMountItem.getContent(), currentMountItem.getFlags(), currentMountItem.getNodeInfo());
        }
        if (currentMountItem.getDisplayListDrawable() != null) {
            currentMountItem.getDisplayListDrawable().suppressInvalidations(false);
        }
        return shouldUpdate;
    }

    private static boolean shouldUpdateMountItem(LayoutOutput layoutOutput, MountItem currentMountItem, boolean useUpdateValueFromLayoutOutput, LongSparseArray<MountItem> indexToItemMap, long[] layoutOutputsIds, ComponentsLogger logger) {
        int updateState = layoutOutput.getUpdateState();
        Component<?> currentComponent = currentMountItem.getComponent();
        Object currentLifecycle = currentComponent.getLifecycle();
        Component<?> nextComponent = layoutOutput.getComponent();
        Object nextLifecycle = nextComponent.getLifecycle();
        if (!MountState.sameSize(layoutOutput, currentMountItem) && ((ComponentLifecycle)nextLifecycle).isMountSizeDependent()) {
            return true;
        }
        if (useUpdateValueFromLayoutOutput) {
            if (updateState == 1) {
                if (currentLifecycle instanceof DrawableComponent && nextLifecycle instanceof DrawableComponent && ((ComponentLifecycle)currentLifecycle).shouldComponentUpdate(currentComponent, nextComponent)) {
                    if (logger != null) {
                        int i;
                        LayoutOutputLog logObj = new LayoutOutputLog();
                        logObj.currentId = indexToItemMap.keyAt(indexToItemMap.indexOfValue((Object)currentMountItem));
                        logObj.currentLifecycle = currentLifecycle.toString();
                        logObj.nextId = layoutOutput.getId();
                        logObj.nextLifecycle = nextLifecycle.toString();
                        for (i = 0; i < layoutOutputsIds.length; ++i) {
                            if (layoutOutputsIds[i] != logObj.currentId) continue;
                            if (logObj.currentIndex == -1) {
                                logObj.currentIndex = i;
                            }
                            logObj.currentLastDuplicatedIdIndex = i;
                        }
                        if (logObj.nextId == logObj.currentId) {
                            logObj.nextIndex = logObj.currentIndex;
                            logObj.nextLastDuplicatedIdIndex = logObj.currentLastDuplicatedIdIndex;
                        } else {
                            for (i = 0; i < layoutOutputsIds.length; ++i) {
                                if (layoutOutputsIds[i] != logObj.nextId) continue;
                                if (logObj.nextIndex == -1) {
                                    logObj.nextIndex = i;
                                }
                                logObj.nextLastDuplicatedIdIndex = i;
                            }
                        }
                        LogEvent mismatchEvent = logger.newEvent(7);
                        mismatchEvent.addParam("message", logObj.toString());
                        logger.log(mismatchEvent);
                    }
                    return true;
                }
                return false;
            }
            if (updateState == 2) {
                return true;
            }
        }
        if (!((ComponentLifecycle)currentLifecycle).callsShouldUpdateOnMount()) {
            return true;
        }
        return ((ComponentLifecycle)currentLifecycle).shouldComponentUpdate(currentComponent, nextComponent);
    }

    private static boolean sameSize(LayoutOutput layoutOutput, MountItem item) {
        Rect layoutOutputBounds = layoutOutput.getBounds();
        Object mountedContent = item.getContent();
        return layoutOutputBounds.width() == MountState.getWidthForMountedContent(mountedContent) && layoutOutputBounds.height() == MountState.getHeightForMountedContent(mountedContent);
    }

    private static int getWidthForMountedContent(Object content) {
        return content instanceof Drawable ? ((Drawable)content).getBounds().width() : ((View)content).getWidth();
    }

    private static int getHeightForMountedContent(Object content) {
        return content instanceof Drawable ? ((Drawable)content).getBounds().height() : ((View)content).getHeight();
    }

    private void updateBoundsForMountedLayoutOutput(LayoutOutput layoutOutput, MountItem item) {
        if (layoutOutput.getId() == 0L) {
            return;
        }
        layoutOutput.getMountBounds(sTempRect);
        boolean forceTraversal = Component.isMountViewSpec(layoutOutput.getComponent()) && ((View)item.getContent()).isLayoutRequested();
        MountState.applyBoundsToMountContent(item.getContent(), MountState.sTempRect.left, MountState.sTempRect.top, MountState.sTempRect.right, MountState.sTempRect.bottom, forceTraversal);
    }

    private void prepareMount(LayoutState layoutState) {
        ComponentTree component = this.mLithoView.getComponentTree();
        ComponentsLogger logger = component.getContext().getLogger();
        String logTag = component.getContext().getLogTag();
        LogEvent prepareEvent = null;
        if (logger != null) {
            prepareEvent = logger.newPerformanceEvent(5);
        }
        PrepareMountStats stats = this.unmountOrMoveOldItems(layoutState);
        if (logger != null) {
            prepareEvent.addParam("log_tag", logTag);
            prepareEvent.addParam("unmounted_count", String.valueOf(stats.unmountedCount));
            prepareEvent.addParam("moved_count", String.valueOf(stats.movedCount));
            prepareEvent.addParam("unchanged_count", String.valueOf(stats.unchangedCount));
        }
        if (this.mHostsByMarker.get(0L) == null) {
            this.registerHost(0L, this.mLithoView);
            this.mIndexToItemMap.put(0L, (Object)this.mRootHostMountItem);
        }
        int outputCount = layoutState.getMountableOutputCount();
        if (this.mLayoutOutputsIds == null || outputCount != this.mLayoutOutputsIds.length) {
            this.mLayoutOutputsIds = new long[layoutState.getMountableOutputCount()];
        }
        for (int i = 0; i < outputCount; ++i) {
            this.mLayoutOutputsIds[i] = layoutState.getMountableOutputAt(i).getId();
        }
        if (logger != null) {
            logger.log(prepareEvent);
        }
    }

    private boolean isItemDisappearing(LayoutState layoutState, int index) {
        if (!this.shouldAnimateTransitions(layoutState) || !this.hasTransitionsToAnimate(layoutState)) {
            return false;
        }
        if (this.mTransitionManager == null || this.mLastMountedLayoutState == null) {
            return false;
        }
        LayoutOutput layoutOutput = this.mLastMountedLayoutState.getMountableOutputAt(index);
        String key = layoutOutput.getTransitionKey();
        if (key == null) {
            return false;
        }
        return this.mTransitionManager.isKeyDisappearing(key);
    }

    private PrepareMountStats unmountOrMoveOldItems(LayoutState newLayoutState) {
        this.mPrepareMountStats.reset();
        if (this.mLayoutOutputsIds == null) {
            return this.mPrepareMountStats;
        }
        for (int i = 0; i < this.mLayoutOutputsIds.length; ++i) {
            int newPosition = newLayoutState.getLayoutOutputPositionForId(this.mLayoutOutputsIds[i]);
            MountItem oldItem = this.getItemAt(i);
            if (this.isItemDisappearing(newLayoutState, i)) {
                int lastDescendantOfItem = this.findLastDescendantIndex(this.mLastMountedLayoutState, i);
                for (int j = i; j <= lastDescendantOfItem; ++j) {
                    String key;
                    MountItem item = this.getItemAt(j);
                    if (item == null) {
                        LayoutOutput layoutOutput = this.mLastMountedLayoutState.getMountableOutputAt(j);
                        this.mountLayoutOutput(j, layoutOutput, this.mLastMountedLayoutState);
                        item = this.getItemAt(j);
                    }
                    if ((key = MountState.getTransitionKey(item)) == null || !this.mTransitionManager.isKeyDisappearing(key)) continue;
                    this.startUnmountDisappearingItem(j, key);
                }
                this.removeDisappearingItemMappings(i, lastDescendantOfItem);
                i = lastDescendantOfItem;
                continue;
            }
            if (newPosition == -1) {
                this.unmountItem(this.mContext, i, this.mHostsByMarker);
                this.mPrepareMountStats.unmountedCount++;
                continue;
            }
            long newHostMarker = newLayoutState.getMountableOutputAt(newPosition).getHostMarker();
            if (oldItem == null) {
                this.mPrepareMountStats.unmountedCount++;
                continue;
            }
            if (oldItem.getHost() != this.mHostsByMarker.get(newHostMarker)) {
                this.unmountItem(this.mContext, i, this.mHostsByMarker);
                this.mPrepareMountStats.unmountedCount++;
                continue;
            }
            if (newPosition != i) {
                oldItem.getHost().moveItem(oldItem, i, newPosition);
                this.mPrepareMountStats.movedCount++;
                continue;
            }
            this.mPrepareMountStats.unchangedCount++;
        }
        return this.mPrepareMountStats;
    }

    private void removeDisappearingItemMappings(int fromIndex, int toIndex) {
        for (int i = fromIndex; i <= toIndex; ++i) {
            MountItem item = this.getItemAt(i);
            this.mIndexToItemMap.remove(this.mLayoutOutputsIds[i]);
            if (!Component.isHostSpec(item.getComponent())) continue;
            this.mHostsByMarker.removeAt(this.mHostsByMarker.indexOfValue((Object)((ComponentHost)((Object)item.getContent()))));
        }
    }

    private void updateMountedContent(MountItem item, LayoutOutput layoutOutput, Component previousComponent) {
        Component<?> component = layoutOutput.getComponent();
        if (Component.isHostSpec(component)) {
            return;
        }
        Object previousContent = item.getContent();
        Object lifecycle = component.getLifecycle();
        ((ComponentLifecycle)lifecycle).unmount(this.getContextForComponent(previousComponent), previousContent, previousComponent);
        ((ComponentLifecycle)lifecycle).mount(this.getContextForComponent(component), previousContent, component);
    }

    private void mountLayoutOutput(int index, LayoutOutput layoutOutput, LayoutState layoutState) {
        ComponentHost host = MountState.resolveComponentHost(layoutOutput, this.mHostsByMarker);
        if (host == null) {
            int size = this.mLayoutOutputsIds.length;
            for (int hostMountIndex = 0; hostMountIndex < size; ++hostMountIndex) {
                if (this.mLayoutOutputsIds[hostMountIndex] != layoutOutput.getHostMarker()) continue;
                LayoutOutput hostLayoutOutput = layoutState.getMountableOutputAt(hostMountIndex);
                this.mountLayoutOutput(hostMountIndex, hostLayoutOutput, layoutState);
                break;
            }
            host = MountState.resolveComponentHost(layoutOutput, this.mHostsByMarker);
        }
        Component<?> component = layoutOutput.getComponent();
        ComponentContext context = this.getContextForComponent(component);
        Object lifecycle = component.getLifecycle();
        Object content = this.acquireMountContent(component, host);
        if (content == null) {
            content = ((ComponentLifecycle)lifecycle).createMountContent(this.mContext);
        }
        ((ComponentLifecycle)lifecycle).mount(context, content, component);
        if (Component.isHostSpec(component)) {
            ComponentHost componentHost = (ComponentHost)((Object)content);
            componentHost.setParentHostMarker(layoutOutput.getHostMarker());
            this.registerHost(layoutOutput.getId(), componentHost);
        }
        MountItem item = this.mountContent(index, component, content, host, layoutOutput);
        ((ComponentLifecycle)lifecycle).bind(context, content, component);
        item.setIsBound(true);
        layoutOutput.getMountBounds(sTempRect);
        MountState.applyBoundsToMountContent(content, MountState.sTempRect.left, MountState.sTempRect.top, MountState.sTempRect.right, MountState.sTempRect.bottom, true);
        if (item.getDisplayListDrawable() != null) {
            item.getDisplayListDrawable().suppressInvalidations(false);
        }
        this.mMountStats.mountedCount++;
    }

    private MountItem mountContent(int index, Component<?> component, Object content, ComponentHost host, LayoutOutput layoutOutput) {
        MountItem item = ComponentsPools.acquireMountItem(component, host, content, layoutOutput);
        this.mIndexToItemMap.put(this.mLayoutOutputsIds[index], (Object)item);
        if (((ComponentLifecycle)component.getLifecycle()).canMountIncrementally()) {
            this.mCanMountIncrementallyMountItems.put(this.mLayoutOutputsIds[index], (Object)item);
        }
        layoutOutput.getMountBounds(sTempRect);
        host.mount(index, item, sTempRect);
        MountState.setViewAttributes(item);
        this.maybeUpdateAnimatingMountContent(item, content);
        return item;
    }

    private Object acquireMountContent(Component<?> component, ComponentHost host) {
        Object lifecycle = component.getLifecycle();
        if (Component.isHostSpec(component)) {
            return host.recycleHost();
        }
        return ComponentsPools.acquireMountContent((Context)this.mContext, ((ComponentLifecycle)lifecycle).getTypeId());
    }

    private static void applyBoundsToMountContent(Object content, int left, int top, int right, int bottom, boolean force) {
        ThreadUtils.assertMainThread();
        if (content instanceof View) {
            BoundsHelper.applyBoundsToView((View)content, left, top, right, bottom, force);
        } else if (content instanceof Drawable) {
            ((Drawable)content).setBounds(left, top, right, bottom);
        } else {
            throw new IllegalStateException("Unsupported mounted content " + content);
        }
    }

    private static boolean canMountIncrementally(Component<?> component) {
        return ((ComponentLifecycle)component.getLifecycle()).canMountIncrementally();
    }

    private static ComponentHost resolveComponentHost(LayoutOutput layoutOutput, LongSparseArray<ComponentHost> hostsByMarker) {
        long hostMarker = layoutOutput.getHostMarker();
        return (ComponentHost)((Object)hostsByMarker.get(hostMarker));
    }

    private static void setViewAttributes(MountItem item) {
        Component<?> component = item.getComponent();
        if (!Component.isMountViewSpec(component)) {
            return;
        }
        View view = (View)item.getContent();
        NodeInfo nodeInfo = item.getNodeInfo();
        if (nodeInfo != null) {
            MountState.setClickHandler(nodeInfo.getClickHandler(), view);
            MountState.setLongClickHandler(nodeInfo.getLongClickHandler(), view);
            MountState.setFocusChangeHandler(nodeInfo.getFocusChangeHandler(), view);
            MountState.setTouchHandler(nodeInfo.getTouchHandler(), view);
            MountState.setInterceptTouchHandler(nodeInfo.getInterceptTouchHandler(), view);
            MountState.setAccessibilityDelegate(view, nodeInfo);
            MountState.setViewTag(view, nodeInfo.getViewTag());
            MountState.setViewTags(view, nodeInfo.getViewTags());
            MountState.setShadowElevation(view, nodeInfo.getShadowElevation());
            MountState.setOutlineProvider(view, nodeInfo.getOutlineProvider());
            MountState.setClipToOutline(view, nodeInfo.getClipToOutline());
            MountState.setContentDescription(view, nodeInfo.getContentDescription());
            MountState.setFocusable(view, nodeInfo.getFocusState());
            MountState.setEnabled(view, nodeInfo.getEnabledState());
            MountState.setScale(view, nodeInfo);
            MountState.setAlpha(view, nodeInfo);
        }
        MountState.setImportantForAccessibility(view, item.getImportantForAccessibility());
        ViewNodeInfo viewNodeInfo = item.getViewNodeInfo();
        if (viewNodeInfo != null) {
            MountState.setViewClipChildren(view, viewNodeInfo);
            if (!Component.isHostSpec(component)) {
                MountState.setViewBackground(view, viewNodeInfo);
                MountState.setViewPadding(view, viewNodeInfo);
                MountState.setViewForeground(view, viewNodeInfo);
                MountState.setViewLayoutDirection(view, viewNodeInfo);
            }
        }
    }

    private static void unsetViewAttributes(MountItem item) {
        Component<?> component = item.getComponent();
        if (!Component.isMountViewSpec(component)) {
            return;
        }
        View view = (View)item.getContent();
        NodeInfo nodeInfo = item.getNodeInfo();
        if (nodeInfo != null) {
            if (nodeInfo.getClickHandler() != null) {
                MountState.unsetClickHandler(view);
            }
            if (nodeInfo.getLongClickHandler() != null) {
                MountState.unsetLongClickHandler(view);
            }
            if (nodeInfo.getFocusChangeHandler() != null) {
                MountState.unsetFocusChangeHandler(view);
            }
            if (nodeInfo.getTouchHandler() != null) {
                MountState.unsetTouchHandler(view);
            }
            if (nodeInfo.getInterceptTouchHandler() != null) {
                MountState.unsetInterceptTouchEventHandler(view);
            }
            MountState.unsetViewTag(view);
            MountState.unsetViewTags(view, nodeInfo.getViewTags());
            MountState.unsetShadowElevation(view, nodeInfo.getShadowElevation());
            MountState.unsetOutlineProvider(view, nodeInfo.getOutlineProvider());
            MountState.unsetClipToOutline(view, nodeInfo.getClipToOutline());
            if (!TextUtils.isEmpty((CharSequence)nodeInfo.getContentDescription())) {
                MountState.unsetContentDescription(view);
            }
            MountState.unsetAlpha(view, nodeInfo);
        }
        view.setClickable(MountItem.isViewClickable(item.getFlags()));
        view.setLongClickable(MountItem.isViewLongClickable(item.getFlags()));
        MountState.unsetFocusable(view, item);
        MountState.unsetEnabled(view, item);
        MountState.unsetScale(view);
        if (item.getImportantForAccessibility() != 0) {
            MountState.unsetImportantForAccessibility(view);
        }
        MountState.unsetAccessibilityDelegate(view);
        ViewNodeInfo viewNodeInfo = item.getViewNodeInfo();
        if (viewNodeInfo != null) {
            MountState.unsetViewClipChildren(view);
            if (!Component.isHostSpec(component)) {
                MountState.unsetViewPadding(view, viewNodeInfo);
                MountState.unsetViewBackground(view, viewNodeInfo);
                MountState.unsetViewForeground(view, viewNodeInfo);
                MountState.unsetViewLayoutDirection(view, viewNodeInfo);
            }
        }
    }

    private static void setAccessibilityDelegate(View view, NodeInfo nodeInfo) {
        if (!(view instanceof ComponentHost) && !nodeInfo.hasAccessibilityHandlers()) {
            return;
        }
        view.setTag(R.id.component_node_info, (Object)nodeInfo);
    }

    private static void unsetAccessibilityDelegate(View view) {
        if (!(view instanceof ComponentHost) && view.getTag(R.id.component_node_info) == null) {
            return;
        }
        view.setTag(R.id.component_node_info, null);
        if (!(view instanceof ComponentHost)) {
            ViewCompat.setAccessibilityDelegate((View)view, null);
        }
    }

    private static void setClickHandler(EventHandler<ClickEvent> clickHandler, View view) {
        if (clickHandler == null) {
            return;
        }
        ComponentClickListener listener = MountState.getComponentClickListener(view);
        if (listener == null) {
            listener = new ComponentClickListener();
            MountState.setComponentClickListener(view, listener);
        }
        listener.setEventHandler(clickHandler);
        view.setClickable(true);
    }

    private static void unsetClickHandler(View view) {
        ComponentClickListener listener = MountState.getComponentClickListener(view);
        if (listener != null) {
            listener.setEventHandler(null);
        }
    }

    static ComponentClickListener getComponentClickListener(View v) {
        if (v instanceof ComponentHost) {
            return ((ComponentHost)v).getComponentClickListener();
        }
        return (ComponentClickListener)v.getTag(R.id.component_click_listener);
    }

    static void setComponentClickListener(View v, ComponentClickListener listener) {
        if (v instanceof ComponentHost) {
            ((ComponentHost)v).setComponentClickListener(listener);
        } else {
            v.setOnClickListener((View.OnClickListener)listener);
            v.setTag(R.id.component_click_listener, (Object)listener);
        }
    }

    private static void setLongClickHandler(EventHandler<LongClickEvent> longClickHandler, View view) {
        if (longClickHandler != null) {
            ComponentLongClickListener listener = MountState.getComponentLongClickListener(view);
            if (listener == null) {
                listener = new ComponentLongClickListener();
                MountState.setComponentLongClickListener(view, listener);
            }
            listener.setEventHandler(longClickHandler);
            view.setLongClickable(true);
        }
    }

    private static void unsetLongClickHandler(View view) {
        ComponentLongClickListener listener = MountState.getComponentLongClickListener(view);
        if (listener != null) {
            listener.setEventHandler(null);
        }
    }

    static ComponentLongClickListener getComponentLongClickListener(View v) {
        if (v instanceof ComponentHost) {
            return ((ComponentHost)v).getComponentLongClickListener();
        }
        return (ComponentLongClickListener)v.getTag(R.id.component_long_click_listener);
    }

    static void setComponentLongClickListener(View v, ComponentLongClickListener listener) {
        if (v instanceof ComponentHost) {
            ((ComponentHost)v).setComponentLongClickListener(listener);
        } else {
            v.setOnLongClickListener((View.OnLongClickListener)listener);
            v.setTag(R.id.component_long_click_listener, (Object)listener);
        }
    }

    private static void setFocusChangeHandler(EventHandler<FocusChangedEvent> focusChangeHandler, View view) {
        if (focusChangeHandler == null) {
            return;
        }
        ComponentFocusChangeListener listener = MountState.getComponentFocusChangeListener(view);
        if (listener == null) {
            listener = new ComponentFocusChangeListener();
            MountState.setComponentFocusChangeListener(view, listener);
        }
        listener.setEventHandler(focusChangeHandler);
    }

    private static void unsetFocusChangeHandler(View view) {
        ComponentFocusChangeListener listener = MountState.getComponentFocusChangeListener(view);
        if (listener != null) {
            listener.setEventHandler(null);
        }
    }

    static ComponentFocusChangeListener getComponentFocusChangeListener(View v) {
        if (v instanceof ComponentHost) {
            return ((ComponentHost)v).getComponentFocusChangeListener();
        }
        return (ComponentFocusChangeListener)v.getTag(R.id.component_focus_change_listener);
    }

    static void setComponentFocusChangeListener(View v, ComponentFocusChangeListener listener) {
        if (v instanceof ComponentHost) {
            ((ComponentHost)v).setComponentFocusChangeListener(listener);
        } else {
            v.setOnFocusChangeListener((View.OnFocusChangeListener)listener);
            v.setTag(R.id.component_focus_change_listener, (Object)listener);
        }
    }

    private static void setTouchHandler(EventHandler<TouchEvent> touchHandler, View view) {
        if (touchHandler != null) {
            ComponentTouchListener listener = MountState.getComponentTouchListener(view);
            if (listener == null) {
                listener = new ComponentTouchListener();
                MountState.setComponentTouchListener(view, listener);
            }
            listener.setEventHandler(touchHandler);
        }
    }

    private static void unsetTouchHandler(View view) {
        ComponentTouchListener listener = MountState.getComponentTouchListener(view);
        if (listener != null) {
            listener.setEventHandler(null);
        }
    }

    private static void setInterceptTouchHandler(EventHandler<InterceptTouchEvent> interceptTouchHandler, View view) {
        if (interceptTouchHandler == null) {
            return;
        }
        if (view instanceof ComponentHost) {
            ((ComponentHost)view).setInterceptTouchEventHandler(interceptTouchHandler);
        }
    }

    private static void unsetInterceptTouchEventHandler(View view) {
        if (view instanceof ComponentHost) {
            ((ComponentHost)view).setInterceptTouchEventHandler(null);
        }
    }

    static ComponentTouchListener getComponentTouchListener(View v) {
        if (v instanceof ComponentHost) {
            return ((ComponentHost)v).getComponentTouchListener();
        }
        return (ComponentTouchListener)v.getTag(R.id.component_touch_listener);
    }

    static void setComponentTouchListener(View v, ComponentTouchListener listener) {
        if (v instanceof ComponentHost) {
            ((ComponentHost)v).setComponentTouchListener(listener);
        } else {
            v.setOnTouchListener((View.OnTouchListener)listener);
            v.setTag(R.id.component_touch_listener, (Object)listener);
        }
    }

    private static void setViewTag(View view, Object viewTag) {
        if (view instanceof ComponentHost) {
            ComponentHost host = (ComponentHost)view;
            host.setViewTag(viewTag);
        } else {
            view.setTag(viewTag);
        }
    }

    private static void setViewTags(View view, SparseArray<Object> viewTags) {
        if (viewTags == null) {
            return;
        }
        if (view instanceof ComponentHost) {
            ComponentHost host = (ComponentHost)view;
            host.setViewTags(viewTags);
        } else {
            int size = viewTags.size();
            for (int i = 0; i < size; ++i) {
                view.setTag(viewTags.keyAt(i), viewTags.valueAt(i));
            }
        }
    }

    private static void unsetViewTag(View view) {
        if (view instanceof ComponentHost) {
            ComponentHost host = (ComponentHost)view;
            host.setViewTag(null);
        } else {
            view.setTag(null);
        }
    }

    private static void unsetViewTags(View view, SparseArray<Object> viewTags) {
        if (view instanceof ComponentHost) {
            ComponentHost host = (ComponentHost)view;
            host.setViewTags(null);
        } else if (viewTags != null) {
            int size = viewTags.size();
            for (int i = 0; i < size; ++i) {
                view.setTag(viewTags.keyAt(i), null);
            }
        }
    }

    private static void setShadowElevation(View view, float shadowElevation) {
        if (shadowElevation != 0.0f) {
            ViewCompat.setElevation((View)view, (float)shadowElevation);
        }
    }

    private static void unsetShadowElevation(View view, float shadowElevation) {
        if (shadowElevation != 0.0f) {
            ViewCompat.setElevation((View)view, (float)0.0f);
        }
    }

    private static void setOutlineProvider(View view, ViewOutlineProvider outlineProvider) {
        if (outlineProvider != null && Build.VERSION.SDK_INT >= 21) {
            view.setOutlineProvider(outlineProvider);
        }
    }

    private static void unsetOutlineProvider(View view, ViewOutlineProvider outlineProvider) {
        if (outlineProvider != null && Build.VERSION.SDK_INT >= 21) {
            view.setOutlineProvider(ViewOutlineProvider.BACKGROUND);
        }
    }

    private static void setClipToOutline(View view, boolean clipToOutline) {
        if (clipToOutline && Build.VERSION.SDK_INT >= 21) {
            view.setClipToOutline(clipToOutline);
        }
    }

    private static void unsetClipToOutline(View view, boolean clipToOutline) {
        if (clipToOutline && Build.VERSION.SDK_INT >= 21) {
            view.setClipToOutline(false);
        }
    }

    private static void setContentDescription(View view, CharSequence contentDescription) {
        if (TextUtils.isEmpty((CharSequence)contentDescription)) {
            return;
        }
        view.setContentDescription(contentDescription);
    }

    private static void unsetContentDescription(View view) {
        view.setContentDescription(null);
    }

    private static void setImportantForAccessibility(View view, int importantForAccessibility) {
        if (importantForAccessibility == 0) {
            return;
        }
        ViewCompat.setImportantForAccessibility((View)view, (int)importantForAccessibility);
    }

    private static void unsetImportantForAccessibility(View view) {
        ViewCompat.setImportantForAccessibility((View)view, (int)0);
    }

    private static void setFocusable(View view, short focusState) {
        if (focusState == 1) {
            view.setFocusable(true);
        } else if (focusState == 2) {
            view.setFocusable(false);
        }
    }

    private static void unsetFocusable(View view, MountItem mountItem) {
        view.setFocusable(MountItem.isViewFocusable(mountItem.getFlags()));
    }

    private static void setEnabled(View view, short enabledState) {
        if (enabledState == 1) {
            view.setEnabled(true);
        } else if (enabledState == 2) {
            view.setEnabled(false);
        }
    }

    private static void unsetEnabled(View view, MountItem mountItem) {
        view.setEnabled(MountItem.isViewEnabled(mountItem.getFlags()));
    }

    private static void setScale(View view, NodeInfo nodeInfo) {
        if (Build.VERSION.SDK_INT >= 11 && nodeInfo.isScaleSet()) {
            float scale = nodeInfo.getScale();
            view.setScaleX(scale);
            view.setScaleY(scale);
        }
    }

    private static void unsetScale(View view) {
        if (Build.VERSION.SDK_INT >= 11) {
            if (view.getScaleX() != 1.0f) {
                view.setScaleX(1.0f);
            }
            if (view.getScaleY() != 1.0f) {
                view.setScaleY(1.0f);
            }
        }
    }

    private static void setAlpha(View view, NodeInfo nodeInfo) {
        if (Build.VERSION.SDK_INT >= 11 && nodeInfo.isAlphaSet()) {
            view.setAlpha(nodeInfo.getAlpha());
        }
    }

    private static void unsetAlpha(View view, NodeInfo nodeInfo) {
        if (Build.VERSION.SDK_INT >= 11 && nodeInfo.isAlphaSet() && view.getAlpha() != 1.0f) {
            view.setAlpha(1.0f);
        }
    }

    private static void setViewPadding(View view, ViewNodeInfo viewNodeInfo) {
        if (!viewNodeInfo.hasPadding()) {
            return;
        }
        view.setPadding(viewNodeInfo.getPaddingLeft(), viewNodeInfo.getPaddingTop(), viewNodeInfo.getPaddingRight(), viewNodeInfo.getPaddingBottom());
    }

    private static void unsetViewPadding(View view, ViewNodeInfo viewNodeInfo) {
        if (!viewNodeInfo.hasPadding()) {
            return;
        }
        view.setPadding(0, 0, 0, 0);
    }

    private static void setViewBackground(View view, ViewNodeInfo viewNodeInfo) {
        Reference<Drawable> backgroundReference = viewNodeInfo.getBackground();
        if (backgroundReference != null) {
            MountState.setBackgroundCompat(view, Reference.acquire((ComponentContext)view.getContext(), backgroundReference));
        }
    }

    private static void unsetViewBackground(View view, ViewNodeInfo viewNodeInfo) {
        Reference<Drawable> backgroundReference = viewNodeInfo.getBackground();
        if (backgroundReference != null) {
            Reference.release((ComponentContext)view.getContext(), view.getBackground(), backgroundReference);
            MountState.setBackgroundCompat(view, null);
        }
    }

    private static void setBackgroundCompat(View view, Drawable drawable) {
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(drawable);
        } else {
            view.setBackground(drawable);
        }
    }

    private static void setViewForeground(View view, ViewNodeInfo viewNodeInfo) {
        Drawable foreground = viewNodeInfo.getForeground();
        if (foreground != null) {
            if (Build.VERSION.SDK_INT < 23) {
                throw new IllegalStateException("MountState has a ViewNodeInfo with foreground however the current Android version doesn't support foreground on Views");
            }
            view.setForeground(foreground);
        }
    }

    private static void unsetViewForeground(View view, ViewNodeInfo viewNodeInfo) {
        Drawable foreground = viewNodeInfo.getForeground();
        if (foreground != null) {
            if (Build.VERSION.SDK_INT < 23) {
                throw new IllegalStateException("MountState has a ViewNodeInfo with foreground however the current Android version doesn't support foreground on Views");
            }
            view.setForeground(null);
        }
    }

    private static void setViewLayoutDirection(View view, ViewNodeInfo viewNodeInfo) {
        int viewLayoutDirection;
        if (Build.VERSION.SDK_INT < 17) {
            return;
        }
        switch (viewNodeInfo.getLayoutDirection()) {
            case LTR: {
                viewLayoutDirection = 0;
                break;
            }
            case RTL: {
                viewLayoutDirection = 1;
                break;
            }
            default: {
                viewLayoutDirection = 2;
            }
        }
        view.setLayoutDirection(viewLayoutDirection);
    }

    private static void unsetViewLayoutDirection(View view, ViewNodeInfo viewNodeInfo) {
        if (Build.VERSION.SDK_INT < 17) {
            return;
        }
        view.setLayoutDirection(2);
    }

    private static void setViewClipChildren(View view, ViewNodeInfo viewNodeInfo) {
        if (view instanceof ViewGroup) {
            ((ViewGroup)view).setClipChildren(viewNodeInfo.getClipChildren());
        }
    }

    private static void unsetViewClipChildren(View view) {
        if (view instanceof ViewGroup) {
            ((ViewGroup)view).setClipChildren(true);
        }
    }

    private static void mountItemIncrementally(MountItem item, Rect itemBounds, Rect localVisibleRect, boolean processVisibilityOutputs) {
        Component<?> component = item.getComponent();
        if (!Component.isMountViewSpec(component)) {
            return;
        }
        View view = (View)item.getContent();
        Rect rect = ComponentsPools.acquireRect();
        rect.set(Math.max(0, localVisibleRect.left - itemBounds.left), Math.max(0, localVisibleRect.top - itemBounds.top), itemBounds.width() - Math.max(0, itemBounds.right - localVisibleRect.right), itemBounds.height() - Math.max(0, itemBounds.bottom - localVisibleRect.bottom));
        MountState.mountViewIncrementally(view, rect, processVisibilityOutputs);
        ComponentsPools.release(rect);
    }

    private static void mountViewIncrementally(View view, Rect localVisibleRect, boolean processVisibilityOutputs) {
        ThreadUtils.assertMainThread();
        if (view instanceof LithoView) {
            LithoView lithoView = (LithoView)view;
            lithoView.performIncrementalMount(localVisibleRect, processVisibilityOutputs);
        } else if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View childView = viewGroup.getChildAt(i);
                if (!localVisibleRect.intersects(childView.getLeft(), childView.getTop(), childView.getRight(), childView.getBottom())) continue;
                Rect rect = ComponentsPools.acquireRect();
                rect.set(Math.max(0, localVisibleRect.left - childView.getLeft()), Math.max(0, localVisibleRect.top - childView.getTop()), childView.getWidth() - Math.max(0, childView.getRight() - localVisibleRect.right), childView.getHeight() - Math.max(0, childView.getBottom() - localVisibleRect.bottom));
                MountState.mountViewIncrementally(childView, rect, processVisibilityOutputs);
                ComponentsPools.release(rect);
            }
        }
    }

    private void unmountDisappearingItemChild(ComponentContext context, MountItem item) {
        int index;
        ComponentHost host;
        Object content = item.getContent();
        if (content instanceof ComponentHost) {
            host = (ComponentHost)((Object)content);
            for (int i = host.getMountItemCount() - 1; i >= 0; --i) {
                MountItem mountItem = host.getMountItemAt(i);
                this.unmountDisappearingItemChild(context, mountItem);
            }
            if (host.getMountItemCount() > 0) {
                throw new IllegalStateException("Recursively unmounting items from a ComponentHost, left some items behind maybe because not tracked by its MountState");
            }
        }
        host = item.getHost();
        host.unmount(item);
        MountState.unsetViewAttributes(item);
        this.unbindAndUnmountLifecycle(context, item);
        if (((ComponentLifecycle)item.getComponent().getLifecycle()).canMountIncrementally() && (index = this.mCanMountIncrementallyMountItems.indexOfValue((Object)item)) > 0) {
            this.mCanMountIncrementallyMountItems.removeAt(index);
        }
        ComponentsPools.release((Context)context, item);
    }

    void unmountAllItems() {
        if (this.mLayoutOutputsIds == null) {
            return;
        }
        for (int i = this.mLayoutOutputsIds.length - 1; i >= 0; --i) {
            this.unmountItem(this.mContext, i, this.mHostsByMarker);
        }
    }

    private void unmountItem(ComponentContext context, int index, LongSparseArray<ComponentHost> hostsByMarker) {
        int i;
        ComponentHost host;
        MountItem item = this.getItemAt(index);
        if (item == null || this.mLayoutOutputsIds[index] == 0L) {
            return;
        }
        Object content = item.getContent();
        if (content instanceof ComponentHost && !(content instanceof LithoView)) {
            host = (ComponentHost)((Object)content);
            block0: for (i = host.getMountItemCount() - 1; i >= 0; --i) {
                MountItem mountItem = host.getMountItemAt(i);
                long layoutOutputId = this.mIndexToItemMap.keyAt(this.mIndexToItemMap.indexOfValue((Object)mountItem));
                for (int mountIndex = this.mLayoutOutputsIds.length - 1; mountIndex >= 0; --mountIndex) {
                    if (this.mLayoutOutputsIds[mountIndex] != layoutOutputId) continue;
                    this.unmountItem(context, mountIndex, hostsByMarker);
                    continue block0;
                }
            }
            if (host.getMountItemCount() > 0) {
                throw new IllegalStateException("Recursively unmounting items from a ComponentHost, left some items behind maybe because not tracked by its MountState");
            }
        }
        if (ComponentsConfiguration.deepUnmountEnabled && content instanceof HasLithoViewChildren) {
            ArrayList<LithoView> lithoViews = ComponentsPools.acquireLithoViewArrayList();
            ((HasLithoViewChildren)content).obtainLithoViewChildren(lithoViews);
            for (i = lithoViews.size() - 1; i >= 0; --i) {
                LithoView lithoView = lithoViews.get(i);
                lithoView.unmountAllItems();
            }
            ComponentsPools.release(lithoViews);
        }
        host = item.getHost();
        host.unmount(index, item);
        MountState.unsetViewAttributes(item);
        Component<?> component = item.getComponent();
        if (Component.isHostSpec(component)) {
            ComponentHost componentHost = (ComponentHost)((Object)content);
            hostsByMarker.removeAt(hostsByMarker.indexOfValue((Object)componentHost));
            this.removeDisappearingMountContentFromComponentHost(componentHost);
        }
        this.unbindAndUnmountLifecycle(context, item);
        this.mIndexToItemMap.remove(this.mLayoutOutputsIds[index]);
        this.maybeUpdateAnimatingMountContent(item, null);
        if (((ComponentLifecycle)component.getLifecycle()).canMountIncrementally()) {
            this.mCanMountIncrementallyMountItems.delete(this.mLayoutOutputsIds[index]);
        }
        ComponentsPools.release((Context)context, item);
        this.mMountStats.unmountedCount++;
    }

    private void unbindAndUnmountLifecycle(ComponentContext context, MountItem item) {
        Component<?> component = item.getComponent();
        Object content = item.getContent();
        Object lifecycle = component.getLifecycle();
        if (item.isBound()) {
            ((ComponentLifecycle)lifecycle).onUnbind(context, content, component);
            item.setIsBound(false);
        }
        ((ComponentLifecycle)lifecycle).unmount(context, content, component);
    }

    private void startUnmountDisappearingItem(int index, String key) {
        MountItem item = this.getItemAt(index);
        if (item == null) {
            throw new RuntimeException("Item at index=" + index + " does not exist");
        }
        if (!(item.getContent() instanceof ComponentHost)) {
            throw new RuntimeException("Only host components can be used as disappearing items");
        }
        if (this.mDisappearingMountItems.put(key, item) != null) {
            throw new RuntimeException("Disappearing the same key twice!");
        }
        ComponentHost host = item.getHost();
        host.startUnmountDisappearingItem(index, item);
        this.mTransitionManager.setMountContent(key, item.getContent());
    }

    private void endUnmountDisappearingItem(MountItem item) {
        int index;
        ComponentHost content = (ComponentHost)((Object)item.getContent());
        for (int i = content.getMountItemCount() - 1; i >= 0; --i) {
            MountItem mountItem = content.getMountItemAt(i);
            this.unmountDisappearingItemChild(this.mContext, mountItem);
        }
        if (content.getMountItemCount() > 0) {
            throw new IllegalStateException("Recursively unmounting items from a ComponentHost, left some items behind maybe because not tracked by its MountState");
        }
        ComponentHost host = item.getHost();
        host.unmountDisappearingItem(item);
        MountState.unsetViewAttributes(item);
        this.unbindAndUnmountLifecycle(this.mContext, item);
        if (((ComponentLifecycle)item.getComponent().getLifecycle()).canMountIncrementally() && (index = this.mCanMountIncrementallyMountItems.indexOfValue((Object)item)) > 0) {
            this.mCanMountIncrementallyMountItems.removeAt(index);
        }
        ComponentsPools.release((Context)this.mContext, item);
    }

    int getItemCount() {
        return this.mLayoutOutputsIds == null ? 0 : this.mLayoutOutputsIds.length;
    }

    MountItem getItemAt(int i) {
        return (MountItem)this.mIndexToItemMap.get(this.mLayoutOutputsIds[i]);
    }

    private void updateTransitions(LayoutState layoutState) {
        if (!this.mIsDirty) {
            throw new RuntimeException("Should only process transitions on dirty mounts");
        }
        int componentTreeId = layoutState.getComponentTreeId();
        if (this.mLastMountedComponentTreeId != componentTreeId) {
            this.resetAnimationState();
            if (!this.mIsFirstMountOfComponentTree) {
                return;
            }
        }
        if (!this.mDisappearingMountItems.isEmpty()) {
            this.updateDisappearingMountItems(layoutState);
        }
        if (this.shouldAnimateTransitions(layoutState)) {
            this.mMountTimeTransitions = MountState.collectMountTimeTransitions(layoutState);
            if (this.hasTransitionsToAnimate(layoutState)) {
                this.createNewTransitions(layoutState);
            }
        }
        this.mAnimationLockedIndices = null;
        if (!this.mAnimatingTransitionKeys.isEmpty()) {
            this.regenerateAnimationLockedIndices(layoutState);
        }
    }

    private void resetAnimationState() {
        if (this.mTransitionManager == null) {
            return;
        }
        for (MountItem item : this.mDisappearingMountItems.values()) {
            this.endUnmountDisappearingItem(item);
        }
        this.mDisappearingMountItems.clear();
        this.mAnimatingTransitionKeys.clear();
        this.mTransitionManager.reset();
        this.mAnimationLockedIndices = null;
    }

    private void updateDisappearingMountItems(LayoutState newLayoutState) {
        SimpleArrayMap<String, LayoutOutput> nextMountedTransitionKeys = newLayoutState.getTransitionKeyMapping();
        int size = nextMountedTransitionKeys.size();
        for (int i = 0; i < size; ++i) {
            String transitionKey = (String)nextMountedTransitionKeys.keyAt(i);
            MountItem disappearingItem = this.mDisappearingMountItems.remove(transitionKey);
            if (disappearingItem == null) continue;
            this.endUnmountDisappearingItem(disappearingItem);
        }
    }

    private void createNewTransitions(LayoutState newLayoutState) {
        this.prepareTransitionManager(newLayoutState);
        this.mTransitionManager.setupTransitions(this.mLastMountedLayoutState, newLayoutState, this.mMountTimeTransitions);
        SimpleArrayMap<String, LayoutOutput> nextTransitionKeys = newLayoutState.getTransitionKeyMapping();
        int size = nextTransitionKeys.size();
        for (int i = 0; i < size; ++i) {
            String transitionKey = (String)nextTransitionKeys.keyAt(i);
            if (!this.mTransitionManager.isKeyAnimating(transitionKey)) continue;
            this.mAnimatingTransitionKeys.add(transitionKey);
        }
    }

    private void regenerateAnimationLockedIndices(LayoutState newLayoutState) {
        this.mAnimationLockedIndices = null;
        int size = newLayoutState.getMountableOutputCount();
        for (int i = 0; i < size; ++i) {
            LayoutOutput output = newLayoutState.getMountableOutputAt(i);
            String transitionKey = output.getTransitionKey();
            if (transitionKey == null || !this.mAnimatingTransitionKeys.contains(transitionKey)) continue;
            this.lockLayoutOutputForAnimation(newLayoutState, i);
        }
    }

    private int findLastDescendantIndex(LayoutState layoutState, int index) {
        LayoutOutput host = layoutState.getMountableOutputAt(index);
        long hostId = host.getId();
        int size = layoutState.getMountableOutputCount();
        for (int i = index + 1; i < size; ++i) {
            LayoutOutput layoutOutput = layoutState.getMountableOutputAt(i);
            long curentHostId = layoutOutput.getHostMarker();
            while (curentHostId != hostId) {
                if (curentHostId == 0L) {
                    return i - 1;
                }
                int parentIndex = layoutState.getLayoutOutputPositionForId(curentHostId);
                LayoutOutput parent = layoutState.getMountableOutputAt(parentIndex);
                curentHostId = parent.getHostMarker();
            }
        }
        return layoutState.getMountableOutputCount() - 1;
    }

    private void lockLayoutOutputForAnimation(LayoutState layoutState, int index) {
        if (this.mAnimationLockedIndices == null) {
            this.mAnimationLockedIndices = new int[layoutState.getMountableOutputCount()];
        }
        this.updateAnimationLockCount(layoutState, index, true);
    }

    private void unlockLayoutOutputForAnimation(LayoutState layoutState, int index) {
        this.updateAnimationLockCount(layoutState, index, false);
    }

    private void updateAnimationLockCount(LayoutState layoutState, int index, boolean increment) {
        int lastDescendantIndex = this.findLastDescendantIndex(layoutState, index);
        for (int i = index; i <= lastDescendantIndex; ++i) {
            if (increment) {
                int n = i;
                this.mAnimationLockedIndices[n] = this.mAnimationLockedIndices[n] + 1;
                continue;
            }
            int n = i;
            this.mAnimationLockedIndices[n] = this.mAnimationLockedIndices[n] - 1;
            if (this.mAnimationLockedIndices[n] >= 0) continue;
            throw new RuntimeException("Decremented animation lock count below 0!");
        }
        long hostId = layoutState.getMountableOutputAt(index).getHostMarker();
        while (hostId != 0L) {
            int hostIndex = layoutState.getLayoutOutputPositionForId(hostId);
            if (increment) {
                int n = hostIndex;
                this.mAnimationLockedIndices[n] = this.mAnimationLockedIndices[n] + 1;
            } else {
                int n = hostIndex;
                this.mAnimationLockedIndices[n] = this.mAnimationLockedIndices[n] - 1;
                if (this.mAnimationLockedIndices[n] < 0) {
                    throw new RuntimeException("Decremented animation lock count below 0!");
                }
            }
            hostId = layoutState.getMountableOutputAt(hostIndex).getHostMarker();
        }
    }

    private boolean shouldAnimateTransitions(LayoutState newLayoutState) {
        return this.mIsDirty && (this.mLastMountedComponentTreeId == newLayoutState.getComponentTreeId() || this.mIsFirstMountOfComponentTree);
    }

    private boolean hasTransitionsToAnimate(LayoutState newLayoutState) {
        boolean hasMountTimeTransitions = this.mMountTimeTransitions != null && !this.mMountTimeTransitions.isEmpty();
        return hasMountTimeTransitions || newLayoutState.hasTransitionContext();
    }

    private static String getTransitionKey(MountItem mountItem) {
        ViewNodeInfo viewNodeInfo = mountItem.getViewNodeInfo();
        if (viewNodeInfo == null) {
            return null;
        }
        String transitionKey = viewNodeInfo.getTransitionKey();
        if (transitionKey == null || transitionKey.length() == 0) {
            return null;
        }
        return transitionKey;
    }

    @Override
    public void onAnimationComplete(String transitionKey) {
        MountItem disappearingItem = this.mDisappearingMountItems.remove(transitionKey);
        if (disappearingItem != null) {
            this.endUnmountDisappearingItem(disappearingItem);
        } else {
            if (!this.mAnimatingTransitionKeys.remove(transitionKey)) {
                throw new RuntimeException("Ending animation for key " + transitionKey + " but it wasn't recorded as animating!");
            }
            LayoutOutput layoutOutput = this.mLastMountedLayoutState.getLayoutOutputForTransitionKey(transitionKey);
            if (layoutOutput == null) {
                return;
            }
            this.unlockLayoutOutputForAnimation(this.mLastMountedLayoutState, this.mLastMountedLayoutState.getLayoutOutputPositionForId(layoutOutput.getId()));
            if (ComponentsConfiguration.isDebugModeEnabled && this.mAnimatingTransitionKeys.isEmpty()) {
                int size = this.mAnimationLockedIndices.length;
                for (int i = 0; i < size; ++i) {
                    if (this.mAnimationLockedIndices[i] == 0) continue;
                    throw new RuntimeException("No running animations but index " + i + " is still animation locked!");
                }
            }
        }
    }

    void unbind() {
        if (this.mLayoutOutputsIds == null) {
            return;
        }
        int size = this.mLayoutOutputsIds.length;
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = this.getItemAt(i);
            if (mountItem == null || !mountItem.isBound()) continue;
            Component<?> component = mountItem.getComponent();
            ((ComponentLifecycle)component.getLifecycle()).unbind(this.getContextForComponent(component), mountItem.getContent(), component);
            mountItem.setIsBound(false);
        }
        this.clearVisibilityItems();
    }

    void detach() {
        this.unbind();
    }

    void rebind() {
        if (this.mLayoutOutputsIds == null) {
            return;
        }
        int size = this.mLayoutOutputsIds.length;
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = this.getItemAt(i);
            if (mountItem == null || mountItem.isBound()) continue;
            Component<?> component = mountItem.getComponent();
            Object content = mountItem.getContent();
            ((ComponentLifecycle)component.getLifecycle()).bind(this.getContextForComponent(component), content, component);
            mountItem.setIsBound(true);
            if (!(content instanceof View) || content instanceof ComponentHost || !((View)content).isLayoutRequested()) continue;
            View view = (View)content;
            MountState.applyBoundsToMountContent(view, view.getLeft(), view.getTop(), view.getRight(), view.getBottom(), true);
        }
    }

    private boolean isAnimationLocked(int index) {
        if (this.mAnimationLockedIndices == null) {
            return false;
        }
        return this.mAnimationLockedIndices[index] > 0;
    }

    private boolean performIncrementalMount(LayoutState layoutState, Rect localVisibleRect, boolean processVisibilityOutputs) {
        int height;
        int layoutOutputIndex;
        if (this.mPreviousLocalVisibleRect.isEmpty()) {
            return false;
        }
        if (localVisibleRect.left != this.mPreviousLocalVisibleRect.left || localVisibleRect.right != this.mPreviousLocalVisibleRect.right) {
            return false;
        }
        ArrayList<LayoutOutput> layoutOutputTops = layoutState.getMountableOutputTops();
        ArrayList<LayoutOutput> layoutOutputBottoms = layoutState.getMountableOutputBottoms();
        int count = layoutState.getMountableOutputCount();
        if (localVisibleRect.top > 0 || this.mPreviousLocalVisibleRect.top > 0) {
            while (this.mPreviousBottomsIndex < count && localVisibleRect.top >= layoutOutputBottoms.get((int)this.mPreviousBottomsIndex).getBounds().bottom) {
                long id2 = layoutOutputBottoms.get(this.mPreviousBottomsIndex).getId();
                layoutOutputIndex = layoutState.getLayoutOutputPositionForId(id2);
                if (!this.isAnimationLocked(layoutOutputIndex)) {
                    this.unmountItem(this.mContext, layoutOutputIndex, this.mHostsByMarker);
                }
                ++this.mPreviousBottomsIndex;
            }
            while (this.mPreviousBottomsIndex > 0 && localVisibleRect.top < layoutOutputBottoms.get((int)(this.mPreviousBottomsIndex - 1)).getBounds().bottom) {
                --this.mPreviousBottomsIndex;
                LayoutOutput layoutOutput = layoutOutputBottoms.get(this.mPreviousBottomsIndex);
                int layoutOutputIndex2 = layoutState.getLayoutOutputPositionForId(layoutOutput.getId());
                if (this.getItemAt(layoutOutputIndex2) != null) continue;
                this.mountLayoutOutput(layoutState.getLayoutOutputPositionForId(layoutOutput.getId()), layoutOutput, layoutState);
            }
        }
        if (localVisibleRect.bottom < (height = this.mLithoView.getHeight()) || this.mPreviousLocalVisibleRect.bottom < height) {
            while (this.mPreviousTopsIndex < count && localVisibleRect.bottom > layoutOutputTops.get((int)this.mPreviousTopsIndex).getBounds().top) {
                LayoutOutput layoutOutput = layoutOutputTops.get(this.mPreviousTopsIndex);
                layoutOutputIndex = layoutState.getLayoutOutputPositionForId(layoutOutput.getId());
                if (this.getItemAt(layoutOutputIndex) == null) {
                    this.mountLayoutOutput(layoutState.getLayoutOutputPositionForId(layoutOutput.getId()), layoutOutput, layoutState);
                }
                ++this.mPreviousTopsIndex;
            }
            while (this.mPreviousTopsIndex > 0 && localVisibleRect.bottom <= layoutOutputTops.get((int)(this.mPreviousTopsIndex - 1)).getBounds().top) {
                --this.mPreviousTopsIndex;
                long id3 = layoutOutputTops.get(this.mPreviousTopsIndex).getId();
                int layoutOutputIndex3 = layoutState.getLayoutOutputPositionForId(id3);
                if (this.isAnimationLocked(layoutOutputIndex3)) continue;
                this.unmountItem(this.mContext, layoutOutputIndex3, this.mHostsByMarker);
            }
        }
        int size = this.mCanMountIncrementallyMountItems.size();
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = (MountItem)this.mCanMountIncrementallyMountItems.valueAt(i);
            int layoutOutputPosition = layoutState.getLayoutOutputPositionForId(this.mCanMountIncrementallyMountItems.keyAt(i));
            MountState.mountItemIncrementally(mountItem, layoutState.getMountableOutputAt(layoutOutputPosition).getBounds(), localVisibleRect, processVisibilityOutputs);
        }
        return true;
    }

    LithoView getLithoView() {
        return this.mLithoView;
    }

    private void prepareTransitionManager(LayoutState layoutState) {
        if (this.mTransitionManager == null) {
            this.mTransitionManager = new TransitionManager(this, this);
        }
    }

    private void removeDisappearingMountContentFromComponentHost(ComponentHost componentHost) {
        if (componentHost.hasDisappearingItems()) {
            List<String> disappearingKeys = componentHost.getDisappearingItemKeys();
            int size = disappearingKeys.size();
            for (int i = 0; i < size; ++i) {
                this.mTransitionManager.setMountContent(disappearingKeys.get(i), null);
            }
        }
    }

    private void maybeUpdateAnimatingMountContent(MountItem mountItem, Object mountContent) {
        if (this.mTransitionManager == null) {
            return;
        }
        String transitionKey = MountState.getTransitionKey(mountItem);
        if (transitionKey == null) {
            return;
        }
        this.mTransitionManager.setMountContent(transitionKey, mountContent);
    }

    @Nullable
    private static ArrayList<Transition> collectMountTimeTransitions(LayoutState layoutState) {
        List<Component> componentsNeedingPreviousRenderData = layoutState.getComponentsNeedingPreviousRenderData();
        if (componentsNeedingPreviousRenderData == null) {
            return null;
        }
        ArrayList<Transition> result = null;
        int size = componentsNeedingPreviousRenderData.size();
        for (int i = 0; i < size; ++i) {
            Component component = componentsNeedingPreviousRenderData.get(i);
            Transition transition = ((ComponentLifecycle)component.getLifecycle()).onCreateTransition(component.getScopedContext(), component);
            if (transition == null) continue;
            if (result == null) {
                result = new ArrayList<Transition>();
            }
            result.add(transition);
        }
        return result;
    }

    @VisibleForTesting(otherwise=2)
    Deque<TestItem> findTestItems(String testKey) {
        if (this.mTestItemMap == null) {
            throw new UnsupportedOperationException("Trying to access TestItems while ComponentsConfiguration.isEndToEndTestRun is false.");
        }
        LinkedList items = this.mTestItemMap.get(testKey);
        return items == null ? new LinkedList() : items;
    }

    private ComponentContext getContextForComponent(Component component) {
        ComponentContext c = component.getScopedContext();
        return c == null ? this.mContext : c;
    }

    private void releaseLastMountedLayoutState() {
        if (this.mLastMountedLayoutState != null) {
            this.mLastMountedLayoutState.releaseRef();
            this.mLastMountedLayoutState = null;
        }
    }

    private static class LayoutOutputLog {
        long currentId = -1L;
        String currentLifecycle;
        int currentIndex = -1;
        int currentLastDuplicatedIdIndex = -1;
        long nextId = -1L;
        String nextLifecycle;
        int nextIndex = -1;
        int nextLastDuplicatedIdIndex = -1;

        private LayoutOutputLog() {
        }

        public String toString() {
            return "id: [" + this.currentId + " - " + this.nextId + "], lifecycle: [" + this.currentLifecycle + " - " + this.nextLifecycle + "], index: [" + this.currentIndex + " - " + this.nextIndex + "], lastDuplicatedIdIndex: [" + this.currentLastDuplicatedIdIndex + " - " + this.nextLastDuplicatedIdIndex + "]";
        }
    }

    private static class MountStats {
        private int mountedCount;
        private int unmountedCount;
        private int updatedCount;
        private int noOpCount;

        private MountStats() {
        }

        private void reset() {
            this.mountedCount = 0;
            this.unmountedCount = 0;
            this.updatedCount = 0;
            this.noOpCount = 0;
        }
    }

    private static class PrepareMountStats {
        private int unmountedCount = 0;
        private int movedCount = 0;
        private int unchangedCount = 0;

        private PrepareMountStats() {
        }

        private void reset() {
            this.unchangedCount = 0;
            this.movedCount = 0;
            this.unmountedCount = 0;
        }
    }
}

