/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.view.View;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.DisplayListContainer;
import com.facebook.litho.DisplayListDrawable;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.litho.displaylist.DisplayList;

class MountItem {
    static final int FLAG_DUPLICATE_PARENT_STATE = 1;
    static final int FLAG_DISABLE_TOUCHABLE = 2;
    static final int FLAG_VIEW_CLICKABLE = 4;
    static final int FLAG_VIEW_LONG_CLICKABLE = 8;
    static final int FLAG_VIEW_FOCUSABLE = 16;
    static final int FLAG_VIEW_ENABLED = 32;
    static final int FLAG_IS_TRANSITION_KEY_SET = 64;
    private NodeInfo mNodeInfo;
    private ViewNodeInfo mViewNodeInfo;
    private Component<?> mComponent;
    private Object mContent;
    private ComponentHost mHost;
    private boolean mIsBound;
    private int mImportantForAccessibility;
    private DisplayListContainer mDisplayListContainer;
    private DisplayListDrawable mDisplayListDrawable;
    private int mFlags;

    MountItem() {
    }

    void init(Component<?> component, MountItem mountItem, LayoutOutput layoutOutput) {
        this.init(component, mountItem.getHost(), mountItem.getContent(), layoutOutput, mountItem.getDisplayListDrawable());
    }

    void init(Component<?> component, ComponentHost host, Object content, LayoutOutput layoutOutput, DisplayListDrawable displayListDrawable) {
        this.init(component, host, content, layoutOutput.getNodeInfo(), layoutOutput.getViewNodeInfo(), layoutOutput.getDisplayListContainer(), this.acquireDisplayListDrawableIfNeeded(content, layoutOutput.getDisplayListContainer(), displayListDrawable), layoutOutput.getFlags(), layoutOutput.getImportantForAccessibility());
    }

    void init(Component<?> component, ComponentHost host, Object content, NodeInfo nodeInfo, ViewNodeInfo viewNodeInfo, DisplayListContainer displayListContainer, DisplayListDrawable displayListDrawable, int flags, int importantForAccessibility) {
        this.mComponent = component;
        this.mContent = content;
        this.mHost = host;
        this.mFlags = flags;
        this.mImportantForAccessibility = importantForAccessibility;
        this.mDisplayListContainer = displayListContainer;
        this.mDisplayListDrawable = displayListDrawable;
        if (this.mNodeInfo != null) {
            this.mNodeInfo.release();
            this.mNodeInfo = null;
        }
        if (nodeInfo != null) {
            this.mNodeInfo = nodeInfo.acquireRef();
        }
        if (this.mViewNodeInfo != null) {
            this.mViewNodeInfo.release();
            this.mViewNodeInfo = null;
        }
        if (viewNodeInfo != null) {
            this.mViewNodeInfo = viewNodeInfo.acquireRef();
        }
        if (this.mContent instanceof View) {
            View view = (View)this.mContent;
            if (view.isClickable()) {
                this.mFlags |= 4;
            }
            if (view.isLongClickable()) {
                this.mFlags |= 8;
            }
            if (view.isFocusable()) {
                this.mFlags |= 0x10;
            }
            if (view.isEnabled()) {
                this.mFlags |= 0x20;
            }
        }
    }

    @Nullable
    private DisplayListDrawable acquireDisplayListDrawableIfNeeded(Object content, DisplayListContainer displayListContainer, DisplayListDrawable convertDisplayListDrawable) {
        if (displayListContainer == null) {
            if (convertDisplayListDrawable != null) {
                ComponentsPools.release(convertDisplayListDrawable);
            }
            return null;
        }
        DisplayList displayList = displayListContainer.getDisplayList();
        if (convertDisplayListDrawable == null && (displayListContainer.canCacheDrawingDisplayLists() || displayList != null)) {
            convertDisplayListDrawable = ComponentsPools.acquireDisplayListDrawable((Drawable)content, displayListContainer);
        } else if (convertDisplayListDrawable != null) {
            convertDisplayListDrawable.setWrappedDrawable((Drawable)content, displayListContainer);
        }
        if (displayList != null) {
            convertDisplayListDrawable.suppressInvalidations(true);
        }
        return convertDisplayListDrawable;
    }

    @Nullable
    Component<?> getComponent() {
        return this.mComponent;
    }

    ComponentHost getHost() {
        return this.mHost;
    }

    Object getContent() {
        return this.mContent;
    }

    int getFlags() {
        return this.mFlags;
    }

    int getImportantForAccessibility() {
        return this.mImportantForAccessibility;
    }

    NodeInfo getNodeInfo() {
        return this.mNodeInfo;
    }

    ViewNodeInfo getViewNodeInfo() {
        return this.mViewNodeInfo;
    }

    boolean isAccessible() {
        if (this.mComponent == null) {
            return false;
        }
        if (this.mImportantForAccessibility == 2) {
            return false;
        }
        return this.mNodeInfo != null && this.mNodeInfo.hasAccessibilityHandlers() || ((ComponentLifecycle)this.mComponent.getLifecycle()).implementsAccessibility();
    }

    void release(Context context) {
        if (!(this.mContent instanceof ComponentHost)) {
            ComponentsPools.release(context, this.mComponent.getLifecycle(), this.mContent);
        }
        if (this.mDisplayListDrawable != null) {
            ComponentsPools.release(this.mDisplayListDrawable);
            this.mDisplayListDrawable = null;
        }
        this.mDisplayListContainer = null;
        if (this.mNodeInfo != null) {
            this.mNodeInfo.release();
            this.mNodeInfo = null;
        }
        if (this.mViewNodeInfo != null) {
            this.mViewNodeInfo.release();
            this.mViewNodeInfo = null;
        }
        this.mComponent = null;
        this.mHost = null;
        this.mContent = null;
        this.mFlags = 0;
        this.mIsBound = false;
        this.mImportantForAccessibility = 0;
    }

    static boolean isDuplicateParentState(int flags) {
        return (flags & 1) == 1;
    }

    static boolean isTouchableDisabled(int flags) {
        return (flags & 2) == 2;
    }

    static boolean isViewClickable(int flags) {
        return (flags & 4) == 4;
    }

    static boolean isViewLongClickable(int flags) {
        return (flags & 8) == 8;
    }

    static boolean isViewFocusable(int flags) {
        return (flags & 0x10) == 16;
    }

    static boolean isViewEnabled(int flags) {
        return (flags & 0x20) == 32;
    }

    boolean isBound() {
        return this.mIsBound;
    }

    void setIsBound(boolean bound) {
        this.mIsBound = bound;
    }

    DisplayListDrawable getDisplayListDrawable() {
        return this.mDisplayListDrawable;
    }

    void setDisplayList(DisplayList displayList) {
        this.mDisplayListContainer.setDisplayList(displayList);
    }

    @Nullable
    DisplayList getDisplayList() {
        return this.mDisplayListContainer.getDisplayList();
    }
}

