/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.SizeSpec;

public class MeasureComparisonUtils {
    private static final float DELTA = 0.5f;

    private static boolean newSizeIsExactAndMatchesOldMeasuredSize(int newSizeSpecMode, int newSizeSpecSize, float oldMeasuredSize) {
        return newSizeSpecMode == 0x40000000 && Math.abs((float)newSizeSpecSize - oldMeasuredSize) < 0.5f;
    }

    private static boolean oldSizeIsUnspecifiedAndStillFits(int oldSizeSpecMode, int newSizeSpecMode, int newSizeSpecSize, float oldMeasuredSize) {
        return newSizeSpecMode == Integer.MIN_VALUE && oldSizeSpecMode == 0 && (float)newSizeSpecSize >= oldMeasuredSize;
    }

    private static boolean newMeasureSizeIsStricterAndStillValid(int oldSizeSpecMode, int newSizeSpecMode, int oldSizeSpecSize, int newSizeSpecSize, float oldMeasuredSize) {
        return oldSizeSpecMode == Integer.MIN_VALUE && newSizeSpecMode == Integer.MIN_VALUE && oldSizeSpecSize > newSizeSpecSize && oldMeasuredSize <= (float)newSizeSpecSize;
    }

    public static boolean isMeasureSpecCompatible(int oldSizeSpec, int sizeSpec, int oldMeasuredSize) {
        int newSpecMode = SizeSpec.getMode(sizeSpec);
        int newSpecSize = SizeSpec.getSize(sizeSpec);
        int oldSpecMode = SizeSpec.getMode(oldSizeSpec);
        int oldSpecSize = SizeSpec.getSize(oldSizeSpec);
        return oldSizeSpec == sizeSpec || MeasureComparisonUtils.newSizeIsExactAndMatchesOldMeasuredSize(newSpecMode, newSpecSize, oldMeasuredSize) || MeasureComparisonUtils.oldSizeIsUnspecifiedAndStillFits(oldSpecMode, newSpecMode, newSpecSize, oldMeasuredSize) || MeasureComparisonUtils.newMeasureSizeIsStricterAndStillValid(oldSpecMode, newSpecMode, oldSpecSize, newSpecSize, oldMeasuredSize);
    }
}

