/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.res.Configuration;
import android.support.v4.util.LruCache;
import com.facebook.litho.ResourceCache;
import javax.annotation.Nullable;

class LruResourceCache
extends ResourceCache {
    private final LruCache<Integer, Object> mCache = new LruCache<Integer, Object>(500){

        protected int sizeOf(Integer key, Object value) {
            if (value instanceof String) {
                return ((String)value).length();
            }
            return 1;
        }
    };

    LruResourceCache(Configuration configuration) {
        super(configuration);
    }

    @Override
    @Nullable
    <T> T get(int key) {
        return (T)this.mCache.get((Object)key);
    }

    @Override
    void put(int key, Object object) {
        this.mCache.put((Object)key, object);
    }
}

