/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.support.v4.util.SimpleArrayMap;

public final class LogEvent {
    private final SimpleArrayMap<String, Object> mParams = new SimpleArrayMap();
    private int mEventId = -1;
    private boolean mIsPerformanceEvent = false;

    LogEvent() {
    }

    void setEventId(int eventId) {
        this.mEventId = eventId;
    }

    void setIsPerformanceEvent(boolean performanceEvent) {
        this.mIsPerformanceEvent = performanceEvent;
    }

    void reset() {
        this.mParams.clear();
        this.mEventId = -1;
        this.mIsPerformanceEvent = false;
    }

    public int getEventId() {
        return this.mEventId;
    }

    public boolean isPerformanceEvent() {
        return this.mIsPerformanceEvent;
    }

    public void addParam(String key, Object value) {
        this.mParams.put((Object)key, value);
    }

    public int getParamCount() {
        return this.mParams.size();
    }

    public String getParamKeyAt(int index) {
        return (String)this.mParams.keyAt(index);
    }

    public <T> T getParamValueAt(int index) {
        return (T)this.mParams.valueAt(index);
    }

    public <T> T getParam(String paramMessage) {
        return (T)this.mParams.get((Object)paramMessage);
    }

    public String toString() {
        return "eventId = " + this.mEventId + ", isPerformanceEvent = " + this.mIsPerformanceEvent + ", params = " + this.mParams.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof LogEvent) {
            LogEvent other = (LogEvent)o;
            if (other.mEventId == this.mEventId && other.mIsPerformanceEvent == this.mIsPerformanceEvent) {
                int count = this.mParams.size();
                for (int i = 0; i < count; ++i) {
                    String key = (String)this.mParams.keyAt(i);
                    if (!other.mParams.containsKey((Object)key) || this.mParams.get((Object)key).equals(other.mParams.get((Object)key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

