/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.LithoView;
import com.facebook.litho.TestItem;
import com.facebook.proguard.annotations.DoNotStrip;
import java.util.Deque;

@DoNotStrip
public class LithoViewTestHelper {
    @DoNotStrip
    @Nullable
    public static TestItem findTestItem(LithoView lithoView, String testKey) {
        Deque<TestItem> items = lithoView.findTestItems(testKey);
        return items.isEmpty() ? null : items.getLast();
    }

    @DoNotStrip
    @NonNull
    public static Deque<TestItem> findTestItems(LithoView lithoView, String testKey) {
        return lithoView.findTestItems(testKey);
    }

    @DoNotStrip
    public static String viewToString(LithoView view) {
        return LithoViewTestHelper.viewToString(DebugComponent.getRootInstance(view), 0);
    }

    private static String viewToString(@Nullable DebugComponent debugComponent, int depth) {
        String textContent;
        if (debugComponent == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (depth > 0) {
            sb.append('\n');
        }
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append(debugComponent.getSimpleName());
        Rect bounds = debugComponent.getBounds();
        sb.append('{');
        sb.append(bounds.left);
        sb.append(", ");
        sb.append(bounds.top);
        sb.append(" - ");
        sb.append(bounds.right);
        sb.append(", ");
        sb.append(bounds.bottom);
        String testKey = debugComponent.getTestKey();
        if (!TextUtils.isEmpty((CharSequence)testKey)) {
            sb.append(String.format(" testKey=\"%s\"", testKey));
        }
        if (!TextUtils.isEmpty((CharSequence)(textContent = debugComponent.getTextContent()))) {
            sb.append(String.format(" text=\"%s\"", textContent));
        }
        if (debugComponent.getClickHandler() != null) {
            sb.append(" [clickable]");
        }
        sb.append('}');
        for (DebugComponent child : debugComponent.getChildComponents()) {
            sb.append(LithoViewTestHelper.viewToString(child, depth + 1));
        }
        return sb.toString();
    }
}

