/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.VisibleForTesting;
import android.support.v4.view.accessibility.AccessibilityManagerCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import com.facebook.litho.AccessibilityUtils;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.LayoutState;
import com.facebook.litho.MountState;
import com.facebook.litho.TestItem;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.proguard.annotations.DoNotStrip;
import java.lang.ref.WeakReference;
import java.util.Deque;
import javax.annotation.Nullable;

public class LithoView
extends ComponentHost {
    private ComponentTree mComponentTree;
    private final MountState mMountState;
    private boolean mIsAttached;
    private final Rect mPreviousMountBounds = new Rect();
    private boolean mForceLayout;
    private boolean mSuppressMeasureComponentTree;
    private boolean mIsMeasuring = false;
    private boolean mHasNewComponentTree = false;
    private int mAnimatedHeight = -1;
    private boolean mIsExpectingBoundsAnimation = false;
    private final AccessibilityManager mAccessibilityManager;
    private final AccessibilityStateChangeListener mAccessibilityStateChangeListener = new AccessibilityStateChangeListener(this);
    private static final int[] sLayoutSize = new int[2];
    private ComponentTree mTemporaryDetachedComponent;
    private int mTransientStateCount;
    private boolean mDoesOwnIncrementalMount;

    public static LithoView create(Context context, Component component) {
        return LithoView.create(new ComponentContext(context), component);
    }

    public static LithoView create(ComponentContext context, Component component) {
        LithoView lithoView = new LithoView(context);
        lithoView.setComponentTree(ComponentTree.create(context, component).build());
        return lithoView;
    }

    public LithoView(Context context) {
        this(context, null);
    }

    public LithoView(Context context, AttributeSet attrs) {
        this(new ComponentContext(context), attrs);
    }

    public LithoView(ComponentContext context) {
        this(context, null);
    }

    public LithoView(ComponentContext context, AttributeSet attrs) {
        super(context, attrs);
        this.mMountState = new MountState(this);
        this.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
    }

    private static void performLayoutOnChildrenIfNecessary(ComponentHost host) {
        int count = host.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = host.getChildAt(i);
            if (child.isLayoutRequested()) {
                child.measure(View.MeasureSpec.makeMeasureSpec((int)child.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)child.getHeight(), (int)0x40000000));
                child.layout(child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
            }
            if (!(child instanceof ComponentHost)) continue;
            LithoView.performLayoutOnChildrenIfNecessary((ComponentHost)child);
        }
    }

    protected void forceRelayout() {
        this.mForceLayout = true;
        this.requestLayout();
    }

    public void startTemporaryDetach() {
        this.mTemporaryDetachedComponent = this.mComponentTree;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.onAttach();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onDetach();
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        this.onDetach();
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        this.onAttach();
    }

    private void onAttach() {
        if (!this.mIsAttached) {
            this.mIsAttached = true;
            if (this.mComponentTree != null) {
                this.mComponentTree.attach();
            }
            this.refreshAccessibilityDelegatesIfNeeded(AccessibilityUtils.isAccessibilityEnabled(this.getContext()));
            AccessibilityManagerCompat.addAccessibilityStateChangeListener((AccessibilityManager)this.mAccessibilityManager, (AccessibilityManagerCompat.AccessibilityStateChangeListener)this.mAccessibilityStateChangeListener);
        }
    }

    private void onDetach() {
        if (this.mIsAttached) {
            this.mIsAttached = false;
            this.mMountState.detach();
            if (this.mComponentTree != null) {
                this.mComponentTree.detach();
            }
            AccessibilityManagerCompat.removeAccessibilityStateChangeListener((AccessibilityManager)this.mAccessibilityManager, (AccessibilityManagerCompat.AccessibilityStateChangeListener)this.mAccessibilityStateChangeListener);
            this.mSuppressMeasureComponentTree = false;
        }
    }

    public void suppressMeasureComponentTree(boolean suppress) {
        this.mSuppressMeasureComponentTree = suppress;
    }

    public void setAnimatedHeight(int height) {
        this.assertExpectingBoundsAnimation();
        this.mAnimatedHeight = height;
        this.requestLayout();
    }

    public boolean isExpectingBoundsAnimation() {
        return this.mIsExpectingBoundsAnimation;
    }

    public void endBoundsAnimation() {
        this.mIsExpectingBoundsAnimation = false;
    }

    private void assertExpectingBoundsAnimation() {
        if (!this.mIsExpectingBoundsAnimation) {
            throw new IllegalStateException("Cannot call this method when not expecting to animate bounds!");
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mAnimatedHeight != -1) {
            int nextHeight = this.mAnimatedHeight;
            this.mAnimatedHeight = -1;
            if (!this.isMountStateDirty()) {
                this.setMeasuredDimension(this.getWidth(), nextHeight);
                return;
            }
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mTemporaryDetachedComponent != null && this.mComponentTree == null) {
            this.setComponentTree(this.mTemporaryDetachedComponent);
            this.mTemporaryDetachedComponent = null;
        }
        this.mIsMeasuring = true;
        if (this.mComponentTree != null && !this.mSuppressMeasureComponentTree) {
            boolean forceRelayout = this.mForceLayout;
            this.mForceLayout = false;
            this.mComponentTree.measure(widthMeasureSpec, heightMeasureSpec, sLayoutSize, forceRelayout);
            width = sLayoutSize[0];
            height = sLayoutSize[1];
        }
        boolean bl = this.mIsExpectingBoundsAnimation = height != this.getHeight() && !this.mHasNewComponentTree && this.mComponentTree != null && this.mComponentTree.hasLithoViewBoundsAnimation();
        if (this.mIsExpectingBoundsAnimation) {
            this.setMeasuredDimension(this.getWidth(), this.getHeight());
        } else {
            this.setMeasuredDimension(width, height);
        }
        this.mHasNewComponentTree = false;
        this.mIsMeasuring = false;
    }

    @Override
    protected void performLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mComponentTree != null) {
            boolean isRectSame;
            if (this.mComponentTree.isReleased()) {
                throw new IllegalStateException("Trying to layout a LithoView holding onto a released ComponentTree");
            }
            boolean wasMountTriggered = this.mComponentTree.layout();
            boolean bl = isRectSame = this.mPreviousMountBounds != null && this.mPreviousMountBounds.left == left && this.mPreviousMountBounds.top == top && this.mPreviousMountBounds.right == right && this.mPreviousMountBounds.bottom == bottom;
            if (!wasMountTriggered && !isRectSame && this.isIncrementalMountEnabled()) {
                this.performIncrementalMount();
            }
            if (!wasMountTriggered || this.shouldAlwaysLayoutChildren()) {
                LithoView.performLayoutOnChildrenIfNecessary(this);
            }
        }
    }

    protected boolean shouldAlwaysLayoutChildren() {
        return false;
    }

    public ComponentContext getComponentContext() {
        return (ComponentContext)this.getContext();
    }

    @Override
    protected boolean shouldRequestLayout() {
        if (this.mComponentTree != null && this.mComponentTree.isMounting()) {
            return false;
        }
        return super.shouldRequestLayout();
    }

    void assertNotInMeasure() {
        if (this.mIsMeasuring) {
            throw new RuntimeException("Cannot update ComponentTree while in the middle of measure");
        }
    }

    @Nullable
    public ComponentTree getComponentTree() {
        return this.mComponentTree;
    }

    public void setComponentTree(ComponentTree componentTree) {
        ThreadUtils.assertMainThread();
        this.assertNotInMeasure();
        this.mTemporaryDetachedComponent = null;
        if (this.mComponentTree == componentTree) {
            if (this.mIsAttached) {
                this.rebind();
            }
            return;
        }
        this.mHasNewComponentTree = true;
        this.setMountStateDirty();
        if (this.mComponentTree != null) {
            if (this.mIsAttached) {
                this.mComponentTree.detach();
            }
            this.mComponentTree.clearLithoView();
        }
        this.mComponentTree = componentTree;
        if (this.mComponentTree != null) {
            this.mComponentTree.setLithoView(this);
            if (this.mIsAttached) {
                this.mComponentTree.attach();
            } else {
                this.requestLayout();
            }
        }
    }

    public void setComponent(Component component) {
        if (this.mComponentTree == null) {
            this.setComponentTree(ComponentTree.create(this.getComponentContext(), component).build());
        } else {
            this.mComponentTree.setRoot(component);
        }
    }

    public void setComponentAsync(Component component) {
        if (this.mComponentTree == null) {
            this.setComponentTree(ComponentTree.create(this.getComponentContext(), component).build());
        } else {
            this.mComponentTree.setRootAsync(component);
        }
    }

    public void rebind() {
        this.mMountState.rebind();
    }

    public void unbind() {
        this.mMountState.unbind();
    }

    void clearComponentTree() {
        ThreadUtils.assertMainThread();
        if (this.mIsAttached) {
            throw new IllegalStateException("Trying to clear the ComponentTree while attached.");
        }
        this.mComponentTree = null;
    }

    public void setHasTransientState(boolean hasTransientState) {
        if (hasTransientState) {
            if (this.mTransientStateCount == 0 && this.isIncrementalMountEnabled()) {
                Rect rect = ComponentsPools.acquireRect();
                rect.set(0, 0, this.getWidth(), this.getHeight());
                this.performIncrementalMount(rect, false);
                ComponentsPools.release(rect);
            }
            ++this.mTransientStateCount;
        } else {
            --this.mTransientStateCount;
            if (this.mTransientStateCount == 0 && this.isIncrementalMountEnabled()) {
                this.performIncrementalMount();
            }
            if (this.mTransientStateCount < 0) {
                this.mTransientStateCount = 0;
            }
        }
        super.setHasTransientState(hasTransientState);
    }

    public void offsetTopAndBottom(int offset) {
        super.offsetTopAndBottom(offset);
        this.maybePerformIncrementalMountOnView();
    }

    public void offsetLeftAndRight(int offset) {
        super.offsetLeftAndRight(offset);
        this.maybePerformIncrementalMountOnView();
    }

    public void setTranslationX(float translationX) {
        super.setTranslationX(translationX);
        this.maybePerformIncrementalMountOnView();
    }

    public void setTranslationY(float translationY) {
        super.setTranslationY(translationY);
        this.maybePerformIncrementalMountOnView();
    }

    private void maybePerformIncrementalMountOnView() {
        boolean isEmpty;
        if (!this.isIncrementalMountEnabled() || !(this.getParent() instanceof View)) {
            return;
        }
        int parentWidth = ((View)this.getParent()).getWidth();
        int parentHeight = ((View)this.getParent()).getHeight();
        int translationX = (int)this.getTranslationX();
        int translationY = (int)this.getTranslationY();
        int top = this.getTop() + translationY;
        int bottom = this.getBottom() + translationY;
        int left = this.getLeft() + translationX;
        int right = this.getRight() + translationX;
        if (left >= 0 && top >= 0 && right <= parentWidth && bottom <= parentHeight && this.mPreviousMountBounds.width() == this.getWidth() && this.mPreviousMountBounds.height() == this.getHeight()) {
            return;
        }
        Rect rect = ComponentsPools.acquireRect();
        if (ComponentsConfiguration.lithoViewIncrementalMountUsesLocalVisibleBounds) {
            isEmpty = !this.getLocalVisibleRect(rect);
        } else {
            rect.set(Math.max(0, -left), Math.max(0, -top), Math.min(right, parentWidth) - left, Math.min(bottom, parentHeight) - top);
            isEmpty = rect.isEmpty();
        }
        if (isEmpty) {
            ComponentsPools.release(rect);
            return;
        }
        this.performIncrementalMount(rect, true);
        ComponentsPools.release(rect);
    }

    private boolean checkMainThreadLayoutStateForIncrementalMount() {
        if (this.mComponentTree.getMainThreadLayoutState() != null) {
            return true;
        }
        if (!this.isLayoutRequested()) {
            throw new RuntimeException("Trying to incrementally mount a component with a null main thread LayoutState on a LithoView that hasn't requested layout!");
        }
        return false;
    }

    public void performIncrementalMount(Rect visibleRect, boolean processVisibilityOutputs) {
        if (this.mComponentTree == null || !this.checkMainThreadLayoutStateForIncrementalMount()) {
            return;
        }
        if (!this.mComponentTree.isIncrementalMountEnabled()) {
            throw new IllegalStateException("To perform incremental mounting, you need first to enable it when creating the ComponentTree.");
        }
        this.mComponentTree.mountComponent(visibleRect, processVisibilityOutputs);
    }

    public void performIncrementalMount() {
        if (this.mComponentTree == null || !this.checkMainThreadLayoutStateForIncrementalMount()) {
            return;
        }
        if (!this.mComponentTree.isIncrementalMountEnabled()) {
            throw new IllegalStateException("To perform incremental mounting, you need first to enable it when creating the ComponentTree.");
        }
        this.mComponentTree.incrementalMountComponent();
    }

    public boolean isIncrementalMountEnabled() {
        return this.mComponentTree != null && this.mComponentTree.isIncrementalMountEnabled();
    }

    public void release() {
        ThreadUtils.assertMainThread();
        if (this.mComponentTree != null) {
            this.mComponentTree.release();
            this.mComponentTree = null;
        }
    }

    void mount(LayoutState layoutState, Rect currentVisibleArea, boolean processVisibilityOutputs) {
        boolean rectNeedsRelease = false;
        if (this.mTransientStateCount > 0 && this.isIncrementalMountEnabled()) {
            if (!this.mMountState.isDirty()) {
                return;
            }
            currentVisibleArea = ComponentsPools.acquireRect();
            currentVisibleArea.set(0, 0, this.getWidth(), this.getHeight());
            rectNeedsRelease = true;
            processVisibilityOutputs = false;
        }
        if (currentVisibleArea == null) {
            this.mPreviousMountBounds.setEmpty();
        } else {
            this.mPreviousMountBounds.set(currentVisibleArea);
        }
        this.mMountState.mount(layoutState, currentVisibleArea, processVisibilityOutputs);
        if (rectNeedsRelease) {
            ComponentsPools.release(currentVisibleArea);
        }
    }

    void unmountAllItems() {
        this.mMountState.unmountAllItems();
    }

    public Rect getPreviousMountBounds() {
        return this.mPreviousMountBounds;
    }

    void setMountStateDirty() {
        this.mMountState.setDirty();
        this.mPreviousMountBounds.setEmpty();
    }

    boolean isMountStateDirty() {
        return this.mMountState.isDirty();
    }

    MountState getMountState() {
        return this.mMountState;
    }

    boolean doesOwnIncrementalMount() {
        return this.mDoesOwnIncrementalMount;
    }

    @Deprecated
    public void setDoesOwnIncrementalMount(boolean doesOwnIncrementalMount) {
        this.mDoesOwnIncrementalMount = doesOwnIncrementalMount;
        this.setDoesOwnIncrementalMountOnChildren(this, doesOwnIncrementalMount);
    }

    private void setDoesOwnIncrementalMountOnChildren(ViewGroup viewGroup, boolean doesOwnIncrementalMount) {
        int size = viewGroup.getChildCount();
        for (int i = 0; i < size; ++i) {
            View child = viewGroup.getChildAt(i);
            if (child instanceof LithoView) {
                ((LithoView)child).setDoesOwnIncrementalMount(doesOwnIncrementalMount);
            }
            if (!(child instanceof ViewGroup)) continue;
            this.setDoesOwnIncrementalMountOnChildren((ViewGroup)child, doesOwnIncrementalMount);
        }
    }

    @DoNotStrip
    @VisibleForTesting(otherwise=2)
    Deque<TestItem> findTestItems(String testKey) {
        return this.mMountState.findTestItems(testKey);
    }

    private static class AccessibilityStateChangeListener
    extends AccessibilityManagerCompat.AccessibilityStateChangeListenerCompat {
        private final WeakReference<LithoView> mLithoView;

        private AccessibilityStateChangeListener(LithoView lithoView) {
            this.mLithoView = new WeakReference<LithoView>(lithoView);
        }

        public void onAccessibilityStateChanged(boolean enabled) {
            LithoView lithoView = (LithoView)((Object)this.mLithoView.get());
            if (lithoView == null) {
                return;
            }
            lithoView.refreshAccessibilityDelegatesIfNeeded(enabled);
            lithoView.requestLayout();
        }
    }
}

