/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.view.View;
import android.widget.PopupWindow;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.LithoTooltip;
import com.facebook.litho.TooltipPosition;

public class LithoTooltipController {
    public static void showTooltip(ComponentContext c, LithoTooltip tooltip, String anchorKey, TooltipPosition tooltipPosition) {
        LithoTooltipController.showTooltip(c, tooltip, anchorKey, tooltipPosition, 0, 0);
    }

    public static void showTooltip(ComponentContext c, PopupWindow popupWindow, String anchorKey, TooltipPosition tooltipPosition) {
        LithoTooltipController.showTooltip(c, popupWindow, anchorKey, tooltipPosition, 0, 0);
    }

    public static void showTooltip(ComponentContext c, final PopupWindow popupWindow, String anchorKey, TooltipPosition tooltipPosition, int xOffset, int yOffset) {
        LithoTooltipController.showTooltip(c, new LithoTooltip(){

            @Override
            public void showBottomLeft(View anchor, int xOffset, int yOffset) {
                popupWindow.showAsDropDown(anchor, xOffset, yOffset);
            }
        }, anchorKey, tooltipPosition, xOffset, yOffset);
    }

    public static void showTooltip(ComponentContext c, LithoTooltip tooltip, String anchorKey, TooltipPosition tooltipPosition, int xOffset, int yOffset) {
        ComponentTree componentTree = c.getComponentTree();
        Component rootComponent = c.getComponentScope();
        if (componentTree == null) {
            return;
        }
        String anchorGlobalKey = rootComponent == null ? anchorKey : rootComponent.getGlobalKey() + anchorKey;
        componentTree.showTooltip(tooltip, anchorGlobalKey, tooltipPosition, xOffset, yOffset);
    }

    static void showOnAnchor(LithoTooltip tooltip, Rect anchorBounds, View hostView, TooltipPosition tooltipPosition, int xOffset, int yOffset) {
        int yoff;
        int xoff;
        int topOffset = anchorBounds.top - hostView.getHeight();
        int bottomOffset = anchorBounds.bottom - hostView.getHeight();
        int centerXOffset = anchorBounds.left + (anchorBounds.right - anchorBounds.left) / 2;
        int centerYOffset = anchorBounds.top + (anchorBounds.bottom - anchorBounds.top) / 2 - hostView.getHeight();
        switch (tooltipPosition) {
            case CENTER: {
                xoff = centerXOffset;
                yoff = centerYOffset;
                break;
            }
            case CENTER_LEFT: {
                xoff = anchorBounds.left;
                yoff = centerYOffset;
                break;
            }
            case TOP_LEFT: {
                xoff = anchorBounds.left;
                yoff = topOffset;
                break;
            }
            case CENTER_TOP: {
                xoff = centerXOffset;
                yoff = topOffset;
                break;
            }
            case TOP_RIGHT: {
                xoff = anchorBounds.right;
                yoff = topOffset;
                break;
            }
            case CENTER_RIGHT: {
                xoff = anchorBounds.right;
                yoff = centerYOffset;
                break;
            }
            case BOTTOM_RIGHT: {
                xoff = anchorBounds.right;
                yoff = bottomOffset;
                break;
            }
            case CENTER_BOTTOM: {
                xoff = centerXOffset;
                yoff = bottomOffset;
                break;
            }
            default: {
                xoff = anchorBounds.left;
                yoff = bottomOffset;
            }
        }
        tooltip.showBottomLeft(hostView, xoff + xOffset, yoff + yOffset);
    }
}

