/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.util.SparseArray;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.RecyclePool;
import java.util.ArrayList;
import java.util.List;

public final class LithoDebugInfo {
    private LithoDebugInfo() {
    }

    public static List<RecyclePool> getPools() {
        ArrayList<RecyclePool> pools = new ArrayList<RecyclePool>();
        for (SparseArray<RecyclePool> contentPools : ComponentsPools.sMountContentPoolsByContext.values()) {
            int count = contentPools.size();
            for (int i = 0; i < count; ++i) {
                pools.add((RecyclePool)contentPools.valueAt(i));
            }
        }
        pools.add(ComponentsPools.sLayoutStatePool);
        pools.add(ComponentsPools.sInternalNodePool);
        pools.add(ComponentsPools.sNodeInfoPool);
        pools.add(ComponentsPools.sViewNodeInfoPool);
        pools.add(ComponentsPools.sYogaNodePool);
        pools.add(ComponentsPools.sMountItemPool);
        pools.add(ComponentsPools.sLayoutOutputPool);
        pools.add(ComponentsPools.sVisibilityOutputPool);
        pools.add(ComponentsPools.sVisibilityItemPool);
        pools.add(ComponentsPools.sOutputPool);
        pools.add(ComponentsPools.sDiffNodePool);
        pools.add(ComponentsPools.sDiffPool);
        pools.add(ComponentsPools.sComponentTreeBuilderPool);
        pools.add(ComponentsPools.sStateHandlerPool);
        pools.add(ComponentsPools.sMountItemScrapArrayPool);
        pools.add(ComponentsPools.sTouchableScrapArrayPool);
        pools.add(ComponentsPools.sRectFPool);
        pools.add(ComponentsPools.sRectPool);
        pools.add(ComponentsPools.sEdgesPool);
        pools.add(ComponentsPools.sTransitionContextPool);
        pools.add(ComponentsPools.sDisplayListDrawablePool);
        pools.add(ComponentsPools.sTreePropsMapPool);
        pools.add(ComponentsPools.sArraySetPool);
        pools.add(ComponentsPools.sArrayDequePool);
        pools.add(ComponentsPools.sLogEventPool);
        if (ComponentsPools.sTestOutputPool != null) {
            pools.add(ComponentsPools.sTestOutputPool);
        }
        if (ComponentsPools.sTestItemPool != null) {
            pools.add(ComponentsPools.sTestItemPool);
        }
        if (ComponentsPools.sBorderColorDrawablePool != null) {
            pools.add(ComponentsPools.sBorderColorDrawablePool);
        }
        return pools;
    }
}

