/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.support.v4.util.LongSparseArray;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.VisibilityOutput;

class LayoutStateOutputIdCalculator {
    private final LongSparseArray<Integer> mLayoutCurrentSequenceForBaseId = new LongSparseArray(8);
    private final LongSparseArray<Integer> mVisibilityCurrentSequenceForBaseId = new LongSparseArray(8);
    private static final int MAX_SEQUENCE = 65535;
    private static final int MAX_LEVEL = 255;
    private static final short COMPONENT_ID_SHIFT = 26;
    private static final short LEVEL_SHIFT = 18;
    private static final short TYPE_SHIFT = 16;

    LayoutStateOutputIdCalculator() {
    }

    void calculateAndSetLayoutOutputIdAndUpdateState(LayoutOutput layoutOutput, int level, int type, long previousId, boolean isCachedOutputUpdated) {
        int layoutOutputUpdateState;
        long baseLayoutId;
        int currentSequence;
        int sequence = previousId > 0L && LayoutStateOutputIdCalculator.getLevelFromId(previousId) == level ? LayoutStateOutputIdCalculator.getSequenceFromId(previousId) : -1;
        if (sequence < (currentSequence = ((Integer)this.mLayoutCurrentSequenceForBaseId.get(baseLayoutId = LayoutStateOutputIdCalculator.calculateLayoutOutputBaseId(layoutOutput, level, type), (Object)0)).intValue())) {
            sequence = currentSequence + 1;
            layoutOutputUpdateState = 0;
        } else {
            layoutOutputUpdateState = isCachedOutputUpdated ? 1 : 2;
        }
        layoutOutput.setUpdateState(layoutOutputUpdateState);
        long layoutOutputId = LayoutStateOutputIdCalculator.calculateId(baseLayoutId, sequence);
        layoutOutput.setId(layoutOutputId);
        this.mLayoutCurrentSequenceForBaseId.put(baseLayoutId, (Object)(sequence + 1));
    }

    void calculateAndSetVisibilityOutputId(VisibilityOutput visibilityOutput, int level, long previousId) {
        long baseVisibilityId;
        int currentSequence;
        int sequence = previousId > 0L && LayoutStateOutputIdCalculator.getLevelFromId(previousId) == level ? LayoutStateOutputIdCalculator.getSequenceFromId(previousId) : -1;
        if (sequence < (currentSequence = ((Integer)this.mVisibilityCurrentSequenceForBaseId.get(baseVisibilityId = LayoutStateOutputIdCalculator.calculateVisibilityOutputBaseId(visibilityOutput, level), (Object)0)).intValue())) {
            sequence = currentSequence + 1;
        }
        long visibilityOutputId = LayoutStateOutputIdCalculator.calculateId(baseVisibilityId, sequence);
        visibilityOutput.setId(visibilityOutputId);
        this.mVisibilityCurrentSequenceForBaseId.put(baseVisibilityId, (Object)(sequence + 1));
    }

    void clear() {
        this.mLayoutCurrentSequenceForBaseId.clear();
        this.mVisibilityCurrentSequenceForBaseId.clear();
    }

    static long calculateId(long baseId, int sequence) {
        if (sequence < 0 || sequence > 65535) {
            throw new IllegalArgumentException("Sequence must be non-negative and no greater than 65535 actual sequence " + sequence);
        }
        return baseId | (long)sequence;
    }

    static long calculateLayoutOutputId(LayoutOutput layoutOutput, int level, int type, int sequence) {
        long baseId = LayoutStateOutputIdCalculator.calculateLayoutOutputBaseId(layoutOutput, level, type);
        return LayoutStateOutputIdCalculator.calculateId(baseId, sequence);
    }

    static long calculateVisibilityOutputId(VisibilityOutput visibilityOutput, int level, int sequence) {
        long baseId = LayoutStateOutputIdCalculator.calculateVisibilityOutputBaseId(visibilityOutput, level);
        return LayoutStateOutputIdCalculator.calculateId(baseId, sequence);
    }

    static int getSequenceFromId(long id2) {
        return (int)id2 & 0xFFFF;
    }

    static int getLevelFromId(long id2) {
        return (int)(id2 >> 18 & 0xFFL);
    }

    private static long calculateLayoutOutputBaseId(LayoutOutput layoutOutput, int level, int type) {
        if (level < 0 || level > 255) {
            throw new IllegalArgumentException("Level must be non-negative and no greater than 255 actual level " + level);
        }
        long componentId = layoutOutput.getComponent() != null ? (long)((ComponentLifecycle)layoutOutput.getComponent().getLifecycle()).getTypeId() : 0L;
        long componentShifted = componentId << 26;
        long levelShifted = (long)level << 18;
        long typeShifted = (long)type << 16;
        return 0L | componentShifted | levelShifted | typeShifted;
    }

    private static long calculateVisibilityOutputBaseId(VisibilityOutput visibilityOutput, int level) {
        if (level < 0 || level > 255) {
            throw new IllegalArgumentException("Level must be non-negative and no greater than 255 actual level " + level);
        }
        long componentId = visibilityOutput.getComponent() != null ? (long)((ComponentLifecycle)visibilityOutput.getComponent().getLifecycle()).getTypeId() : 0L;
        long componentShifted = componentId << 26;
        long levelShifted = (long)level << 18;
        return 0L | componentShifted | levelShifted;
    }
}

