/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.LongSparseArray;
import android.support.v4.util.SimpleArrayMap;
import android.support.v4.view.accessibility.AccessibilityManagerCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.view.accessibility.AccessibilityManager;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.Border;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.ContextUtils;
import com.facebook.litho.DiffNode;
import com.facebook.litho.DisplayListPrefetcher;
import com.facebook.litho.DrawableComponent;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FastMath;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.HostComponent;
import com.facebook.litho.InternalNode;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LayoutStateOutputIdCalculator;
import com.facebook.litho.LogEvent;
import com.facebook.litho.MeasureComparisonUtils;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.StateHandler;
import com.facebook.litho.TestOutput;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.Transition;
import com.facebook.litho.TransitionContext;
import com.facebook.litho.TransitionUtils;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.litho.VisibilityOutput;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.displaylist.DisplayList;
import com.facebook.litho.displaylist.DisplayListException;
import com.facebook.litho.reference.BorderColorDrawableReference;
import com.facebook.litho.reference.DrawableReference;
import com.facebook.litho.reference.Reference;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

class LayoutState {
    static final Comparator<LayoutOutput> sTopsComparator = new Comparator<LayoutOutput>(){

        @Override
        public int compare(LayoutOutput lhs, LayoutOutput rhs) {
            int lhsTop = lhs.getBounds().top;
            int rhsTop = rhs.getBounds().top;
            return lhsTop < rhsTop ? -1 : (lhsTop > rhsTop ? 1 : (Component.isHostSpec(lhs.getComponent()) == Component.isHostSpec(rhs.getComponent()) ? 0 : (Component.isHostSpec(lhs.getComponent()) ? -1 : 1)));
        }
    };
    static final Comparator<LayoutOutput> sBottomsComparator = new Comparator<LayoutOutput>(){

        @Override
        public int compare(LayoutOutput lhs, LayoutOutput rhs) {
            int lhsBottom = lhs.getBounds().bottom;
            int rhsBottom = rhs.getBounds().bottom;
            return lhsBottom < rhsBottom ? -1 : (lhsBottom > rhsBottom ? 1 : (Component.isHostSpec(lhs.getComponent()) == Component.isHostSpec(rhs.getComponent()) ? 0 : (Component.isHostSpec(lhs.getComponent()) ? 1 : -1)));
        }
    };
    private final Map<String, Rect> mComponentKeyToBounds = new HashMap<String, Rect>();
    private final List<Component> mComponents = new ArrayList<Component>();
    @ThreadConfined(value="UI")
    private final Rect mDisplayListCreateRect = new Rect();
    @ThreadConfined(value="ANY")
    private final Rect mDisplayListQueueRect = new Rect();
    private static final int[] DRAWABLE_STATE_ENABLED = new int[]{16842910};
    private static final int[] DRAWABLE_STATE_NOT_ENABLED = new int[0];
    private volatile ComponentContext mContext;
    private TransitionContext mTransitionContext;
    private Component<?> mComponent;
    private int mWidthSpec;
    private int mHeightSpec;
    private final List<LayoutOutput> mMountableOutputs = new ArrayList<LayoutOutput>(8);
    private final List<VisibilityOutput> mVisibilityOutputs = new ArrayList<VisibilityOutput>(8);
    private final LongSparseArray<Integer> mOutputsIdToPositionMap = new LongSparseArray(8);
    private final LayoutStateOutputIdCalculator mLayoutStateOutputIdCalculator;
    private final ArrayList<LayoutOutput> mMountableOutputTops = new ArrayList();
    private final ArrayList<LayoutOutput> mMountableOutputBottoms = new ArrayList();
    private final Queue<Integer> mDisplayListsToPrefetch = new LinkedList<Integer>();
    private List<TestOutput> mTestOutputs;
    private InternalNode mLayoutRoot;
    private DiffNode mDiffTreeRoot;
    private final AtomicInteger mReferenceCount = new AtomicInteger(-1);
    private int mWidth;
    private int mHeight;
    private int mCurrentX;
    private int mCurrentY;
    private int mCurrentLevel = 0;
    private long mCurrentHostMarker = -1L;
    private int mCurrentHostOutputPosition = -1;
    private boolean mShouldDuplicateParentState = true;
    private boolean mIsTransitionKeySet = false;
    private int mParentEnabledState = 0;
    private boolean mShouldGenerateDiffTree = false;
    private int mComponentTreeId = -1;
    private AccessibilityManager mAccessibilityManager;
    private boolean mAccessibilityEnabled = false;
    private StateHandler mStateHandler;
    private boolean mCanPrefetchDisplayLists;
    private boolean mCanCacheDrawingDisplayLists;
    private boolean mClipChildren = true;
    private ArrayList<Component> mComponentsNeedingPreviousRenderData;
    private SimpleArrayMap<String, LayoutOutput> mTransitionKeyMapping;
    private boolean mHasLithoViewBoundsAnimation = false;

    LayoutState() {
        this.mLayoutStateOutputIdCalculator = new LayoutStateOutputIdCalculator();
    }

    void init(ComponentContext context) {
        this.mContext = context;
        this.mStateHandler = this.mContext.getStateHandler();
        this.mReferenceCount.set(1);
        this.mTestOutputs = ComponentsConfiguration.isEndToEndTestRun ? new ArrayList(8) : null;
    }

    @Nullable
    private static LayoutOutput createGenericLayoutOutput(InternalNode node, LayoutState layoutState) {
        Component component = node.getRootComponent();
        if (component == null || ((ComponentLifecycle)component.getLifecycle()).getMountType() == ComponentLifecycle.MountType.NONE) {
            return null;
        }
        return LayoutState.createLayoutOutput(component, layoutState, node, true, node.getImportantForAccessibility(), layoutState.mShouldDuplicateParentState, layoutState.mIsTransitionKeySet);
    }

    private static LayoutOutput createHostLayoutOutput(LayoutState layoutState, InternalNode node) {
        LayoutOutput hostOutput = LayoutState.createLayoutOutput(HostComponent.create(), layoutState, node, false, node.getImportantForAccessibility(), node.isDuplicateParentStateEnabled(), layoutState.mIsTransitionKeySet);
        hostOutput.getViewNodeInfo().setTransitionKey(node.getTransitionKey());
        return hostOutput;
    }

    private static LayoutOutput createDrawableLayoutOutput(Component<?> component, LayoutState layoutState, InternalNode node) {
        return LayoutState.createLayoutOutput(component, layoutState, node, false, 2, layoutState.mShouldDuplicateParentState, layoutState.mIsTransitionKeySet);
    }

    private static LayoutOutput createLayoutOutput(Component<?> component, LayoutState layoutState, InternalNode node, boolean useNodePadding, int importantForAccessibility, boolean duplicateParentState, boolean isTransitionKeySet) {
        int paddingBottom;
        boolean isMountViewSpec = Component.isMountViewSpec(component);
        LayoutOutput layoutOutput = ComponentsPools.acquireLayoutOutput();
        layoutOutput.setComponent(component);
        layoutOutput.setImportantForAccessibility(importantForAccessibility);
        layoutOutput.setHostMarker(layoutState.mCurrentHostMarker);
        if (layoutState.mCurrentHostOutputPosition >= 0) {
            LayoutOutput hostOutput = layoutState.mMountableOutputs.get(layoutState.mCurrentHostOutputPosition);
            Rect hostBounds = hostOutput.getBounds();
            layoutOutput.setHostTranslationX(hostBounds.left);
            layoutOutput.setHostTranslationY(hostBounds.top);
        }
        int flags = 0;
        int l = layoutState.mCurrentX + node.getX();
        int t = layoutState.mCurrentY + node.getY();
        int r = l + node.getWidth();
        int b = t + node.getHeight();
        int paddingLeft = useNodePadding ? node.getPaddingLeft() : 0;
        int paddingTop = useNodePadding ? node.getPaddingTop() : 0;
        int paddingRight = useNodePadding ? node.getPaddingRight() : 0;
        int n = paddingBottom = useNodePadding ? node.getPaddingBottom() : 0;
        if (isMountViewSpec) {
            layoutOutput.setNodeInfo(node.getNodeInfo());
            ViewNodeInfo viewNodeInfo = ViewNodeInfo.acquire();
            viewNodeInfo.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            viewNodeInfo.setLayoutDirection(node.getResolvedLayoutDirection());
            viewNodeInfo.setExpandedTouchBounds(node, l, t, r, b);
            viewNodeInfo.setClipChildren(layoutState.mClipChildren);
            layoutOutput.setViewNodeInfo(viewNodeInfo);
            viewNodeInfo.release();
        } else {
            l += paddingLeft;
            t += paddingTop;
            r -= paddingRight;
            b -= paddingBottom;
            if (node.getNodeInfo() != null && node.getNodeInfo().getEnabledState() == 2) {
                flags |= 2;
            }
        }
        layoutOutput.setBounds(l, t, r, b);
        if (duplicateParentState) {
            flags |= 1;
        }
        if (isTransitionKeySet) {
            flags |= 0x40;
        }
        layoutOutput.setFlags(flags);
        Object lifecycle = component.getLifecycle();
        if (LayoutState.isEligibleForCreatingDisplayLists() && ((ComponentLifecycle)lifecycle).shouldUseDisplayList()) {
            layoutOutput.initDisplayListContainer(lifecycle.getClass().getSimpleName(), layoutState.mCanCacheDrawingDisplayLists);
        }
        return layoutOutput;
    }

    private static VisibilityOutput createVisibilityOutput(InternalNode node, LayoutState layoutState) {
        int l = layoutState.mCurrentX + node.getX();
        int t = layoutState.mCurrentY + node.getY();
        int r = l + node.getWidth();
        int b = t + node.getHeight();
        EventHandler<VisibleEvent> visibleHandler = node.getVisibleHandler();
        EventHandler<FocusedVisibleEvent> focusedHandler = node.getFocusedHandler();
        EventHandler<UnfocusedVisibleEvent> unfocusedHandler = node.getUnfocusedHandler();
        EventHandler<FullImpressionVisibleEvent> fullImpressionHandler = node.getFullImpressionHandler();
        EventHandler<InvisibleEvent> invisibleHandler = node.getInvisibleHandler();
        VisibilityOutput visibilityOutput = ComponentsPools.acquireVisibilityOutput();
        visibilityOutput.setComponent(node.getRootComponent());
        visibilityOutput.setBounds(l, t, r, b);
        visibilityOutput.setVisibleHeightRatio(node.getVisibleHeightRatio());
        visibilityOutput.setVisibleWidthRatio(node.getVisibleWidthRatio());
        visibilityOutput.setVisibleEventHandler(visibleHandler);
        visibilityOutput.setFocusedEventHandler(focusedHandler);
        visibilityOutput.setUnfocusedEventHandler(unfocusedHandler);
        visibilityOutput.setFullImpressionEventHandler(fullImpressionHandler);
        visibilityOutput.setInvisibleEventHandler(invisibleHandler);
        return visibilityOutput;
    }

    private static TestOutput createTestOutput(InternalNode node, LayoutState layoutState, LayoutOutput layoutOutput) {
        int l = layoutState.mCurrentX + node.getX();
        int t = layoutState.mCurrentY + node.getY();
        int r = l + node.getWidth();
        int b = t + node.getHeight();
        TestOutput output = ComponentsPools.acquireTestOutput();
        output.setTestKey(node.getTestKey());
        output.setBounds(l, t, r, b);
        output.setHostMarker(layoutState.mCurrentHostMarker);
        if (layoutOutput != null) {
            output.setLayoutOutputId(layoutOutput.getId());
        }
        return output;
    }

    private static boolean isLayoutDirectionRTL(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (Build.VERSION.SDK_INT >= 17 && (applicationInfo.flags & 0x400000) != 0) {
            int layoutDirection = LayoutState.getLayoutDirection(context);
            return layoutDirection == 1;
        }
        return false;
    }

    @TargetApi(value=17)
    private static int getLayoutDirection(Context context) {
        return context.getResources().getConfiguration().getLayoutDirection();
    }

    private static boolean hasViewContent(InternalNode node, LayoutState layoutState) {
        Component component = node.getRootComponent();
        NodeInfo nodeInfo = node.getNodeInfo();
        boolean implementsAccessibility = nodeInfo != null && nodeInfo.hasAccessibilityHandlers() || component != null && ((ComponentLifecycle)component.getLifecycle()).implementsAccessibility();
        int importantForAccessibility = node.getImportantForAccessibility();
        boolean hasAccessibilityContent = layoutState.mAccessibilityEnabled && importantForAccessibility != 2 && (implementsAccessibility || nodeInfo != null && !TextUtils.isEmpty((CharSequence)nodeInfo.getContentDescription()) || importantForAccessibility != 0);
        boolean hasFocusChangeHandler = nodeInfo != null && nodeInfo.hasFocusChangeHandler();
        boolean hasEnabledTouchEventHandlers = nodeInfo != null && nodeInfo.hasTouchEventHandlers() && nodeInfo.getEnabledState() != 2;
        boolean hasViewTag = nodeInfo != null && nodeInfo.getViewTag() != null;
        boolean hasViewTags = nodeInfo != null && nodeInfo.getViewTags() != null;
        boolean hasShadowElevation = nodeInfo != null && nodeInfo.getShadowElevation() != 0.0f;
        boolean hasOutlineProvider = nodeInfo != null && nodeInfo.getOutlineProvider() != null;
        boolean hasClipToOutline = nodeInfo != null && nodeInfo.getClipToOutline();
        boolean isFocusableSetTrue = nodeInfo != null && nodeInfo.getFocusState() == 1;
        return hasFocusChangeHandler || hasEnabledTouchEventHandlers || hasViewTag || hasViewTags || hasShadowElevation || hasOutlineProvider || hasClipToOutline || hasAccessibilityContent || isFocusableSetTrue;
    }

    private static void collectResults(InternalNode node, LayoutState layoutState, DiffNode parentDiffNode) {
        Reference<? extends Drawable> background;
        DiffNode diffNode;
        if (node.hasNewLayout()) {
            node.markLayoutSeen();
        }
        Component component = node.getRootComponent();
        if (node.isNestedTreeHolder()) {
            InternalNode nestedTree = LayoutState.resolveNestedTree(node, SizeSpec.makeSizeSpec(node.getWidth(), 0x40000000), SizeSpec.makeSizeSpec(node.getHeight(), 0x40000000));
            if (nestedTree == ComponentContext.NULL_LAYOUT) {
                return;
            }
            layoutState.mCurrentX += node.getX();
            layoutState.mCurrentY += node.getY();
            LayoutState.collectResults(nestedTree, layoutState, parentDiffNode);
            layoutState.mCurrentX -= node.getX();
            layoutState.mCurrentY -= node.getY();
            return;
        }
        boolean shouldGenerateDiffTree = layoutState.mShouldGenerateDiffTree;
        DiffNode currentDiffNode = node.getDiffNode();
        boolean shouldUseCachedOutputs = Component.isMountSpec(component) && currentDiffNode != null;
        boolean isCachedOutputUpdated = shouldUseCachedOutputs && node.areCachedMeasuresValid();
        boolean isTransitionKeySet = layoutState.mIsTransitionKeySet;
        layoutState.mIsTransitionKeySet = false;
        if (shouldGenerateDiffTree) {
            diffNode = LayoutState.createDiffNode(node, parentDiffNode);
            if (parentDiffNode == null) {
                layoutState.mDiffTreeRoot = diffNode;
            }
        } else {
            diffNode = null;
        }
        if (layoutState.mParentEnabledState == 2) {
            node.enabled(false);
        }
        boolean needsHostView = LayoutState.needsHostView(node, layoutState);
        long currentHostMarker = layoutState.mCurrentHostMarker;
        int currentHostOutputPosition = layoutState.mCurrentHostOutputPosition;
        int hostLayoutPosition = -1;
        if (needsHostView) {
            layoutState.mIsTransitionKeySet = !TextUtils.isEmpty((CharSequence)node.getTransitionKey());
            hostLayoutPosition = LayoutState.addHostLayoutOutput(node, layoutState, diffNode);
            ++layoutState.mCurrentLevel;
            layoutState.mCurrentHostMarker = layoutState.mMountableOutputs.get(hostLayoutPosition).getId();
            layoutState.mCurrentHostOutputPosition = hostLayoutPosition;
        }
        boolean shouldDuplicateParentState = layoutState.mShouldDuplicateParentState;
        layoutState.mShouldDuplicateParentState = needsHostView || shouldDuplicateParentState && node.isDuplicateParentStateEnabled();
        LayoutOutput layoutOutput = LayoutState.createGenericLayoutOutput(node, layoutState);
        if (layoutOutput != null) {
            long previousId = shouldUseCachedOutputs ? currentDiffNode.getContent().getId() : -1L;
            layoutState.mLayoutStateOutputIdCalculator.calculateAndSetLayoutOutputIdAndUpdateState(layoutOutput, layoutState.mCurrentLevel, 0, previousId, isCachedOutputUpdated);
        }
        if (ThreadUtils.isMainThread() && isCachedOutputUpdated) {
            layoutOutput.setDisplayListContainer(currentDiffNode.getContent().getDisplayListContainer());
        }
        if ((background = node.getBackground()) != null) {
            if (layoutOutput != null && layoutOutput.hasViewNodeInfo()) {
                layoutOutput.getViewNodeInfo().setBackground(background);
            } else {
                LayoutOutput convertBackground = currentDiffNode != null ? currentDiffNode.getBackground() : null;
                LayoutOutput backgroundOutput = LayoutState.addDrawableComponent(node, layoutState, convertBackground, background, 1);
                if (diffNode != null) {
                    diffNode.setBackground(backgroundOutput);
                }
            }
        }
        if (Component.isMountSpec(component)) {
            ((ComponentLifecycle)component.getLifecycle()).onBoundsDefined(layoutState.mContext, node, component);
            LayoutState.addMountableOutput(layoutState, layoutOutput);
            LayoutState.addLayoutOutputIdToPositionsMap(layoutState.mOutputsIdToPositionMap, layoutOutput, layoutState.mMountableOutputs.size() - 1);
            if (diffNode != null) {
                diffNode.setContent(layoutOutput);
            }
        }
        if (node.shouldDrawBorders()) {
            LayoutOutput convertBorder = currentDiffNode != null ? currentDiffNode.getBorder() : null;
            LayoutOutput borderOutput = LayoutState.addDrawableComponent(node, layoutState, convertBorder, LayoutState.getBorderColorDrawable(node), 4);
            if (diffNode != null) {
                diffNode.setBorder(borderOutput);
            }
        }
        if (Build.VERSION.SDK_INT >= 14 && component != null) {
            Object lifecycle = component.getLifecycle();
            if (!((ComponentLifecycle)lifecycle).needsPreviousRenderData()) {
                Transition transition = ((ComponentLifecycle)component.getLifecycle()).onCreateTransition(layoutState.mContext, component);
                if (transition != null) {
                    layoutState.getOrCreateTransitionContext().addTransition(transition);
                    if (!layoutState.mHasLithoViewBoundsAnimation && layoutState.mLayoutRoot.hasTransitionKey()) {
                        layoutState.mHasLithoViewBoundsAnimation = TransitionUtils.hasBoundsAnimation(layoutState.mLayoutRoot.getTransitionKey(), transition);
                    }
                }
            } else {
                if (layoutState.mComponentsNeedingPreviousRenderData == null) {
                    layoutState.mComponentsNeedingPreviousRenderData = new ArrayList();
                }
                layoutState.mComponentsNeedingPreviousRenderData.add(component);
            }
        }
        layoutState.mCurrentX += node.getX();
        layoutState.mCurrentY += node.getY();
        int parentEnabledState = layoutState.mParentEnabledState;
        layoutState.mParentEnabledState = node.getNodeInfo() != null ? (int)node.getNodeInfo().getEnabledState() : 0;
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            LayoutState.collectResults(node.getChildAt(i), layoutState, diffNode);
        }
        layoutState.mParentEnabledState = parentEnabledState;
        layoutState.mCurrentX -= node.getX();
        layoutState.mCurrentY -= node.getY();
        Drawable foreground = node.getForeground();
        if (foreground != null) {
            if (layoutOutput != null && layoutOutput.hasViewNodeInfo() && Build.VERSION.SDK_INT >= 23) {
                layoutOutput.getViewNodeInfo().setForeground(foreground);
            } else {
                LayoutOutput convertForeground = currentDiffNode != null ? currentDiffNode.getForeground() : null;
                LayoutOutput foregroundOutput = LayoutState.addDrawableComponent(node, layoutState, convertForeground, DrawableReference.create().drawable(foreground).build(), 2);
                if (diffNode != null) {
                    diffNode.setForeground(foregroundOutput);
                }
            }
        }
        if (node.hasVisibilityHandlers()) {
            VisibilityOutput visibilityOutput = LayoutState.createVisibilityOutput(node, layoutState);
            long previousId = shouldUseCachedOutputs && currentDiffNode.getVisibilityOutput() != null ? currentDiffNode.getVisibilityOutput().getId() : -1L;
            layoutState.mLayoutStateOutputIdCalculator.calculateAndSetVisibilityOutputId(visibilityOutput, layoutState.mCurrentLevel, previousId);
            layoutState.mVisibilityOutputs.add(visibilityOutput);
            if (diffNode != null) {
                diffNode.setVisibilityOutput(visibilityOutput);
            }
        }
        if (layoutState.mTestOutputs != null && !TextUtils.isEmpty((CharSequence)node.getTestKey())) {
            TestOutput testOutput = LayoutState.createTestOutput(node, layoutState, layoutOutput);
            layoutState.mTestOutputs.add(testOutput);
        }
        if (component != null && component.getScopedContext() != null && component.getScopedContext().getComponentTree() != null) {
            layoutState.mComponents.add(component);
        }
        if (component != null) {
            Rect rect = ComponentsPools.acquireRect();
            if (layoutOutput != null) {
                rect.set(layoutOutput.getBounds());
            } else {
                rect.left = layoutState.mCurrentX + node.getX();
                rect.top = layoutState.mCurrentY + node.getY();
                rect.right = rect.left + node.getWidth();
                rect.bottom = rect.top + node.getHeight();
            }
            layoutState.mComponentKeyToBounds.put(component.getGlobalKey(), rect);
        }
        if (layoutState.mCurrentHostMarker != currentHostMarker) {
            layoutState.mCurrentHostMarker = currentHostMarker;
            layoutState.mCurrentHostOutputPosition = currentHostOutputPosition;
            --layoutState.mCurrentLevel;
        }
        layoutState.mShouldDuplicateParentState = shouldDuplicateParentState;
        layoutState.mIsTransitionKeySet = isTransitionKeySet;
    }

    Map<String, Rect> getComponentKeyToBounds() {
        return this.mComponentKeyToBounds;
    }

    List<Component> getComponents() {
        return this.mComponents;
    }

    void clearComponents() {
        this.mComponents.clear();
    }

    private static void calculateAndSetHostOutputIdAndUpdateState(InternalNode node, LayoutOutput hostOutput, LayoutState layoutState, boolean isCachedOutputUpdated) {
        if (layoutState.isLayoutRoot(node)) {
            hostOutput.setId(0L);
            hostOutput.setHostMarker(0L);
            hostOutput.setUpdateState(2);
        } else {
            layoutState.mLayoutStateOutputIdCalculator.calculateAndSetLayoutOutputIdAndUpdateState(hostOutput, layoutState.mCurrentLevel, 3, -1L, isCachedOutputUpdated);
        }
    }

    private static LayoutOutput addDrawableComponent(InternalNode node, LayoutState layoutState, LayoutOutput recycle, Reference<? extends Drawable> reference, int type) {
        Component drawableComponent = DrawableComponent.create(reference);
        drawableComponent.setScopedContext(ComponentContext.withComponentScope(node.getContext(), drawableComponent));
        boolean isOutputUpdated = recycle != null ? !((DrawableComponent)drawableComponent.getLifecycle()).shouldComponentUpdate(recycle.getComponent(), drawableComponent) : false;
        long previousId = recycle != null ? recycle.getId() : -1L;
        LayoutOutput output = LayoutState.addDrawableLayoutOutput(drawableComponent, layoutState, node, type, previousId, isOutputUpdated);
        return output;
    }

    private static Reference<? extends Drawable> getBorderColorDrawable(InternalNode node) {
        if (!node.shouldDrawBorders()) {
            throw new RuntimeException("This node does not support drawing border color");
        }
        YogaNode yogaNode = node.mYogaNode;
        boolean isRtl = LayoutState.resolveLayoutDirection(yogaNode) == YogaDirection.RTL;
        int[] borderColors = node.getBorderColors();
        YogaEdge leftEdge = isRtl ? YogaEdge.RIGHT : YogaEdge.LEFT;
        YogaEdge rightEdge = isRtl ? YogaEdge.LEFT : YogaEdge.RIGHT;
        return BorderColorDrawableReference.create(node.getContext()).pathEffect(node.getBorderPathEffect()).borderLeftColor(Border.getEdgeColor(borderColors, leftEdge)).borderTopColor(Border.getEdgeColor(borderColors, YogaEdge.TOP)).borderRightColor(Border.getEdgeColor(borderColors, rightEdge)).borderBottomColor(Border.getEdgeColor(borderColors, YogaEdge.BOTTOM)).borderLeftWidth(FastMath.round(yogaNode.getLayoutBorder(leftEdge))).borderTopWidth(FastMath.round(yogaNode.getLayoutBorder(YogaEdge.TOP))).borderRightWidth(FastMath.round(yogaNode.getLayoutBorder(rightEdge))).borderBottomWidth(FastMath.round(yogaNode.getLayoutBorder(YogaEdge.BOTTOM))).build();
    }

    private static YogaDirection resolveLayoutDirection(YogaNode node) {
        while (node != null && node.getLayoutDirection() == YogaDirection.INHERIT) {
            node = node.getParent();
        }
        return node == null ? YogaDirection.INHERIT : node.getLayoutDirection();
    }

    private static void addLayoutOutputIdToPositionsMap(LongSparseArray outputsIdToPositionMap, LayoutOutput layoutOutput, int position) {
        if (outputsIdToPositionMap != null) {
            outputsIdToPositionMap.put(layoutOutput.getId(), (Object)position);
        }
    }

    private static LayoutOutput addDrawableLayoutOutput(Component<DrawableComponent> drawableComponent, LayoutState layoutState, InternalNode node, int layoutOutputType, long previousId, boolean isCachedOutputUpdated) {
        drawableComponent.getLifecycle().onBoundsDefined(layoutState.mContext, node, drawableComponent);
        LayoutOutput drawableLayoutOutput = LayoutState.createDrawableLayoutOutput(drawableComponent, layoutState, node);
        layoutState.mLayoutStateOutputIdCalculator.calculateAndSetLayoutOutputIdAndUpdateState(drawableLayoutOutput, layoutState.mCurrentLevel, layoutOutputType, previousId, isCachedOutputUpdated);
        LayoutState.addMountableOutput(layoutState, drawableLayoutOutput);
        LayoutState.addLayoutOutputIdToPositionsMap(layoutState.mOutputsIdToPositionMap, drawableLayoutOutput, layoutState.mMountableOutputs.size() - 1);
        return drawableLayoutOutput;
    }

    static void releaseNodeTree(InternalNode node, boolean isNestedTree) {
        if (node == ComponentContext.NULL_LAYOUT) {
            throw new IllegalArgumentException("Cannot release a null node tree");
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            InternalNode child = node.getChildAt(i);
            if (isNestedTree && node.hasNewLayout()) {
                node.markLayoutSeen();
            }
            node.removeChildAt(i);
            LayoutState.releaseNodeTree(child, isNestedTree);
        }
        if (node.hasNestedTree() && node.getNestedTree() != ComponentContext.NULL_LAYOUT) {
            LayoutState.releaseNodeTree(node.getNestedTree(), true);
        }
        node.release();
    }

    private static int addHostLayoutOutput(InternalNode node, LayoutState layoutState, DiffNode diffNode) {
        Component component = node.getRootComponent();
        if (Component.isMountViewSpec(component) && !layoutState.isLayoutRoot(node)) {
            throw new IllegalArgumentException("We shouldn't insert a host as a parent of a View");
        }
        LayoutOutput hostLayoutOutput = LayoutState.createHostLayoutOutput(layoutState, node);
        LayoutState.addMountableOutput(layoutState, hostLayoutOutput);
        int hostOutputPosition = layoutState.mMountableOutputs.size() - 1;
        if (diffNode != null) {
            diffNode.setHost(hostLayoutOutput);
        }
        LayoutState.calculateAndSetHostOutputIdAndUpdateState(node, hostLayoutOutput, layoutState, false);
        LayoutState.addLayoutOutputIdToPositionsMap(layoutState.mOutputsIdToPositionMap, hostLayoutOutput, hostOutputPosition);
        return hostOutputPosition;
    }

    static <T extends ComponentLifecycle> LayoutState calculate(ComponentContext c, Component<T> component, int componentTreeId, int widthSpec, int heightSpec) {
        return LayoutState.calculate(c, component, componentTreeId, widthSpec, heightSpec, false, null, false, false, true);
    }

    static <T extends ComponentLifecycle> LayoutState calculate(ComponentContext c, Component<T> component, int componentTreeId, int widthSpec, int heightSpec, boolean shouldGenerateDiffTree, DiffNode previousDiffTreeRoot, boolean canPrefetchDisplayLists, boolean canCacheDrawingDisplayLists, boolean clipChildren) {
        Activity activity;
        component.markLayoutStarted();
        LayoutState layoutState = ComponentsPools.acquireLayoutState(c);
        layoutState.clearComponents();
        layoutState.mShouldGenerateDiffTree = shouldGenerateDiffTree;
        layoutState.mComponentTreeId = componentTreeId;
        layoutState.mAccessibilityManager = (AccessibilityManager)c.getSystemService("accessibility");
        layoutState.mAccessibilityEnabled = LayoutState.isAccessibilityEnabled(layoutState.mAccessibilityManager);
        layoutState.mComponent = component;
        layoutState.mWidthSpec = widthSpec;
        layoutState.mHeightSpec = heightSpec;
        layoutState.mCanPrefetchDisplayLists = canPrefetchDisplayLists;
        layoutState.mCanCacheDrawingDisplayLists = canCacheDrawingDisplayLists;
        layoutState.mClipChildren = clipChildren;
        component.applyStateUpdates(c);
        InternalNode root = LayoutState.createAndMeasureTreeForComponent(component.getScopedContext(), component, null, widthSpec, heightSpec, previousDiffTreeRoot);
        switch (SizeSpec.getMode(widthSpec)) {
            case 0x40000000: {
                layoutState.mWidth = SizeSpec.getSize(widthSpec);
                break;
            }
            case -2147483648: {
                layoutState.mWidth = Math.min(root.getWidth(), SizeSpec.getSize(widthSpec));
                break;
            }
            case 0: {
                layoutState.mWidth = root.getWidth();
            }
        }
        switch (SizeSpec.getMode(heightSpec)) {
            case 0x40000000: {
                layoutState.mHeight = SizeSpec.getSize(heightSpec);
                break;
            }
            case -2147483648: {
                layoutState.mHeight = Math.min(root.getHeight(), SizeSpec.getSize(heightSpec));
                break;
            }
            case 0: {
                layoutState.mHeight = root.getHeight();
            }
        }
        layoutState.mLayoutStateOutputIdCalculator.clear();
        layoutState.mCurrentHostMarker = -1L;
        ComponentsLogger logger = c.getLogger();
        if (root == ComponentContext.NULL_LAYOUT) {
            return layoutState;
        }
        layoutState.mLayoutRoot = root;
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("collectResults:" + component.getSimpleName());
        }
        LogEvent collectResultsEvent = null;
        if (logger != null) {
            collectResultsEvent = logger.newPerformanceEvent(2);
            collectResultsEvent.addParam("log_tag", c.getLogTag());
        }
        LayoutState.collectResults(root, layoutState, null);
        Collections.sort(layoutState.mMountableOutputTops, sTopsComparator);
        Collections.sort(layoutState.mMountableOutputBottoms, sBottomsComparator);
        if (logger != null) {
            logger.log(collectResultsEvent);
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        if (!ComponentsConfiguration.isDebugModeEnabled && !ComponentsConfiguration.persistInternalNodeTree && layoutState.mLayoutRoot != null) {
            LayoutState.releaseNodeTree(layoutState.mLayoutRoot, false);
            layoutState.mLayoutRoot = null;
        }
        if ((activity = ContextUtils.getValidActivityForContext((Context)c)) != null && LayoutState.isEligibleForCreatingDisplayLists()) {
            if (ThreadUtils.isMainThread() && !layoutState.mCanPrefetchDisplayLists && LayoutState.canCollectDisplayListsSync(activity)) {
                LayoutState.collectDisplayLists(layoutState);
            } else if (layoutState.mCanPrefetchDisplayLists) {
                LayoutState.queueDisplayListsForPrefetch(layoutState);
            }
        }
        return layoutState;
    }

    @ThreadSafe(enableChecks=false)
    void preAllocateMountContent() {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("preAllocateMountContent:" + this.mComponent.getSimpleName());
        }
        if (this.mMountableOutputs != null && !this.mMountableOutputs.isEmpty()) {
            int size = this.mMountableOutputs.size();
            for (int i = 0; i < size; ++i) {
                Component<?> component = this.mMountableOutputs.get(i).getComponent();
                if (!Component.isMountViewSpec(component)) continue;
                if (isTracing) {
                    ComponentsSystrace.beginSection("preAllocateMountContent:" + component.getSimpleName());
                }
                ((ComponentLifecycle)component.getLifecycle()).preAllocateMountContent(this.mContext);
                if (!isTracing) continue;
                ComponentsSystrace.endSection();
            }
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    private static void collectDisplayLists(LayoutState layoutState) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("collectDisplayLists:" + layoutState.mComponent.getSimpleName());
        }
        Rect rect = layoutState.mDisplayListCreateRect;
        int count = layoutState.getMountableOutputCount();
        for (int i = 0; i < count; ++i) {
            LayoutOutput output = layoutState.getMountableOutputAt(i);
            if (!LayoutState.shouldCreateDisplayList(output, rect)) continue;
            layoutState.createDisplayList(output);
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    private static boolean shouldCreateDisplayList(LayoutOutput output, Rect rect) {
        Component<?> component = output.getComponent();
        Object lifecycle = component.getLifecycle();
        if (!((ComponentLifecycle)lifecycle).shouldUseDisplayList()) {
            return false;
        }
        output.getMountBounds(rect);
        if (!output.hasValidDisplayList()) {
            return true;
        }
        DisplayList displayList = output.getDisplayList();
        try {
            displayList.setBounds(rect.left, rect.top, rect.right, rect.bottom);
            return false;
        }
        catch (DisplayListException displayListException) {
            return true;
        }
    }

    private static boolean canCollectDisplayListsSync(Activity activity) {
        Window window = activity.getWindow();
        if (window == null) {
            return false;
        }
        View decorView = window.getDecorView();
        return decorView != null && decorView.getDrawingTime() != 0L;
    }

    boolean isActivityValid() {
        return ContextUtils.getValidActivityForContext((Context)this.mContext) != null;
    }

    void createDisplayList(LayoutOutput output) {
        NodeInfo nodeInfo;
        Object lifecycle;
        DisplayList displayList;
        ThreadUtils.assertMainThread();
        ComponentContext context = this.mContext;
        if (context == null) {
            return;
        }
        Component<?> component = output.getComponent();
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("createDisplayList: " + component.getSimpleName());
        }
        if ((displayList = DisplayList.createDisplayList((lifecycle = component.getLifecycle()).getClass().getSimpleName())) == null) {
            ComponentsSystrace.endSection();
            return;
        }
        Drawable drawable = (Drawable)ComponentsPools.acquireMountContent((Context)context, ((ComponentLifecycle)lifecycle).getTypeId());
        if (drawable == null) {
            drawable = (Drawable)((ComponentLifecycle)lifecycle).createMountContent(context);
        }
        LayoutOutput clickableOutput = LayoutState.findInteractiveRoot(this, output);
        boolean isStateEnabled = false;
        if (clickableOutput != null && clickableOutput.getNodeInfo() != null && ((nodeInfo = clickableOutput.getNodeInfo()).hasTouchEventHandlers() || nodeInfo.getFocusState() == 1)) {
            isStateEnabled = true;
        }
        if (isStateEnabled) {
            drawable.setState(DRAWABLE_STATE_ENABLED);
        } else {
            drawable.setState(DRAWABLE_STATE_NOT_ENABLED);
        }
        ((ComponentLifecycle)lifecycle).mount(component.getScopedContext() != null ? component.getScopedContext() : context, drawable, component);
        ((ComponentLifecycle)lifecycle).bind(context, drawable, component);
        Rect rect = this.mDisplayListCreateRect;
        output.getMountBounds(rect);
        drawable.setBounds(0, 0, rect.width(), rect.height());
        try {
            Canvas canvas = displayList.start(rect.width(), rect.height());
            drawable.draw(canvas);
            displayList.end(canvas);
            displayList.setBounds(rect.left, rect.top, rect.right, rect.bottom);
            output.setDisplayList(displayList);
        }
        catch (DisplayListException e) {
            output.setDisplayList(null);
        }
        ((ComponentLifecycle)lifecycle).unbind(context, drawable, component);
        ((ComponentLifecycle)lifecycle).unmount(context, drawable, component);
        ComponentsPools.release((Context)context, lifecycle, drawable);
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    private static void queueDisplayListsForPrefetch(LayoutState layoutState) {
        Rect rect = layoutState.mDisplayListQueueRect;
        int count = layoutState.getMountableOutputCount();
        for (int i = 0; i < count; ++i) {
            LayoutOutput output = layoutState.getMountableOutputAt(i);
            if (!LayoutState.shouldCreateDisplayList(output, rect)) continue;
            layoutState.mDisplayListsToPrefetch.add(i);
        }
        if (!layoutState.mDisplayListsToPrefetch.isEmpty()) {
            DisplayListPrefetcher.getInstance().addLayoutState(layoutState);
        }
    }

    public static boolean isEligibleForCreatingDisplayLists() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private static LayoutOutput findInteractiveRoot(LayoutState layoutState, LayoutOutput output) {
        if (output.getId() == 0L) {
            return output;
        }
        if ((output.getFlags() & 1) != 0) {
            int parentPosition = layoutState.getLayoutOutputPositionForId(output.getHostMarker());
            if (parentPosition >= 0) {
                LayoutOutput parent = layoutState.mMountableOutputs.get(parentPosition);
                if (parent == null) {
                    return null;
                }
                return LayoutState.findInteractiveRoot(layoutState, parent);
            }
            return null;
        }
        return output;
    }

    @VisibleForTesting
    static <T extends ComponentLifecycle> InternalNode createTree(Component<T> component, ComponentContext context) {
        ComponentsLogger logger = context.getLogger();
        LogEvent createLayoutEvent = null;
        if (logger != null) {
            createLayoutEvent = logger.newPerformanceEvent(0);
            createLayoutEvent.addParam("log_tag", context.getLogTag());
            createLayoutEvent.addParam("component", component.getSimpleName());
        }
        InternalNode root = (InternalNode)((ComponentLifecycle)component.getLifecycle()).createLayout(context, component, true);
        if (logger != null) {
            logger.log(createLayoutEvent);
        }
        return root;
    }

    @VisibleForTesting
    static void measureTree(InternalNode root, int widthSpec, int heightSpec, DiffNode previousDiffTreeRoot) {
        ComponentContext context = root.getContext();
        Component component = root.getRootComponent();
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("measureTree:" + component.getSimpleName());
        }
        if (YogaConstants.isUndefined((float)root.getStyleWidth())) {
            root.setStyleWidthFromSpec(widthSpec);
        }
        if (YogaConstants.isUndefined((float)root.getStyleHeight())) {
            root.setStyleHeightFromSpec(heightSpec);
        }
        if (previousDiffTreeRoot != null) {
            ComponentsSystrace.beginSection("applyDiffNode");
            LayoutState.applyDiffNodeToUnchangedNodes(root, previousDiffTreeRoot);
            ComponentsSystrace.endSection();
        }
        ComponentsLogger logger = context.getLogger();
        LogEvent layoutEvent = null;
        if (logger != null) {
            layoutEvent = logger.newPerformanceEvent(1);
            layoutEvent.addParam("log_tag", context.getLogTag());
            layoutEvent.addParam("tree_diff_enabled", String.valueOf(previousDiffTreeRoot != null));
        }
        root.calculateLayout(SizeSpec.getMode(widthSpec) == 0 ? Float.NaN : (float)SizeSpec.getSize(widthSpec), SizeSpec.getMode(heightSpec) == 0 ? Float.NaN : (float)SizeSpec.getSize(heightSpec));
        if (logger != null) {
            logger.log(layoutEvent);
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    static InternalNode resolveNestedTree(InternalNode nestedTreeHolder, int widthSpec, int heightSpec) {
        ComponentContext context = nestedTreeHolder.getContext();
        Component component = nestedTreeHolder.getRootComponent();
        InternalNode nestedTree = nestedTreeHolder.getNestedTree();
        if (nestedTree == null || !LayoutState.hasCompatibleSizeSpec(nestedTree.getLastWidthSpec(), nestedTree.getLastHeightSpec(), widthSpec, heightSpec, nestedTree.getLastMeasuredWidth(), nestedTree.getLastMeasuredHeight())) {
            if (nestedTree != null) {
                if (nestedTree != ComponentContext.NULL_LAYOUT) {
                    LayoutState.releaseNodeTree(nestedTree, true);
                }
                nestedTree = null;
            }
            if (component.hasCachedLayout()) {
                InternalNode cachedLayout = component.getCachedLayout();
                boolean hasCompatibleLayoutDirection = InternalNode.hasValidLayoutDirectionInNestedTree(nestedTreeHolder, cachedLayout);
                if (hasCompatibleLayoutDirection && LayoutState.hasCompatibleSizeSpec(cachedLayout.getLastWidthSpec(), cachedLayout.getLastHeightSpec(), widthSpec, heightSpec, cachedLayout.getLastMeasuredWidth(), cachedLayout.getLastMeasuredHeight())) {
                    nestedTree = cachedLayout;
                    component.clearCachedLayout();
                } else {
                    component.releaseCachedLayout();
                }
            }
            if (nestedTree == null) {
                nestedTree = LayoutState.createAndMeasureTreeForComponent(context, component, nestedTreeHolder, widthSpec, heightSpec, nestedTreeHolder.getDiffNode());
                nestedTree.setLastWidthSpec(widthSpec);
                nestedTree.setLastHeightSpec(heightSpec);
                nestedTree.setLastMeasuredHeight(nestedTree.getHeight());
                nestedTree.setLastMeasuredWidth(nestedTree.getWidth());
            }
            nestedTreeHolder.setNestedTree(nestedTree);
        }
        InternalNode.assertContextSpecificStyleNotSet(nestedTree);
        return nestedTree;
    }

    static InternalNode createAndMeasureTreeForComponent(ComponentContext c, Component component, int widthSpec, int heightSpec) {
        return LayoutState.createAndMeasureTreeForComponent(c, component, null, widthSpec, heightSpec, null);
    }

    private static InternalNode createAndMeasureTreeForComponent(ComponentContext c, Component component, InternalNode nestedTreeHolder, int widthSpec, int heightSpec, DiffNode diffTreeRoot) {
        boolean hasNestedTreeHolder;
        boolean isTest = "robolectric".equals(Build.FINGERPRINT);
        if (!isTest) {
            c = c.makeNewCopy();
        }
        boolean bl = hasNestedTreeHolder = nestedTreeHolder != null;
        if (hasNestedTreeHolder) {
            c.setTreeProps(nestedTreeHolder.getPendingTreeProps());
        } else if (!isTest) {
            c.setTreeProps(null);
        }
        int previousWidthSpec = c.getWidthSpec();
        int previousHeightSpec = c.getHeightSpec();
        c.setWidthSpec(widthSpec);
        c.setHeightSpec(heightSpec);
        InternalNode root = LayoutState.createTree(component, c);
        if (hasNestedTreeHolder) {
            c.setTreeProps(null);
        }
        c.setWidthSpec(previousWidthSpec);
        c.setHeightSpec(previousHeightSpec);
        if (root == ComponentContext.NULL_LAYOUT) {
            return root;
        }
        if (hasNestedTreeHolder && Component.isLayoutSpecWithSizeSpec(component)) {
            nestedTreeHolder.copyInto(root);
            diffTreeRoot = nestedTreeHolder.getDiffNode();
        } else if (root.getStyleDirection() == YogaDirection.INHERIT && LayoutState.isLayoutDirectionRTL((Context)c)) {
            root.layoutDirection(YogaDirection.RTL);
        }
        LayoutState.measureTree(root, widthSpec, heightSpec, diffTreeRoot);
        return root;
    }

    static DiffNode createDiffNode(InternalNode node, DiffNode parent) {
        ComponentsSystrace.beginSection("diff_node_creation");
        DiffNode diffNode = ComponentsPools.acquireDiffNode();
        diffNode.setLastWidthSpec(node.getLastWidthSpec());
        diffNode.setLastHeightSpec(node.getLastHeightSpec());
        diffNode.setLastMeasuredWidth(node.getLastMeasuredWidth());
        diffNode.setLastMeasuredHeight(node.getLastMeasuredHeight());
        diffNode.setComponent(node.getRootComponent());
        if (parent != null) {
            parent.addChild(diffNode);
        }
        ComponentsSystrace.endSection();
        return diffNode;
    }

    boolean isCompatibleSpec(int widthSpec, int heightSpec) {
        boolean widthIsCompatible = MeasureComparisonUtils.isMeasureSpecCompatible(this.mWidthSpec, widthSpec, this.mWidth);
        boolean heightIsCompatible = MeasureComparisonUtils.isMeasureSpecCompatible(this.mHeightSpec, heightSpec, this.mHeight);
        return widthIsCompatible && heightIsCompatible;
    }

    boolean isCompatibleAccessibility() {
        return LayoutState.isAccessibilityEnabled(this.mAccessibilityManager) == this.mAccessibilityEnabled;
    }

    private static boolean isAccessibilityEnabled(AccessibilityManager accessibilityManager) {
        return accessibilityManager.isEnabled() && AccessibilityManagerCompat.isTouchExplorationEnabled((AccessibilityManager)accessibilityManager);
    }

    static boolean applyDiffNodeToUnchangedNodes(InternalNode layoutNode, DiffNode diffNode) {
        boolean isTreeRoot;
        boolean bl = isTreeRoot = layoutNode.getParent() == null;
        if (Component.isLayoutSpecWithSizeSpec(layoutNode.getRootComponent()) && !isTreeRoot) {
            layoutNode.setDiffNode(diffNode);
            return true;
        }
        if (!LayoutState.hostIsCompatible(layoutNode, diffNode)) {
            return true;
        }
        layoutNode.setDiffNode(diffNode);
        int layoutCount = layoutNode.getChildCount();
        int diffCount = diffNode.getChildCount();
        boolean shouldUpdate = layoutCount != diffCount;
        for (int i = 0; i < layoutCount && i < diffCount; ++i) {
            boolean shouldUpdateChild = LayoutState.applyDiffNodeToUnchangedNodes(layoutNode.getChildAt(i), diffNode.getChildAt(i));
            shouldUpdate |= shouldUpdateChild;
        }
        if (!(shouldUpdate |= LayoutState.shouldComponentUpdate(layoutNode, diffNode))) {
            LayoutState.applyDiffNodeToLayoutNode(layoutNode, diffNode);
        }
        return shouldUpdate;
    }

    private static void applyDiffNodeToLayoutNode(InternalNode layoutNode, DiffNode diffNode) {
        Component component = layoutNode.getRootComponent();
        if (component != null) {
            component.copyInterStageImpl(diffNode.getComponent());
        }
        layoutNode.setCachedMeasuresValid(true);
    }

    private static boolean hostIsCompatible(InternalNode node, DiffNode diffNode) {
        if (diffNode == null) {
            return false;
        }
        return LayoutState.isSameComponentType(node.getRootComponent(), diffNode.getComponent());
    }

    private static boolean isSameComponentType(Component a, Component b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getLifecycle().getClass().equals(b.getLifecycle().getClass());
    }

    private static boolean shouldComponentUpdate(InternalNode layoutNode, DiffNode diffNode) {
        if (diffNode == null) {
            return true;
        }
        Component component = layoutNode.getRootComponent();
        if (component != null) {
            return ((ComponentLifecycle)component.getLifecycle()).shouldComponentUpdate(component, diffNode.getComponent());
        }
        return true;
    }

    boolean isCompatibleComponentAndSpec(int componentId, int widthSpec, int heightSpec) {
        return this.mComponent.getId() == componentId && this.isCompatibleSpec(widthSpec, heightSpec);
    }

    boolean isCompatibleSize(int width, int height) {
        return this.mWidth == width && this.mHeight == height;
    }

    boolean isComponentId(int componentId) {
        return this.mComponent.getId() == componentId;
    }

    int getMountableOutputCount() {
        return this.mMountableOutputs.size();
    }

    LayoutOutput getMountableOutputAt(int index) {
        return this.mMountableOutputs.get(index);
    }

    ArrayList<LayoutOutput> getMountableOutputTops() {
        return this.mMountableOutputTops;
    }

    ArrayList<LayoutOutput> getMountableOutputBottoms() {
        return this.mMountableOutputBottoms;
    }

    int getVisibilityOutputCount() {
        return this.mVisibilityOutputs.size();
    }

    VisibilityOutput getVisibilityOutputAt(int index) {
        return this.mVisibilityOutputs.get(index);
    }

    int getTestOutputCount() {
        return this.mTestOutputs == null ? 0 : this.mTestOutputs.size();
    }

    TestOutput getTestOutputAt(int index) {
        return this.mTestOutputs == null ? null : this.mTestOutputs.get(index);
    }

    public DiffNode getDiffTree() {
        return this.mDiffTreeRoot;
    }

    int getWidth() {
        return this.mWidth;
    }

    int getHeight() {
        return this.mHeight;
    }

    int getComponentTreeId() {
        return this.mComponentTreeId;
    }

    @ThreadSafe(enableChecks=false)
    void releaseRef() {
        int count = this.mReferenceCount.decrementAndGet();
        if (count < 0) {
            throw new IllegalStateException("Trying to releaseRef a recycled LayoutState");
        }
        if (count == 0) {
            int i;
            this.mContext = null;
            this.mComponent = null;
            this.mWidth = 0;
            this.mHeight = 0;
            this.mCurrentX = 0;
            this.mCurrentY = 0;
            this.mCurrentHostMarker = -1L;
            this.mCurrentHostOutputPosition = -1;
            this.mComponentTreeId = -1;
            this.mShouldDuplicateParentState = true;
            this.mIsTransitionKeySet = false;
            this.mClipChildren = true;
            int size = this.mMountableOutputs.size();
            for (int i2 = 0; i2 < size; ++i2) {
                ComponentsPools.release(this.mMountableOutputs.get(i2));
            }
            this.mMountableOutputs.clear();
            this.mMountableOutputTops.clear();
            this.mMountableOutputBottoms.clear();
            this.mOutputsIdToPositionMap.clear();
            this.mDisplayListsToPrefetch.clear();
            for (Rect rect : this.mComponentKeyToBounds.values()) {
                ComponentsPools.release(rect);
            }
            this.mComponentKeyToBounds.clear();
            size = this.mVisibilityOutputs.size();
            for (i = 0; i < size; ++i) {
                ComponentsPools.release(this.mVisibilityOutputs.get(i));
            }
            this.mVisibilityOutputs.clear();
            if (this.mTestOutputs != null) {
                size = this.mTestOutputs.size();
                for (i = 0; i < size; ++i) {
                    ComponentsPools.release(this.mTestOutputs.get(i));
                }
                this.mTestOutputs.clear();
            }
            this.mShouldGenerateDiffTree = false;
            this.mAccessibilityManager = null;
            this.mAccessibilityEnabled = false;
            if (this.mDiffTreeRoot != null) {
                ComponentsPools.release(this.mDiffTreeRoot);
                this.mDiffTreeRoot = null;
            }
            this.mLayoutStateOutputIdCalculator.clear();
            if (this.mTransitionContext != null) {
                ComponentsPools.release(this.mTransitionContext);
                this.mTransitionContext = null;
            }
            if (this.mLayoutRoot != null) {
                LayoutState.releaseNodeTree(this.mLayoutRoot, false);
                this.mLayoutRoot = null;
            }
            if (this.mComponentsNeedingPreviousRenderData != null) {
                this.mComponentsNeedingPreviousRenderData.clear();
            }
            this.mTransitionKeyMapping = null;
            this.mHasLithoViewBoundsAnimation = false;
            ComponentsPools.release(this);
        }
    }

    LayoutState acquireRef() {
        if (this.mReferenceCount.getAndIncrement() == 0) {
            throw new IllegalStateException("Trying to use a released LayoutState");
        }
        return this;
    }

    StateHandler consumeStateHandler() {
        StateHandler stateHandler = this.mStateHandler;
        this.mStateHandler = null;
        return stateHandler;
    }

    InternalNode getLayoutRoot() {
        return this.mLayoutRoot;
    }

    private boolean isLayoutRoot(InternalNode node) {
        return this.mLayoutRoot.isNestedTreeHolder() ? node == this.mLayoutRoot.getNestedTree() : node == this.mLayoutRoot;
    }

    public static boolean hasCompatibleSizeSpec(int oldWidthSpec, int oldHeightSpec, int newWidthSpec, int newHeightSpec, float oldMeasuredWidth, float oldMeasuredHeight) {
        boolean widthIsCompatible = MeasureComparisonUtils.isMeasureSpecCompatible(oldWidthSpec, newWidthSpec, (int)oldMeasuredWidth);
        boolean heightIsCompatible = MeasureComparisonUtils.isMeasureSpecCompatible(oldHeightSpec, newHeightSpec, (int)oldMeasuredHeight);
        return widthIsCompatible && heightIsCompatible;
    }

    private static boolean needsHostView(InternalNode node, LayoutState layoutState) {
        return layoutState.isLayoutRoot(node) || !Component.isMountViewSpec(node.getRootComponent()) && (LayoutState.hasViewContent(node, layoutState) || node.isForceViewWrapping());
    }

    int getLayoutOutputPositionForId(long layoutOutputId) {
        return (Integer)this.mOutputsIdToPositionMap.get(layoutOutputId, (Object)-1);
    }

    TransitionContext getTransitionContext() {
        return this.mTransitionContext;
    }

    boolean hasTransitionContext() {
        return this.mTransitionContext != null;
    }

    SimpleArrayMap<String, LayoutOutput> getTransitionKeyMapping() {
        if (this.mTransitionKeyMapping != null) {
            return this.mTransitionKeyMapping;
        }
        this.mTransitionKeyMapping = new SimpleArrayMap();
        int size = this.getMountableOutputCount();
        for (int i = 0; i < size; ++i) {
            LayoutOutput newOutput = this.getMountableOutputAt(i);
            String transitionKey = newOutput.getTransitionKey();
            if (transitionKey == null) continue;
            this.mTransitionKeyMapping.put((Object)transitionKey, (Object)newOutput);
        }
        return this.mTransitionKeyMapping;
    }

    LayoutOutput getLayoutOutputForTransitionKey(String transitionKey) {
        return (LayoutOutput)this.getTransitionKeyMapping().get((Object)transitionKey);
    }

    private static void addMountableOutput(LayoutState layoutState, LayoutOutput layoutOutput) {
        layoutState.mMountableOutputs.add(layoutOutput);
        layoutState.mMountableOutputTops.add(layoutOutput);
        layoutState.mMountableOutputBottoms.add(layoutOutput);
    }

    private TransitionContext getOrCreateTransitionContext() {
        if (this.mTransitionContext == null) {
            this.mTransitionContext = ComponentsPools.acquireTransitionContext();
        }
        return this.mTransitionContext;
    }

    boolean hasLithoViewBoundsAnimation() {
        return this.mHasLithoViewBoundsAnimation;
    }

    boolean hasItemsForDLPrefetch() {
        return !this.mDisplayListsToPrefetch.isEmpty();
    }

    void trimDisplayListItemsQueue() {
        LayoutOutput layoutOutput;
        if (this.mMountableOutputs.isEmpty()) {
            this.mDisplayListsToPrefetch.clear();
            return;
        }
        Integer currentIndex = this.mDisplayListsToPrefetch.peek();
        while (currentIndex != null && (!(layoutOutput = this.mMountableOutputs.get(currentIndex)).hasDisplayListContainer() || layoutOutput.hasValidDisplayList())) {
            this.mDisplayListsToPrefetch.remove();
            currentIndex = this.mDisplayListsToPrefetch.peek();
        }
    }

    LayoutOutput getNextLayoutOutputForDLPrefetch() {
        int layoutOutputIndex = this.mDisplayListsToPrefetch.poll();
        return this.getMountableOutputAt(layoutOutputIndex);
    }

    @Nullable
    List<Component> getComponentsNeedingPreviousRenderData() {
        return this.mComponentsNeedingPreviousRenderData;
    }
}

